/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.importexport.actions.ICalExportRequest;
import com.openexchange.ajax.importexport.actions.ICalExportResponse;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalSession;
import com.openexchange.data.conversion.ical.ical4j.ICal4JEmitter;
import com.openexchange.data.conversion.ical.ical4j.ICal4JParser;
import com.openexchange.data.conversion.ical.ical4j.internal.UserResolver;
import com.openexchange.data.conversion.ical.ical4j.internal.calendar.Participants;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.importexport.formats.Format;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Deprecated
public class AbstractICalTest
extends AbstractAJAXTest {
    protected static final String IMPORT_URL = "/ajax/import";
    protected static final String EXPORT_URL = "/ajax/export";
    protected Date startTime = null;
    protected Date endTime = null;
    protected int appointmentFolderId = -1;
    protected int taskFolderId = -1;
    protected int userId = -1;
    protected String emailaddress = null;
    protected TimeZone timeZone = null;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractICalTest.class);

    public AbstractICalTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        FolderObject appointmentFolderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        this.appointmentFolderId = appointmentFolderObj.getObjectID();
        FolderObject taskFolderObj = FolderTest.getStandardTaskFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        this.taskFolderId = taskFolderObj.getObjectID();
        this.userId = appointmentFolderObj.getCreatedBy();
        this.timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
        LOG.debug("use timezone: " + this.timeZone);
        Contact contactObj = ContactTest.loadUser(this.getWebConversation(), this.userId, 6, this.getHostName(), this.getSessionId());
        this.emailaddress = contactObj.getEmail1();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(this.timeZone);
        c.set(11, 8);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.startTime = c.getTime();
        this.endTime = new Date(this.startTime.getTime() + 3600000L);
        Participants.userResolver = new UserResolver(){

            public List<User> findUsers(List<String> mails, Context ctx) {
                return new ArrayList<User>();
            }

            public User loadUser(int userId, Context ctx) {
                return null;
            }
        };
    }

    public static ImportResult[] importICal(WebConversation webCon, Appointment[] appointments, int folderId, String host, String session) throws ConversionError, OXException, IOException, SAXException, JSONException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ICal4JEmitter emitter = new ICal4JEmitter();
        ICalSession icalSession = emitter.createSession();
        for (int a = 0; a < appointments.length; ++a) {
            emitter.writeAppointment(icalSession, appointments[a], null, new LinkedList(), new LinkedList());
        }
        emitter.writeSession(icalSession, (OutputStream)baos);
        ByteArrayInputStream input = new ByteArrayInputStream(baos.toByteArray());
        return AbstractICalTest.importICal(webCon, input, folderId, host, session);
    }

    public static ImportResult[] importICal(WebConversation webCon, Task[] tasks, int folderId, String host, String session) throws OXException, IOException, SAXException, JSONException, ConversionError {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ICal4JEmitter emitter = new ICal4JEmitter();
        ICalSession icalSession = emitter.createSession();
        for (int a = 0; a < tasks.length; ++a) {
            emitter.writeTask(icalSession, tasks[a], null, new LinkedList(), new LinkedList());
        }
        emitter.writeSession(icalSession, (OutputStream)baos);
        ByteArrayInputStream input = new ByteArrayInputStream(baos.toByteArray());
        return AbstractICalTest.importICal(webCon, input, folderId, host, session);
    }

    public static ImportResult[] importICal(WebConversation webCon, InputStream input, int folderId, String host, String session) throws OXException, IOException, SAXException, JSONException {
        AJAXSession aSession = new AJAXSession(webCon, host, session);
        ICalImportRequest request = new ICalImportRequest(folderId, input);
        ICalImportResponse iResponse = Executor.execute(aSession, request, host);
        return iResponse.getImports();
    }

    public Appointment[] exportAppointment(WebConversation webCon, int folderId, TimeZone timeZone, String host, String session, Context ctx) throws IOException, SAXException, ConversionWarning, OXException, JSONException {
        AJAXSession aSession = new AJAXSession(webCon, host, session);
        ICalExportRequest request = new ICalExportRequest(folderId);
        ICalExportResponse response = Executor.execute(aSession, request);
        ICal4JParser parser = new ICal4JParser();
        LinkedList errors = new LinkedList();
        LinkedList warnings = new LinkedList();
        List exportData = parser.parseAppointments(response.getICal(), timeZone, ctx, errors, warnings);
        if (!errors.isEmpty()) {
            throw (ConversionError)errors.get(0);
        }
        if (!warnings.isEmpty()) {
            throw (ConversionWarning)warnings.get(0);
        }
        return exportData.toArray(new Appointment[exportData.size()]);
    }

    public Task[] exportTask(WebConversation webCon, int inFolder, String mailaddress, TimeZone timeZone, String host, String session, Context ctx) throws Exception, OXException {
        host = AbstractICalTest.appendPrefix(host);
        URLParameter parameter = new URLParameter(true);
        parameter.setParameter("session", session);
        parameter.setParameter("action", Format.ICAL.getConstantName());
        parameter.setParameter("folder", this.taskFolderId);
        parameter.setParameter("type", 4);
        GetMethodWebRequest req = new GetMethodWebRequest(host + EXPORT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AbstractICalTest.assertEquals((int)200, (int)resp.getResponseCode());
        List exportData = new ArrayList();
        ICal4JParser parser = new ICal4JParser();
        LinkedList errors = new LinkedList();
        LinkedList warnings = new LinkedList();
        exportData = parser.parseTasks(resp.getInputStream(), timeZone, ctx, errors, warnings);
        return exportData.toArray(new Task[exportData.size()]);
    }
}

