/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;

public class Bug17027Test
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 2, 3, 4, 5, 6, 20, 300, 301, 302, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 3010, 3020};
    private AJAXClient client;
    private FolderObject createdFolder;
    private Date before;
    private boolean folderDeleted = false;

    public Bug17027Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.createdFolder = Create.createPrivateFolder("Test for bug 17027", 2, this.client.getValues().getUserId(), new OCLPermission[0]);
        this.createdFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        InsertResponse response = this.client.execute(new InsertRequest(EnumAPI.OX_NEW, this.createdFolder));
        response.fillObject((DataObject)this.createdFolder);
        this.before = new Date(this.createdFolder.getLastModified().getTime() - 1L);
    }

    @Override
    protected void tearDown() throws Exception {
        if (!this.folderDeleted) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.createdFolder));
        }
        super.tearDown();
    }

    public void testUpdates() throws Throwable {
        FolderUpdatesResponse response = this.client.execute(new UpdatesRequest(EnumAPI.OX_NEW, -1, COLUMNS, -1, null, this.before, AbstractUpdatesRequest.Ignore.NONE));
        boolean found = false;
        for (FolderObject folder : response.getFolders()) {
            if (this.createdFolder.getObjectID() != folder.getObjectID()) continue;
            found = true;
        }
        Bug17027Test.assertTrue((String)"Newly created folder not found.", (boolean)found);
        Bug17027Test.assertFalse((String)"Newly created folder should not be contained in deleted list.", (boolean)response.getDeletedIds().contains(Autoboxing.I((int)this.createdFolder.getObjectID())));
        this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.createdFolder));
        this.folderDeleted = true;
        response = this.client.execute(new UpdatesRequest(EnumAPI.OX_NEW, -1, COLUMNS, -1, null, this.before, AbstractUpdatesRequest.Ignore.NONE));
        for (FolderObject folder : response.getFolders()) {
            Bug17027Test.assertFalse((String)"By other user newly created private folder is returned in updates response.", (this.createdFolder.getObjectID() == folder.getObjectID() ? 1 : 0) != 0);
        }
        Bug17027Test.assertTrue((String)"Deleted list should contain deleted folder identifier.", (boolean)response.getDeletedIds().contains(Autoboxing.I((int)this.createdFolder.getObjectID())));
    }
}

