/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;

public class Bug16107Test
extends ManagedAppointmentTest {
    private Appointment startAppointment;
    private Appointment updateAppointment;

    public Bug16107Test(String name) throws Exception {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startAppointment = new Appointment();
        this.startAppointment.setParentFolderID(this.folder.getObjectID());
        this.startAppointment.setTitle("Bug 16107");
        this.startAppointment.setStartDate(this.D("24.05.2010 00:00"));
        this.startAppointment.setEndDate(this.D("25.05.2010 00:00"));
        this.startAppointment.setRecurrenceType(1);
        this.startAppointment.setUntil(this.D("11.06.2010 07:30"));
        this.startAppointment.setFullTime(true);
        this.startAppointment.setInterval(1);
        this.updateAppointment = new Appointment();
        this.updateAppointment.setTitle("Bug 16107 (updated)");
        this.updateAppointment.setStartDate(this.D("24.05.2010 07:00"));
        this.updateAppointment.setEndDate(this.D("24.05.2010 07:30"));
        this.updateAppointment.setFullTime(false);
        this.updateAppointment.setRecurrenceType(1);
        this.updateAppointment.setRecurrencePosition(0);
        this.updateAppointment.setInterval(1);
        this.updateAppointment.setRecurringStart(this.D("24.05.2010 00:00").getTime());
        this.updateAppointment.setUntil(this.D("11.06.2010 07:30"));
        this.calendarManager.insert(this.startAppointment);
        this.link(this.startAppointment, this.updateAppointment);
        this.updateAppointment.setRecurrenceID(this.startAppointment.getObjectID());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFirstMonthView() {
        Date start = this.D("26.04.2010 00:00");
        Date end = this.D("07.06.2010 00:00");
        int occurences = 14;
        this.check("month view", start, end, occurences);
    }

    public void testLastMonthView() {
        Date start = this.D("31.05.2010 00:00");
        Date end = this.D("05.07.2010 00:00");
        int occurences = 12;
        this.check("month view", start, end, occurences);
    }

    public void testNextToLastWorkWeekView() {
        Date start = this.D("31.05.2010 00:00");
        Date end = this.D("05.06.2010 00:00");
        int occurences = 5;
        this.check("work week view (next-to-last week)", start, end, occurences);
    }

    public void testLastWorkWeekView() {
        Date start = this.D("07.06.2010 00:00");
        Date end = this.D("12.06.2010 00:00");
        int occurences = 5;
        this.check("work week view (last week)", start, end, occurences);
    }

    private void check(String name, Date start, Date end, int occurences) {
        int count = 0;
        this.calendarManager.update(this.updateAppointment);
        Appointment[] all = this.calendarManager.all(this.folder.getObjectID(), start, end, new int[]{1, 20, 207, 206, 2});
        Bug16107Test.assertEquals((String)("AllRequest should find updated appointment in " + name), (int)1, (int)all.length);
        boolean[] has = this.calendarManager.has(start, end);
        count = 0;
        for (boolean b : has) {
            if (!b) continue;
            ++count;
        }
        Bug16107Test.assertEquals((String)("HasRequest should find the right amount of occurences in updated " + name), (int)occurences, (int)count);
    }
}

