/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.webdav.protocol.WebdavMultistatusException;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavStatus;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Multistatus<T>
implements Iterable<WebdavStatus<T>> {
    private final List<WebdavStatus<T>> stadi = new ArrayList<WebdavStatus<T>>();
    private final TIntObjectMap<List<WebdavStatus<T>>> rcMap = new TIntObjectHashMap();

    public Multistatus() {
    }

    public Multistatus(WebdavMultistatusException x) {
        WebdavProtocolException[] arr$ = x.getExceptions();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            WebdavProtocolException e;
            WebdavProtocolException status = e = arr$[i$];
            this.addStatus(status);
        }
    }

    public void addStatus(WebdavStatus<T> status) {
        this.stadi.add(status);
        ArrayList<WebdavStatus<T>> collocated = (ArrayList<WebdavStatus<T>>)this.rcMap.get(status.getStatus());
        if (null == collocated) {
            collocated = new ArrayList<WebdavStatus<T>>();
            this.rcMap.put(status.getStatus(), collocated);
        }
        collocated.add(status);
    }

    @Override
    public Iterator<WebdavStatus<T>> iterator() {
        return this.stadi.iterator();
    }

    public Iterable<WebdavStatus<T>> toIterable(int status) {
        return (Iterable)this.rcMap.get(status);
    }

    public int[] getStatusCodes() {
        return this.rcMap.keys();
    }
}

