/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.java.Charsets;
import com.openexchange.tools.versit.ObjectDefinition;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.PropertyDefinition;
import com.openexchange.tools.versit.ReaderScanner;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.VersitObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VersionedObjectDefinition
extends ObjectDefinition {
    private final Map<String, ObjectDefinition> Definitions = new HashMap<String, ObjectDefinition>();
    private ObjectDefinition Definition = ObjectDefinition.Default;

    public VersionedObjectDefinition() {
    }

    private VersionedObjectDefinition(Map<String, ObjectDefinition> definitions, ObjectDefinition definition) {
        int size = definitions.size();
        Iterator<Map.Entry<String, ObjectDefinition>> iter = definitions.entrySet().iterator();
        for (int k = 0; k < size; ++k) {
            Map.Entry<String, ObjectDefinition> entry = iter.next();
            ObjectDefinition od = entry.getValue();
            ObjectDefinition copy = (ObjectDefinition)od.copy();
            this.addDefinition(entry.getKey(), copy);
            if (!od.equals(definition)) continue;
            this.Definition = copy;
        }
        this.Definition = definition;
    }

    public VersionedObjectDefinition(String[] versions, ObjectDefinition[] definitions) {
        for (int i = 0; i < versions.length; ++i) {
            this.addDefinition(versions[i], definitions[i]);
        }
    }

    public final void addDefinition(String version2, ObjectDefinition definition) {
        if (this.Definitions.isEmpty()) {
            this.Definition = definition;
        }
        this.Definitions.put(version2, definition);
    }

    public void setVersion(String version2) {
        this.Definition = this.Definitions.get(version2);
        if (this.Definition == null) {
            this.Definition = ObjectDefinition.Default;
        }
    }

    @Override
    public VersitDefinition.Reader getReader(InputStream stream, String charset) throws IOException {
        return new ReaderScanner(new InputStreamReader(stream, Charsets.forName((String)charset)));
    }

    @Override
    public VersitObject parseChild(VersitDefinition.Reader reader, VersitObject object) throws IOException {
        Scanner s = (Scanner)reader;
        Property property = this.Definition.parseProperty(s);
        while (!(property == null || property.name.equalsIgnoreCase("END") && ((String)property.getValue()).equalsIgnoreCase(object.name))) {
            if (property.name.equalsIgnoreCase("BEGIN")) {
                VersitObject grandchild;
                String childName = ((String)property.getValue()).toUpperCase();
                VersitDefinition def = this.Definition.getChildDef(childName);
                VersitObject child = new VersitObject(childName);
                while ((grandchild = def.parseChild(s, child)) != null) {
                    child.addChild(grandchild);
                }
                return child;
            }
            if (!property.isInvalid()) {
                object.addProperty(property);
            }
            if (property.name.equalsIgnoreCase("VERSION")) {
                this.setVersion(property.getValue().toString());
            }
            property = this.Definition.parseProperty(s);
        }
        if (property == null) {
            throw new VersitException(s, "Incomplete object");
        }
        return null;
    }

    @Override
    public void write(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        Property VersionProperty = object.getProperty("VERSION");
        if (VersionProperty != null) {
            this.setVersion((String)VersionProperty.getValue());
        }
        this.Definition.write(writer, object);
    }

    @Override
    public void writeProperties(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        Property VersionProperty = object.getProperty("VERSION");
        if (VersionProperty != null) {
            this.setVersion((String)VersionProperty.getValue());
        }
        this.Definition.writeProperties(writer, object);
    }

    @Override
    public void writeEnd(VersitDefinition.Writer writer, VersitObject object) throws IOException {
        this.Definition.writeEnd(writer, object);
    }

    @Override
    public VersitDefinition getChildDef(String name) {
        return this.Definition.getChildDef(name);
    }

    @Override
    public Iterator<PropertyDefinition> iterator() {
        return this.Definition.iterator();
    }

    @Override
    public VersitDefinition copy() {
        return new VersionedObjectDefinition(this.Definitions, this.Definition);
    }
}

