/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.FoldingWriter;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.ParameterValue;
import com.openexchange.tools.versit.ParameterValueDefinition;
import com.openexchange.tools.versit.Scanner;
import java.io.IOException;

public class ParameterDefinition {
    public final ParameterValueDefinition value;
    public static final ParameterDefinition Default = new ParameterDefinition(ParameterValueDefinition.Default);

    public ParameterDefinition(ParameterValueDefinition value) {
        this.value = value;
    }

    public Parameter parse(Scanner s, String name) throws IOException {
        if (s.peek != 61) {
            return null;
        }
        Parameter parameter = new Parameter(name);
        do {
            s.read();
            ParameterValue parameterValue = this.value.parse(s);
            if (parameterValue == null) {
                return null;
            }
            parameter.addValue(parameterValue);
        } while (s.peek == 44);
        return parameter;
    }

    public void write(FoldingWriter fw, Parameter parameter) throws IOException {
        fw.write(";");
        fw.write(parameter.name);
        fw.write("=");
        int valueCount = parameter.getValueCount();
        if (valueCount > 0) {
            this.value.write(fw, parameter.getValue(0));
            for (int j = 1; j < valueCount; ++j) {
                fw.write(",");
                this.value.write(fw, parameter.getValue(j));
            }
        }
    }
}

