/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.service;

import com.openexchange.tools.service.ServicePriorityConflictException;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificServiceChooser<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificServiceChooser.class);
    private final SortedSet<WeightedRegistration<T>> general = new TreeSet<WeightedRegistration<T>>();
    private final TIntObjectMap<SortedSet<WeightedRegistration<T>>> contextSpecific = new TIntObjectHashMap();
    private final Map<String, SortedSet<WeightedRegistration<T>>> folderSpecific = new HashMap<String, SortedSet<WeightedRegistration<T>>>();
    private final TIntObjectMap<Map<String, SortedSet<WeightedRegistration<T>>>> contextAndFolderSpecific = new TIntObjectHashMap();

    public synchronized void registerForEverything(T serviceInstance, int ranking) throws ServicePriorityConflictException {
        this.add(this.general, serviceInstance, ranking);
    }

    public synchronized void removeForEverything(T serviceInstance) {
        this.remove(this.general, serviceInstance);
    }

    private void remove(SortedSet<WeightedRegistration<T>> set, T serviceInstance) {
        if (set == null) {
            return;
        }
        HashSet<WeightedRegistration> remove = new HashSet<WeightedRegistration>();
        for (WeightedRegistration weightedRegistration : set) {
            if (!weightedRegistration.payload.equals(serviceInstance)) continue;
            remove.add(weightedRegistration);
        }
        set.removeAll(remove);
    }

    private void add(SortedSet<WeightedRegistration<T>> set, T serviceInstance, int ranking) throws ServicePriorityConflictException {
        this.notNull(serviceInstance);
        WeightedRegistration newRegistration = new WeightedRegistration(ranking);
        newRegistration.payload = serviceInstance;
        if (!set.add(newRegistration)) {
            throw new ServicePriorityConflictException();
        }
    }

    private void notNull(T serviceInstance) {
        if (serviceInstance == null) {
            LOG.error("Trying to register Null Service!");
            throw new NullPointerException("Service Instance may not be null!");
        }
    }

    public synchronized void registerForContext(T serviceInstance, int ranking, int cid) throws ServicePriorityConflictException {
        if (!this.contextSpecific.containsKey(cid)) {
            this.contextSpecific.put(cid, new TreeSet());
        }
        this.add((SortedSet)this.contextSpecific.get(cid), serviceInstance, ranking);
    }

    public synchronized void removeForContext(T serviceInstance, int cid) {
        if (this.contextSpecific.containsKey(cid)) {
            this.remove((SortedSet)this.contextSpecific.get(cid), serviceInstance);
        }
    }

    public synchronized void registerForContextAndFolder(T serviceInstance, int ranking, int cid, int folderId) throws ServicePriorityConflictException {
        this.registerForContextAndFolder(serviceInstance, ranking, cid, String.valueOf(folderId));
    }

    public synchronized void removeForContextAndFolder(T serviceInstance, int cid, int folderId) {
        this.removeForContextAndFolder(serviceInstance, cid, String.valueOf(folderId));
    }

    public synchronized void registerForContextAndFolder(T serviceInstance, int ranking, int cid, String folderId) throws ServicePriorityConflictException {
        HashMap folderSpecific = (HashMap)this.contextAndFolderSpecific.get(cid);
        if (folderSpecific == null) {
            folderSpecific = new HashMap();
            this.contextAndFolderSpecific.put(cid, folderSpecific);
        }
        if (!folderSpecific.containsKey(folderId)) {
            folderSpecific.put(folderId, new TreeSet());
        }
        this.add((SortedSet)folderSpecific.get(folderId), serviceInstance, ranking);
    }

    public synchronized void removeForContextAndFolder(T serviceInstance, int cid, String folderId) {
        Map folderSpecific = (Map)this.contextAndFolderSpecific.get(cid);
        if (folderSpecific == null) {
            return;
        }
        SortedSet registeredServices = (SortedSet)folderSpecific.get(folderId);
        this.remove(registeredServices, serviceInstance);
    }

    public void registerForFolder(T serviceInstance, int ranking, int folderId) throws ServicePriorityConflictException {
        this.registerForFolder(serviceInstance, ranking, String.valueOf(folderId));
    }

    public synchronized void registerForFolder(T serviceInstance, int ranking, String folderId) throws ServicePriorityConflictException {
        if (!this.folderSpecific.containsKey(folderId)) {
            this.folderSpecific.put(folderId, new TreeSet());
        }
        this.add(this.folderSpecific.get(folderId), serviceInstance, ranking);
    }

    public void removeForFolder(T serviceInstance, int folderId) {
        this.removeForFolder(serviceInstance, String.valueOf(folderId));
    }

    public synchronized void removeForFolder(T serviceInstance, String folderId) {
        this.remove(this.folderSpecific.get(folderId), serviceInstance);
    }

    public T choose(int cid, int folderId) throws ServicePriorityConflictException {
        return this.choose(cid, String.valueOf(folderId));
    }

    public T choose(int cid, String folderId) throws ServicePriorityConflictException {
        T service = this.tryFolderSpecific(cid, folderId);
        if (service != null) {
            return service;
        }
        WeightedRegistration<T> contextSpecific = this.tryContextSpecific(cid);
        WeightedRegistration<T> folderSpecific = this.tryFolderSpecific(folderId);
        if (contextSpecific != null || folderSpecific != null) {
            return this.bestMatch(contextSpecific, folderSpecific);
        }
        if (this.general.isEmpty()) {
            return null;
        }
        return this.general.first().getPayload();
    }

    private T bestMatch(WeightedRegistration<T> reg1, WeightedRegistration<T> reg2) throws ServicePriorityConflictException {
        if (reg1 == null && reg2 == null) {
            return null;
        }
        if (reg1 == null) {
            return reg2.getPayload();
        }
        if (reg2 == null) {
            return reg1.getPayload();
        }
        if (reg1.ranking > reg2.ranking) {
            return reg1.getPayload();
        }
        if (reg2.ranking > reg1.ranking) {
            return reg2.getPayload();
        }
        if (reg1.ranking == reg2.ranking) {
            throw new ServicePriorityConflictException();
        }
        return null;
    }

    private T tryFolderSpecific(int cid, String folderId) {
        Map folderSpecific = (Map)this.contextAndFolderSpecific.get(cid);
        if (folderSpecific == null) {
            return null;
        }
        if (folderSpecific.containsKey(folderId)) {
            return ((WeightedRegistration)((SortedSet)folderSpecific.get(folderId)).first()).getPayload();
        }
        return null;
    }

    private WeightedRegistration<T> tryContextSpecific(int cid) {
        if (this.contextSpecific.containsKey(cid) && !((SortedSet)this.contextSpecific.get(cid)).isEmpty()) {
            return (WeightedRegistration)((SortedSet)this.contextSpecific.get(cid)).first();
        }
        return null;
    }

    private WeightedRegistration<T> tryFolderSpecific(String folderId) {
        if (this.folderSpecific.containsKey(folderId)) {
            return this.folderSpecific.get(folderId).first();
        }
        return null;
    }

    private static final class WeightedRegistration<T>
    implements Comparable<WeightedRegistration<T>> {
        public T payload = null;
        public int ranking;

        public WeightedRegistration(int ranking) {
            this.ranking = ranking;
        }

        @Override
        public int compareTo(WeightedRegistration<T> o) {
            return o.ranking - this.ranking;
        }

        public int hashCode() {
            return this.ranking;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WeightedRegistration)) {
                return false;
            }
            return this.ranking == ((WeightedRegistration)o).ranking;
        }

        public T getPayload() {
            return this.payload;
        }
    }
}

