/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.scheduler;

import com.openexchange.config.ConfigurationService;
import com.openexchange.tools.images.osgi.Services;
import com.openexchange.tools.images.scheduler.SchedulerThreadFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scheduler {
    static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    private static volatile Scheduler instance;
    private final ExecutorService pool;
    final Map<Object, TaskExecuter> runningThreads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutDown() {
        Scheduler tmp = instance;
        if (null == tmp) return;
        Class<Scheduler> clazz = Scheduler.class;
        synchronized (Scheduler.class) {
            tmp = instance;
            if (null == tmp) return;
            tmp.stop();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Scheduler getInstance() {
        Scheduler tmp = instance;
        if (null != tmp) return tmp;
        Class<Scheduler> clazz = Scheduler.class;
        synchronized (Scheduler.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            instance = tmp = new Scheduler();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private Scheduler() {
        ConfigurationService configService = Services.getService(ConfigurationService.class);
        int defaultNumThreads = 10;
        int numThreads = null == configService ? 10 : configService.getIntProperty("com.openexchange.tools.images.scheduler.numThreads", 10);
        ThreadPoolExecutor newPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(numThreads, new SchedulerThreadFactory());
        newPool.prestartAllCoreThreads();
        this.pool = newPool;
        this.runningThreads = new HashMap<Object, TaskExecuter>(256);
    }

    private void stop() {
        try {
            this.pool.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Object optKey, Runnable task) {
        Object key = null == optKey ? Thread.currentThread() : optKey;
        TaskExecuter executer = null;
        Map<Object, TaskExecuter> map = this.runningThreads;
        synchronized (map) {
            TaskExecuter runningExecutor = this.runningThreads.get(key);
            if (runningExecutor == null) {
                executer = new TaskExecuter(task, key);
                this.runningThreads.put(key, executer);
            } else {
                runningExecutor.add(task);
            }
        }
        if (executer != null) {
            return this.executeTask(executer);
        }
        return true;
    }

    private boolean executeTask(TaskExecuter executer) {
        try {
            this.pool.execute(executer);
        }
        catch (Throwable t) {
            LOGGER.warn("Couldn't execute image transformation task.", t);
            return false;
        }
        return true;
    }

    private final class TaskExecuter
    implements Runnable {
        private final LinkedList<Runnable> tasks = new LinkedList();
        private final Object taskKey;

        TaskExecuter(Runnable task, Object key) {
            this.taskKey = key;
            this.tasks.addLast(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean running;
            Thread currentThread = Thread.currentThread();
            do {
                Runnable task = null;
                Object object = this.tasks;
                synchronized (object) {
                    task = this.tasks.removeFirst();
                }
                task.run();
                object = Scheduler.this.runningThreads;
                synchronized (object) {
                    boolean bl = running = !this.tasks.isEmpty();
                    if (!running) {
                        Scheduler.this.runningThreads.remove(this.taskKey);
                    }
                }
            } while (running && !currentThread.isInterrupted());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Runnable task) {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.addLast(task);
            }
        }
    }
}

