/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.json.ResourceAJAXRequest;
import com.openexchange.resource.json.ResourceWriter;
import com.openexchange.resource.json.actions.AbstractResourceAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="get", description="Get updates (since v6.18.1)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="timestamp", description="Timestamp of the last update of the requested resources.")}, responseDescription="Response with timestamp: An array with new, modified and deleted resources. New, modified and deleted resources are represented by JSON objects as described in Resource response.")
public final class UpdatesAction
extends AbstractResourceAction {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatesAction.class);

    public UpdatesAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ResourceAJAXRequest req) throws OXException, JSONException {
        Date lastModified = req.checkDate("timestamp");
        ServerSession session = req.getSession();
        Resource[] updatedResources = null;
        Resource[] deletedResources = null;
        try {
            ResourceServiceImpl resService = ResourceServiceImpl.getInstance();
            updatedResources = resService.listModified(lastModified, session.getContext());
            deletedResources = resService.listDeleted(lastModified, session.getContext());
        }
        catch (OXException exc) {
            LOG.debug("Tried to find resources that were modified since {}", (Object)lastModified, (Object)exc);
        }
        JSONArray modified = new JSONArray();
        long lm = 0L;
        if (updatedResources != null) {
            for (Resource res : updatedResources) {
                if (res.getLastModified().getTime() > lm) {
                    lm = res.getLastModified().getTime();
                }
                modified.put((Object)ResourceWriter.writeResource(res));
            }
        }
        JSONArray deleted = new JSONArray();
        if (deletedResources != null) {
            for (Resource res : deletedResources) {
                if (res.getLastModified().getTime() > lm) {
                    lm = res.getLastModified().getTime();
                }
                deleted.put((Object)ResourceWriter.writeResource(res));
            }
        }
        Date timestamp = new Date(lm);
        JSONObject retVal = new JSONObject();
        retVal.put("modified", (Object)modified);
        retVal.put("new", (Object)modified);
        retVal.put("deleted", (Object)deleted);
        return new AJAXRequestResult(retVal, timestamp, "json");
    }
}

