/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.quota.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.quota.json.QuotaAJAXRequest;
import com.openexchange.quota.json.actions.AbstractQuotaAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="filestore", description="Get the filestore usage data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="A JSON Object containing the fields \"use\" and \"quota\". \"use\" represents the uploaded files sizes sum and the field \"quota\" represents the maximum.")
public final class GetAction
extends AbstractQuotaAction {
    public GetAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(QuotaAJAXRequest req) throws OXException, JSONException {
        if (req.getFsException() != null) {
            throw req.getFsException();
        }
        long use = req.getQfs().getUsage();
        long quota = req.getQfs().getQuota();
        JSONObject data = new JSONObject();
        data.put("quota", quota);
        data.put("use", use);
        return new AJAXRequestResult((Object)data, "json");
    }
}

