/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.PlainTextAddress;
import com.openexchange.mail.utils.StorageUtility;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailMessageComparator
implements Comparator<MailMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(MailMessageComparator.class);
    private static final String STR_EMPTY = "";
    private final IFieldComparer fieldComparer;
    private final boolean descendingDir;
    private static final EnumMap<MailSortField, IFieldComparer> COMPARERS = new EnumMap(MailSortField.class);
    private static FieldComparer DUMMY_COMPARER;
    private static final Integer COLOR_FLAG_MIN;

    public static MailFields prepareMailFieldsForSearch(MailField[] mailFields, MailSortField sortField) {
        return StorageUtility.prepareMailFieldsForSearch(mailFields, sortField);
    }

    public MailMessageComparator(boolean descendingDirection, Locale locale) {
        this(MailSortField.SENT_DATE, descendingDirection, locale);
    }

    public MailMessageComparator(MailSortField sortField, boolean descendingDirection, Locale locale) {
        this(sortField, descendingDirection, locale, MailProperties.getInstance().isUserFlagsEnabled());
    }

    public MailMessageComparator(MailSortField sortField, boolean descendingDirection, Locale locale, boolean userFlagsEnabled) {
        this.descendingDir = descendingDirection;
        if (MailSortField.COLOR_LABEL.equals((Object)sortField) && !userFlagsEnabled) {
            this.fieldComparer = DUMMY_COMPARER;
        } else {
            IFieldComparer tmp = COMPARERS.get((Object)sortField);
            if (null == tmp) {
                tmp = MailMessageComparator.createFieldComparer(sortField, locale);
            }
            this.fieldComparer = tmp;
        }
    }

    @Override
    public int compare(MailMessage msg1, MailMessage msg2) {
        try {
            return this.descendingDir ? this.fieldComparer.compareFieldsDesc(msg1, msg2) : this.fieldComparer.compareFields(msg1, msg2);
        }
        catch (MessagingException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            return 0;
        }
    }

    static int compareAddrs(Address[] addrs1, Address[] addrs2, Locale locale, Collator collator) {
        if (MailMessageComparator.isEmptyAddrArray(addrs1) && !MailMessageComparator.isEmptyAddrArray(addrs2)) {
            return -1;
        }
        if (!MailMessageComparator.isEmptyAddrArray(addrs1) && MailMessageComparator.isEmptyAddrArray(addrs2)) {
            return 1;
        }
        if (MailMessageComparator.isEmptyAddrArray(addrs1) && MailMessageComparator.isEmptyAddrArray(addrs2)) {
            return 0;
        }
        return collator.compare(MailMessageComparator.getCompareStringFromAddress(addrs1[0], locale), MailMessageComparator.getCompareStringFromAddress(addrs2[0], locale));
    }

    private static boolean isEmptyAddrArray(Address[] addrs) {
        return addrs == null || addrs.length == 0;
    }

    private static String getCompareStringFromAddress(Address addr, Locale locale) {
        if (addr instanceof PlainTextAddress) {
            return ((PlainTextAddress)addr).getAddress().toLowerCase(locale);
        }
        if (addr instanceof InternetAddress) {
            InternetAddress ia1 = (InternetAddress)addr;
            String personal = ia1.getPersonal();
            if (personal != null && personal.length() > 0) {
                return personal.charAt(0) == '\'' || personal.charAt(0) == '\"' ? personal.substring(1).toLowerCase(locale) : personal.toLowerCase(locale);
            }
            return IDNA.toIDN((String)ia1.getAddress()).toLowerCase(locale);
        }
        return STR_EMPTY;
    }

    static int compareByReceivedDate(MailMessage msg1, MailMessage msg2, boolean asc) throws MessagingException {
        Date d1 = msg1.getReceivedDate();
        Date d2 = msg2.getReceivedDate();
        if (null == d1) {
            if (null == d2) {
                return 0;
            }
            return asc ? -1 : 1;
        }
        if (null == d2) {
            return asc ? 1 : -1;
        }
        return asc ? d1.compareTo(d2) : d2.compareTo(d1);
    }

    private static FieldComparer createFieldComparer(MailSortField sortCol, Locale locale) {
        switch (sortCol) {
            case FROM: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        return MailMessageComparator.compareAddrs((Address[])msg1.getFrom(), (Address[])msg2.getFrom(), this.locale, this.collator);
                    }
                };
            }
            case TO: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        return MailMessageComparator.compareAddrs((Address[])msg1.getTo(), (Address[])msg2.getTo(), this.locale, this.collator);
                    }
                };
            }
            case CC: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        return MailMessageComparator.compareAddrs((Address[])msg1.getCc(), (Address[])msg2.getCc(), this.locale, this.collator);
                    }
                };
            }
            case SUBJECT: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        String sub1 = msg1.getSubject();
                        String sub2 = msg2.getSubject();
                        return this.collator.compare(sub1 == null ? MailMessageComparator.STR_EMPTY : sub1, sub2 == null ? MailMessageComparator.STR_EMPTY : sub2);
                    }
                };
            }
            case ACCOUNT_NAME: {
                return new LocalizedFieldComparer(locale){

                    @Override
                    public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                        String name1 = msg1.getAccountName();
                        String name2 = msg2.getAccountName();
                        return this.collator.compare(name1 == null ? MailMessageComparator.STR_EMPTY : name1, name2 == null ? MailMessageComparator.STR_EMPTY : name2);
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unknown sort column value " + (Object)((Object)sortCol));
    }

    static Integer getColorFlag(String[] userFlags) {
        for (int i = 0; i < userFlags.length; ++i) {
            String userFlag = userFlags[i];
            if (!MailMessage.isColorLabel(userFlag)) continue;
            int cf = MailMessage.parseColorLabel(userFlag, COLOR_FLAG_MIN);
            return 0 == cf ? COLOR_FLAG_MIN : Integer.valueOf(cf * -1);
        }
        return COLOR_FLAG_MIN;
    }

    static {
        COMPARERS.put(MailSortField.SENT_DATE, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                Date d1 = msg1.getSentDate();
                Date d2 = msg2.getSentDate();
                if (null == d1) {
                    if (null == d2) {
                        return 0;
                    }
                    return -1;
                }
                if (null == d2) {
                    return 1;
                }
                return d1.compareTo(d2);
            }
        });
        COMPARERS.put(MailSortField.RECEIVED_DATE, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                return MailMessageComparator.compareByReceivedDate(msg1, msg2, true);
            }
        });
        COMPARERS.put(MailSortField.FLAG_SEEN, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                boolean isSeen1 = msg1.isSeen();
                if (isSeen1) {
                    if (msg2.isSeen()) {
                        return MailMessageComparator.compareByReceivedDate(msg1, msg2, false);
                    }
                    return 1;
                }
                if (msg2.isSeen()) {
                    return -1;
                }
                return MailMessageComparator.compareByReceivedDate(msg1, msg2, false);
            }
        });
        COMPARERS.put(MailSortField.SIZE, new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                long size2;
                long size1 = msg1.getSize();
                return size1 < (size2 = msg2.getSize()) ? -1 : (size1 == size2 ? 0 : 1);
            }
        });
        COMPARERS.put(MailSortField.COLOR_LABEL, new IFieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) throws MessagingException {
                int result = this.compAsc(msg1, msg2);
                return result == 0 ? MailMessageComparator.compareByReceivedDate(msg1, msg2, false) : result;
            }

            private int compAsc(MailMessage msg1, MailMessage msg2) {
                int cl1 = msg1.getColorLabel();
                int cl2 = msg2.getColorLabel();
                if (cl1 <= 0) {
                    return cl2 <= 0 ? 0 : 1;
                }
                if (cl2 <= 0) {
                    return cl1 <= 0 ? 0 : -1;
                }
                return cl1 < cl2 ? -1 : (cl1 == cl2 ? 0 : 1);
            }

            @Override
            public int compareFieldsDesc(MailMessage msg1, MailMessage msg2) throws MessagingException {
                int result = this.compDesc(msg1, msg2);
                return result == 0 ? MailMessageComparator.compareByReceivedDate(msg1, msg2, false) : result;
            }

            private int compDesc(MailMessage msg1, MailMessage msg2) {
                int cl1 = msg1.getColorLabel();
                int cl2 = msg2.getColorLabel();
                if (cl1 <= 0) {
                    return cl2 <= 0 ? 0 : 1;
                }
                if (cl2 <= 0) {
                    return cl1 <= 0 ? 0 : -1;
                }
                return cl1 < cl2 ? 1 : (cl1 == cl2 ? 0 : -1);
            }
        });
        DUMMY_COMPARER = new FieldComparer(){

            @Override
            public int compareFields(MailMessage msg1, MailMessage msg2) {
                return 0;
            }
        };
        COLOR_FLAG_MIN = -99;
    }

    private static abstract class LocalizedFieldComparer
    extends FieldComparer {
        public final Locale locale;
        public final Collator collator;

        public LocalizedFieldComparer(Locale locale) {
            this.locale = locale;
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }
    }

    private static abstract class FieldComparer
    implements IFieldComparer {
        protected FieldComparer() {
        }

        @Override
        public int compareFieldsDesc(MailMessage msg1, MailMessage msg2) throws MessagingException {
            int result = this.compareFields(msg1, msg2);
            result = -result;
            return result;
        }
    }

    private static interface IFieldComparer {
        public int compareFields(MailMessage var1, MailMessage var2) throws MessagingException;

        public int compareFieldsDesc(MailMessage var1, MailMessage var2) throws MessagingException;
    }
}

