/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Locale;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.slf4j.LoggerFactory;

public final class SubjectTerm
extends SearchTerm<String> {
    private static final long serialVersionUID = 1462060457742619720L;
    private final String unicodeSubject;

    public SubjectTerm(String unicodeSubject) {
        this.unicodeSubject = unicodeSubject;
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getPattern() {
        return this.unicodeSubject;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.SUBJECT);
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        String subject;
        try {
            subject = msg.getSubject();
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(SubjectTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
        if (subject != null) {
            if (this.containsWildcard()) {
                return SubjectTerm.toRegex(this.unicodeSubject).matcher(subject).find();
            }
            return subject.toLowerCase(Locale.ENGLISH).indexOf(this.unicodeSubject.toLowerCase(Locale.ENGLISH)) != -1;
        }
        return false;
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        String subject = mailMessage.getSubject();
        if (subject == null) {
            return null == this.unicodeSubject;
        }
        if (null == this.unicodeSubject) {
            return false;
        }
        if (this.containsWildcard()) {
            return SubjectTerm.toRegex(this.unicodeSubject).matcher(subject).find();
        }
        return subject.toLowerCase(Locale.ENGLISH).indexOf(this.unicodeSubject.toLowerCase(Locale.ENGLISH)) != -1;
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new javax.mail.search.SubjectTerm(this.unicodeSubject);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new javax.mail.search.SubjectTerm(SubjectTerm.getNonWildcardPart(this.unicodeSubject));
    }

    @Override
    public boolean isAscii() {
        return SubjectTerm.isAscii(this.unicodeSubject);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.unicodeSubject ? false : this.unicodeSubject.indexOf(42) >= 0 || this.unicodeSubject.indexOf(63) >= 0;
    }
}

