/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtendedMimeMessage
extends MimeMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedMimeMessage.class);
    private final String fullname;
    private final char separator;
    private long uid = -1L;
    private Boolean hasAttachment;
    private int threadLevel;
    private BODYSTRUCTURE bodystructure;
    private int priority = -1;
    private Date receivedDate;
    private Integer size;
    private ContentType contentType;
    private static final String MULTI = "multipart/";
    private static final String MULTI_SUBTYPE_MIXED = "MIXED";

    public ExtendedMimeMessage(String fullname, char separator, int msgnum) {
        super(MimeDefaultSession.getDefaultSession());
        this.fullname = fullname;
        this.separator = separator;
        this.msgnum = msgnum;
    }

    public void parseStream(InputStream in) throws MessagingException {
        this.contentType = null;
        this.priority = -1;
        this.parse(in);
    }

    public String getFullname() {
        return this.fullname;
    }

    public char getSeparator() {
        return this.separator;
    }

    public boolean hasAttachment() {
        if (null == this.hasAttachment) {
            ContentType ct = this.getContentType0();
            try {
                this.hasAttachment = ct.startsWith(MULTI) && (MULTI_SUBTYPE_MIXED.equalsIgnoreCase(ct.getSubType()) || this.deepAttachmentCheck(ct.getSubType()));
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
                this.hasAttachment = ct.isMimeType("multipart/mixed");
            }
            catch (MessagingException e) {
                LOG.error("", (Throwable)e);
                this.hasAttachment = ct.isMimeType("multipart/mixed");
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                this.hasAttachment = ct.isMimeType("multipart/mixed");
            }
        }
        return this.hasAttachment;
    }

    private boolean deepAttachmentCheck(String subType) throws OXException, MessagingException, IOException {
        if (null != this.bodystructure) {
            return MimeMessageUtility.hasAttachments(this.bodystructure);
        }
        if (null != this.content || null != this.contentStream) {
            return MimeMessageUtility.hasAttachments((Multipart)this.getContent(), subType);
        }
        return false;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
    }

    public int getThreadLevel() {
        return this.threadLevel;
    }

    public void setThreadLevel(int threadLevel) {
        this.threadLevel = threadLevel;
    }

    public BODYSTRUCTURE getBodystructure() {
        return this.bodystructure;
    }

    public void setBodystructure(BODYSTRUCTURE bodystructure) {
        this.bodystructure = bodystructure;
    }

    public int getPriority() {
        if (this.priority == -1) {
            try {
                String imp = this.getHeader("Importance", null);
                this.priority = null != imp ? MimeMessageConverter.parseImportance(imp) : ExtendedMimeMessage.parsePriority(this.getHeader("X-Priority", null));
            }
            catch (MessagingException e) {
                LOG.warn("", (Throwable)e);
                this.priority = 3;
            }
        }
        return this.priority;
    }

    private static int parsePriority(String priorityStr) {
        if (null != priorityStr) {
            String[] tmp = priorityStr.split(" +");
            try {
                return Integer.parseInt(tmp[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.debug("Strange X-Priority header: {}", (Object)tmp[0], (Object)nfe);
                return 3;
            }
        }
        return 3;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    public int getSize() {
        if (this.size == null) {
            try {
                this.size = super.getSize();
            }
            catch (MessagingException e) {
                LOG.warn("", (Throwable)e);
                this.size = -1;
            }
        }
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private ContentType getContentType0() {
        if (this.contentType == null) {
            try {
                this.contentType = new ContentType(this.getHeader("Content-Type", null));
            }
            catch (MessagingException e) {
                LOG.warn("", (Throwable)e);
                this.contentType = new ContentType();
                this.contentType.setPrimaryType("text");
                this.contentType.setSubType("plain");
                this.contentType.setCharsetParameter("us-ascii");
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
                this.contentType = new ContentType();
                this.contentType.setPrimaryType("text");
                this.contentType.setSubType("plain");
                this.contentType.setCharsetParameter("us-ascii");
            }
        }
        return this.contentType;
    }

    public String getContentType() {
        return this.getContentType0().toString();
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }
}

