/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.MailImportResult;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.DateUtils;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTrackableTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.POST, name="import", description="Import mail as MIME data block (RFC822)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", optional=true, description="In case the mail should not be sent out, but saved in a specific folder, the \"folder\" parameter can be used. If the mail should be sent out to the recipient, the \"folder\" parameter must not be included and the mail is stored in the folder \"Sent Items\". Example \"folder=default.INBOX/Testfolder\""), @Parameter(name="flags", optional=true, description="In case the mail should be stored with status \"read\" (e.g. mail has been read already in the client inbox), the parameter \"flags\" has to be included. If no \"folder\" parameter is specified, this parameter must not be included. For infos about mail flags see Detailed mail data spec.")}, requestBody="The MIME Data Block.", responseDescription="Object ID of the newly created/moved mail.")
public final class ImportAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(ImportAction.class);
    private static final String PLAIN_JSON = "plainJson";
    protected static final MimeMessage POISON = new MimeMessage(MimeDefaultSession.getDefaultSession());

    public ImportAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest mailRequest) throws OXException {
        AJAXRequestData request = mailRequest.getRequest();
        ArrayList<OXException> warnings = new ArrayList<OXException>();
        UploadEvent uploadEvent = null;
        try {
            MailImportResult[] mirs;
            int flags;
            String folder = mailRequest.checkParameter("folder");
            String tmp = mailRequest.getParameter("flags");
            if (null == tmp) {
                flags = 0;
            } else {
                int f;
                try {
                    f = Integer.parseInt(tmp.trim());
                }
                catch (NumberFormatException e) {
                    f = 0;
                }
                flags = f;
            }
            String tmp2 = mailRequest.getParameter("force");
            boolean force = null == tmp2 ? false : AJAXRequestDataTools.parseBoolParameter(tmp2.trim());
            boolean preserveReceivedDate = mailRequest.optBool("preserveReceivedDate", false);
            ServerSession session = mailRequest.getSession();
            QuotedInternetAddress defaultSendAddr = new QuotedInternetAddress(ImportAction.getDefaultSendAddress(session), false);
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            ArrayBlockingQueue<MimeMessage> queue = new ArrayBlockingQueue<MimeMessage>(100);
            Future future = null;
            ThreadPoolService service = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true);
            AppenderTask task = new AppenderTask(mailInterface, folder, force, flags, queue);
            try {
                Iterator<UploadFile> iter = request.getFiles().iterator();
                if (iter.hasNext()) {
                    uploadEvent = request.getUploadEvent();
                    future = service.submit((Task)task);
                }
                Session defaultSession = MimeDefaultSession.getDefaultSession();
                boolean keepgoing = true;
                while (keepgoing && iter.hasNext()) {
                    MimeMessage message;
                    UploadFile item = iter.next();
                    InputStream is = item.openStream();
                    try {
                        message = preserveReceivedDate ? new MimeMessage(defaultSession, is){
                            private boolean notParsed;
                            private Date receivedDate;
                            {
                                this.notParsed = true;
                                this.receivedDate = null;
                            }

                            public Date getReceivedDate() throws MessagingException {
                                if (this.notParsed) {
                                    this.notParsed = false;
                                    String[] receivedHdrs = this.getHeader("Received");
                                    if (null != receivedHdrs) {
                                        long lastReceived = Long.MIN_VALUE;
                                        for (int i = 0; i < receivedHdrs.length; ++i) {
                                            int pos;
                                            String hdr = MimeMessageUtility.unfold(receivedHdrs[i]);
                                            if (hdr == null || (pos = hdr.lastIndexOf(59)) == -1) continue;
                                            try {
                                                lastReceived = Math.max(lastReceived, DateUtils.getDateRFC822(hdr.substring(pos + 1).trim()).getTime());
                                                continue;
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        if (lastReceived > 0L) {
                                            this.receivedDate = new Date(lastReceived);
                                        }
                                    }
                                }
                                return this.receivedDate;
                            }
                        } : new MimeMessage(defaultSession, is);
                        message.removeHeader("x-original-headers");
                    }
                    finally {
                        Streams.close((Closeable)is);
                    }
                    String fromAddr = message.getHeader("From", null);
                    if (ImportAction.isEmpty(fromAddr)) {
                        message.setFrom((Address)defaultSendAddr);
                    }
                    while (keepgoing && !queue.offer(message, 1L, TimeUnit.SECONDS)) {
                        keepgoing = !future.isDone();
                    }
                }
            }
            finally {
                task.stop();
            }
            if (null == future) {
                mirs = new MailImportResult[]{};
            } else {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof OXException) {
                        throw (OXException)t;
                    }
                    throw new IllegalStateException("Not unchecked", t);
                }
                MailImportResult[] alreadyImportedOnes = mailInterface.getMailImportResults();
                if (queue.isEmpty()) {
                    mirs = alreadyImportedOnes;
                } else {
                    ArrayList messages = new ArrayList(16);
                    queue.drainTo(messages);
                    messages.remove(POISON);
                    ArrayList<MailMessage> mails = new ArrayList<MailMessage>(messages.size());
                    for (MimeMessage message : messages) {
                        message.getHeader("Date", null);
                        MailMessage mm = MimeMessageConverter.convertMessage(message);
                        mails.add(mm);
                    }
                    messages.clear();
                    mailInterface = this.getMailInterface(mailRequest);
                    String[] ids = mailInterface.importMessages(folder, mails.toArray(new MailMessage[mails.size()]), force);
                    mails.clear();
                    if (flags > 0) {
                        mailInterface.updateMessageFlags(folder, ids, flags, true);
                    }
                    MailImportResult[] byCaller = mailInterface.getMailImportResults();
                    warnings.addAll(mailInterface.getWarnings());
                    mirs = new MailImportResult[alreadyImportedOnes.length + byCaller.length];
                    System.arraycopy(alreadyImportedOnes, 0, mirs, 0, alreadyImportedOnes.length);
                    System.arraycopy(byCaller, 0, mirs, alreadyImportedOnes.length, byCaller.length);
                }
            }
            JSONArray respArray = new JSONArray();
            for (MailImportResult m : mirs) {
                JSONObject responseObj;
                if (m.hasError()) {
                    responseObj = new JSONObject();
                    responseObj.put("folder_id", (Object)folder);
                    responseObj.put(MailImportResult.FILENAME, (Object)m.getMail().getFileName());
                    responseObj.put(MailImportResult.ERROR, (Object)m.getException().getMessage());
                    respArray.put((Object)responseObj);
                    continue;
                }
                responseObj = new JSONObject();
                responseObj.put("folder_id", (Object)folder);
                responseObj.put("id", (Object)m.getId());
                respArray.put((Object)responseObj);
            }
            AJAXRequestResult result = new AJAXRequestResult((Object)respArray, "json");
            result.setParameter(PLAIN_JSON, Boolean.TRUE);
            result.addWarnings(warnings);
            return result;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private static final class AppenderTask
    extends AbstractTrackableTask<Object> {
        private final AtomicBoolean keepgoing = new AtomicBoolean(true);
        private final MailServletInterface mailInterface;
        private final String folder;
        private final boolean force;
        private final int flags;
        private final BlockingQueue<MimeMessage> queue;

        protected AppenderTask(MailServletInterface mailInterface, String folder, boolean force, int flags, BlockingQueue<MimeMessage> queue) {
            this.mailInterface = mailInterface;
            this.folder = folder;
            this.force = force;
            this.flags = flags;
            this.queue = queue;
        }

        protected void stop() throws OXException {
            this.keepgoing.set(false);
            try {
                this.queue.put(POISON);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
            }
        }

        public Object call() throws Exception {
            ArrayList<String> idList = new ArrayList<String>();
            try {
                ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>(16);
                ArrayList<MailMessage> mails = new ArrayList<MailMessage>(16);
                while (this.keepgoing.get() || !this.queue.isEmpty()) {
                    messages.clear();
                    mails.clear();
                    if (this.queue.isEmpty()) {
                        MimeMessage msg = this.queue.take();
                        if (POISON == msg) {
                            Object var5_9 = null;
                            return var5_9;
                        }
                        messages.add(msg);
                    }
                    this.queue.drainTo(messages);
                    boolean quit = messages.remove(POISON);
                    for (MimeMessage message : messages) {
                        message.getHeader("Date", null);
                        MailMessage mm = MimeMessageConverter.convertMessage(message);
                        mails.add(mm);
                    }
                    String[] ids = this.mailInterface.importMessages(this.folder, mails.toArray(new MailMessage[mails.size()]), this.force);
                    idList.addAll(Arrays.asList(ids));
                    if (this.flags > 0) {
                        this.mailInterface.updateMessageFlags(this.folder, ids, this.flags, true);
                    }
                    if (!quit) continue;
                    Object var6_10 = null;
                    return var6_10;
                }
            }
            catch (OXException e) {
                throw e;
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
            catch (InterruptedException e) {
                throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
            }
            finally {
                this.mailInterface.close(true);
            }
            return null;
        }

        public void setThreadName(ThreadRenamer threadRenamer) {
            threadRenamer.rename("Mail Import Thread");
        }
    }
}

