/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.conversion;

import com.openexchange.conversion.DataSource;
import com.openexchange.exception.OXException;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.session.Session;
import java.io.InputStream;

public abstract class MailPartDataSource
implements DataSource {
    protected static final String[] ARGS = new String[]{"com.openexchange.mail.conversion.fullname", "com.openexchange.mail.conversion.mailid", "com.openexchange.mail.conversion.sequenceid"};

    protected MailPartDataSource() {
    }

    protected final MailPart getMailPart(int accountId, String fullname, String mailId, String sequenceId, Session session) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            MailPart mailPart = this.loadPart(fullname, mailId, sequenceId, mailAccess);
            return mailPart;
        }
        catch (OXException e) {
            if (null != mailAccess && MimeMessageUtility.shouldRetry(e)) {
                mailAccess = MailAccess.reconnect(mailAccess);
                MailPart mailPart = this.loadPart(fullname, mailId, sequenceId, mailAccess);
                return mailPart;
            }
            throw e;
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }

    private MailPart loadPart(String fullname, String mailId, String sequenceId, MailAccess<?, ?> mailAccess) throws OXException {
        MailPart mailPart = mailAccess.getMessageStorage().getAttachment(fullname, mailId, sequenceId);
        mailPart.loadContent();
        return mailPart;
    }

    public String[] getRequiredArguments() {
        return new String[]{ARGS[0], ARGS[1], ARGS[2]};
    }

    public Class<?>[] getTypes() {
        return new Class[]{InputStream.class};
    }
}

