/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.conversion;

import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.conversion.MailPartDataSource;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import java.io.InputStream;

public final class ICalMailPartDataSource
extends MailPartDataSource {
    public static final String PROPERTY_OWNER = "com.openexchange.conversion.owner";

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        if (!InputStream.class.equals(type)) {
            throw DataExceptionCodes.TYPE_NOT_SUPPORTED.create(new Object[]{type.getName()});
        }
        FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(dataArguments.get(ARGS[0]));
        String fullname = arg.getFullname();
        String mailId = dataArguments.get(ARGS[1]);
        String sequenceId = dataArguments.get(ARGS[2]);
        DataProperties properties = new DataProperties();
        MailPart mailPart = this.getMailPart(arg.getAccountId(), fullname, mailId, sequenceId, session, properties);
        ContentType contentType = mailPart.getContentType();
        if (!this.isCalendar(contentType)) {
            ContentType tmp;
            String contentTypeByFileName;
            String fileName = mailPart.getFileName();
            if (Strings.isEmpty((String)fileName)) {
                this.throwException(contentType);
            }
            if ("application/octet-stream".equalsIgnoreCase(contentTypeByFileName = MimeType2ExtMap.getContentType(fileName))) {
                this.throwException(contentType);
            }
            if (!this.isCalendar(tmp = new ContentType(contentTypeByFileName))) {
                this.throwException(contentType);
            }
            if (null == contentType) {
                contentType = tmp;
            } else {
                contentType.setBaseType(tmp.getBaseType());
            }
        }
        properties.put("com.openexchange.conversion.content-type", contentType.getBaseType());
        String cs = contentType.getCharsetParameter();
        properties.put("com.openexchange.conversion.charset", Strings.isEmpty((String)cs) ? MailProperties.getInstance().getDefaultMimeCharset() : cs);
        properties.put("com.openexchange.conversion.size", Long.toString(mailPart.getSize()));
        properties.put("com.openexchange.conversion.name", mailPart.getFileName());
        return new SimpleData((Object)mailPart.getInputStream(), properties);
    }

    private boolean isCalendar(ContentType contentType) {
        return null != contentType && (contentType.isMimeType("text/*calendar") || contentType.startsWith("application/ics"));
    }

    private void throwException(ContentType contentType) throws OXException {
        if (null == contentType) {
            throw DataExceptionCodes.ERROR.create(new Object[]{"Missing header 'Content-Type' in requested mail part"});
        }
        throw DataExceptionCodes.ERROR.create(new Object[]{"Requested mail part is not an ICal: " + contentType.getBaseType()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailPart getMailPart(int accountId, String fullname, String mailId, String sequenceId, Session session, DataProperties properties) throws OXException {
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
        try {
            MailPart mailPart;
            mailAccess = MailAccess.getInstance(session, accountId);
            mailAccess.connect();
            MailFolder folder = mailAccess.getFolderStorage().getFolder(fullname);
            if (folder.isShared()) {
                MailPermission[] permissions = folder.getPermissions();
                boolean found = false;
                boolean foundMoreThanOne = false;
                int ownerId = 0;
                for (MailPermission perm : permissions) {
                    if (!perm.isFolderAdmin() || perm.isGroupPermission()) continue;
                    if (found) {
                        foundMoreThanOne = true;
                    }
                    ownerId = perm.getEntity();
                    found = true;
                }
                if (found && !foundMoreThanOne && ownerId > 0) {
                    properties.put(PROPERTY_OWNER, Integer.toString(ownerId));
                }
            }
            if (null == (mailPart = mailAccess.getMessageStorage().getAttachment(fullname, mailId, sequenceId))) {
                throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(sequenceId, mailId, fullname);
            }
            mailPart.loadContent();
            MailPart mailPart2 = mailPart;
            return mailPart2;
        }
        finally {
            if (null != mailAccess) {
                mailAccess.close(true);
            }
        }
    }
}

