/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailAccessWatcher;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailInitialization;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.api.MailLogicTools;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.cache.EnqueueingMailAccessCache;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.mime.MimeCleanUp;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MailAccess<F extends IMailFolderStorage, M extends IMailMessageStorage>
implements Serializable,
Closeable {
    private static final long serialVersionUID = -2580495494392812083L;
    private static final transient Logger LOG = LoggerFactory.getLogger(MailAccess.class);
    private static final ConcurrentMap<Key, AcquiredLatch> SYNCHRONIZER = new ConcurrentHashMap<Key, AcquiredLatch>(256);
    protected final String lineSeparator = System.getProperty("line.separator");
    protected final transient Session session;
    protected final int accountId;
    protected final Collection<OXException> warnings = new ArrayList<OXException>(2);
    protected volatile boolean cacheable;
    protected volatile boolean trackable;
    protected volatile boolean cached;
    protected volatile boolean waiting;
    protected MailProvider provider;
    private volatile boolean tracked;
    private transient MailConfig mailConfig;
    private Properties mailProperties;
    private transient Thread usingThread;
    private transient Map<String, String> usingThreadProperties;
    private StackTraceElement[] trace;
    public static final int MAX_PER_USER = 3;
    private static ThreadLocal<Queue<MimeCleanUp>> CLEAN_UPS = new ThreadLocal<Queue<MimeCleanUp>>(){

        @Override
        protected Queue<MimeCleanUp> initialValue() {
            return new ConcurrentLinkedQueue<MimeCleanUp>();
        }
    };

    private static AcquiredLatch acquireFor(Key key) {
        AcquiredLatch newLatch;
        AcquiredLatch latch = (AcquiredLatch)SYNCHRONIZER.get(key);
        if (null == latch && null == (latch = SYNCHRONIZER.putIfAbsent(key, newLatch = new AcquiredLatch(Thread.currentThread(), new CountDownLatch(1))))) {
            latch = newLatch;
        }
        return latch;
    }

    private static void releaseFor(Key key) {
        SYNCHRONIZER.remove(key);
    }

    protected MailAccess(Session session) {
        this(session, 0);
    }

    protected MailAccess(Session session, int accountId) {
        this.session = session;
        this.accountId = accountId;
        this.cacheable = true;
        this.trackable = true;
    }

    public Session getSession() {
        return this.session;
    }

    protected MailAccess<F, M> setProvider(MailProvider provider) {
        this.provider = provider;
        return this;
    }

    public MailProvider getProvider() {
        return this.provider;
    }

    public void addWarnings(Collection<OXException> warnings) {
        this.warnings.addAll(warnings);
    }

    public Collection<OXException> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    protected final void resetFields() {
        this.mailProperties = null;
        this.usingThread = null;
        this.usingThreadProperties = null;
        this.trace = null;
    }

    protected static void startupImpl(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws OXException {
        mailAccess.startup();
    }

    protected static void shutdownImpl(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws OXException {
        mailAccess.shutdown();
    }

    public static IMailAccessCache getMailAccessCache() throws OXException {
        return EnqueueingMailAccessCache.getInstance(3);
    }

    public static final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getInstance(Session session) throws OXException {
        return MailAccess.getInstance(session, 0);
    }

    public static final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getInstance(Session session, int accountId) throws OXException {
        MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess;
        Object tmp;
        if (!MailInitialization.getInstance().isInitialized()) {
            throw MailExceptionCode.INITIALIZATION_PROBLEM.create();
        }
        if (0 == accountId) {
            MailAccess.checkAdminLogin(session, accountId);
        }
        if ((null == (tmp = session.getParameter("com.openexchange.mail.lookupMailAccessCache")) || MailAccess.toBool(tmp)) && (mailAccess = MailAccess.getMailAccessCache().removeMailAccess(session, accountId)) != null) {
            return mailAccess;
        }
        MailProvider mailProvider = MailProviderRegistry.getMailProviderBySession(session, accountId);
        return mailProvider.createNewMailAccess(session, accountId).setProvider(mailProvider);
    }

    private static boolean toBool(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString().trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getNewInstance(Session session, int accountId) throws OXException {
        boolean setParam;
        String name = "com.openexchange.mail.lookupMailAccessCache";
        Object tmp = session.getParameter("com.openexchange.mail.lookupMailAccessCache");
        boolean bl = setParam = null == tmp || MailAccess.toBool(tmp);
        if (setParam) {
            session.setParameter("com.openexchange.mail.lookupMailAccessCache", (Object)Boolean.FALSE);
        }
        try {
            MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(session, accountId);
            return mailAccess;
        }
        finally {
            if (setParam) {
                session.setParameter("com.openexchange.mail.lookupMailAccessCache", null);
            }
        }
    }

    public static final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> reconnect(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws OXException {
        if (null == mailAccess) {
            return null;
        }
        Session session = mailAccess.getSession();
        int accountId = mailAccess.getAccountId();
        mailAccess.close(true);
        MailAccess<IMailFolderStorage, IMailMessageStorage> newAccess = MailAccess.getNewInstance(session, accountId);
        newAccess.connect();
        return newAccess;
    }

    public static final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getInstance(int userId, int contextId) throws OXException {
        return MailAccess.getInstance(userId, contextId, 0);
    }

    public static final MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> getInstance(int userId, int contextId, int accountId) throws OXException {
        Session session;
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null != sessiondService && (session = sessiondService.getAnyActiveSessionForUser(userId, contextId)) != null) {
            return MailAccess.getInstance(session, accountId);
        }
        throw MailExceptionCode.UNEXPECTED_ERROR.create("No appropriate session found.");
    }

    public static final int getCounter() {
        return MailAccessWatcher.getNumberOfMailAccesses();
    }

    public static void closeInstance(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) {
        MailAccess.closeInstance(mailAccess, true);
    }

    public static void closeInstance(MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess, boolean put2Cache) {
        if (null != mailAccess) {
            try {
                mailAccess.close(put2Cache);
            }
            catch (Exception e) {
                LOG.error("Failed to close MailAccess instance", (Throwable)e);
            }
        }
    }

    protected static final void incrementCounter() {
    }

    protected static final void decrementCounter() {
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public void setMailProperties(Properties mailProperties) {
        this.mailProperties = mailProperties;
    }

    protected void checkFieldsBeforeConnect(MailConfig mailConfig) throws OXException {
        if (mailConfig.getServer() == null) {
            throw MailExceptionCode.MISSING_CONNECT_PARAM.create("mail server");
        }
        if (this.checkMailServerPort() && mailConfig.getPort() <= 0) {
            throw MailExceptionCode.MISSING_CONNECT_PARAM.create("mail server port");
        }
        if (mailConfig.getLogin() == null) {
            throw MailExceptionCode.MISSING_CONNECT_PARAM.create("login");
        }
        if (mailConfig.getPassword() == null) {
            MailConfig.PasswordSource cur = MailProperties.getInstance().getPasswordSource();
            if (!MailConfig.PasswordSource.GLOBAL.equals((Object)cur)) {
                throw MailExceptionCode.MISSING_CONNECT_PARAM.create("password");
            }
            String masterPw = MailProperties.getInstance().getMasterPassword();
            if (masterPw == null) {
                throw MailConfigException.create("Property \"masterPassword\" not set");
            }
            mailConfig.setPassword(masterPw);
        }
    }

    public boolean ping() throws OXException {
        try {
            MailConfig mailConfig;
            if (MailProperties.getInstance().isEnforceSecureConnection() && !(mailConfig = this.getMailConfig()).isSecure()) {
                throw MailExceptionCode.NON_SECURE_DENIED.create(mailConfig.getServer());
            }
            this.connect0(false);
            this.close(false);
            return true;
        }
        catch (OXException e) {
            return false;
        }
    }

    public final void connect() throws OXException {
        this.connect0(true);
    }

    public final void connect(boolean checkDefaultFolders) throws OXException {
        this.connect0(checkDefaultFolders);
    }

    public MailFolder getRootFolder() throws OXException {
        if (!this.isConnected()) {
            this.connect0(false);
        }
        return this.getFolderStorage().getRootFolder();
    }

    public int getUnreadMessagesCount(String fullname) throws OXException {
        if (!this.isConnected()) {
            this.connect0(false);
        }
        return this.getFolderStorage().getFolder(fullname).getUnreadMessageCount();
    }

    private final void connect0(boolean checkDefaultFolder) throws OXException {
        this.applyNewThread();
        if (this.isConnected()) {
            if (checkDefaultFolder) {
                this.checkDefaultFolderOnConnect();
            }
        } else {
            this.checkFieldsBeforeConnect(this.getMailConfig());
            this.connectInternal();
            if (checkDefaultFolder) {
                this.checkDefaultFolderOnConnect();
            }
        }
        if (this.isTrackable() && !this.tracked) {
            MailAccessWatcher.addMailAccess(this);
            this.tracked = true;
        }
    }

    private void checkDefaultFolderOnConnect() throws OXException {
        if (this.isDefaultFoldersChecked()) {
            return;
        }
        Key key = new Key(this.session.getUserId(), this.session.getContextId());
        AcquiredLatch acquiredLatch = MailAccess.acquireFor(key);
        CountDownLatch latch = acquiredLatch.latch;
        if (Thread.currentThread() == acquiredLatch.owner) {
            try {
                this.getFolderStorage().checkDefaultFolders();
                acquiredLatch.result.set(Boolean.TRUE);
                return;
            }
            catch (OXException e) {
                acquiredLatch.result.set((Object)e);
                throw e;
            }
            catch (Exception e) {
                MailConfig mailConfig = this.getMailConfig();
                String server = mailConfig.getServer();
                String login = mailConfig.getLogin();
                Integer contextId = this.session.getContextId();
                Integer userId = this.session.getUserId();
                OXException mailExc = MailExceptionCode.DEFAULT_FOLDER_CHECK_FAILED.create(e, server, userId, login, contextId, e.getMessage());
                LOG.error("", (Throwable)mailExc);
                this.closeInternal();
                acquiredLatch.result.set((Object)mailExc);
                throw mailExc;
            }
            finally {
                latch.countDown();
                MailAccess.releaseFor(key);
            }
        }
        try {
            latch.await();
            Object result = acquiredLatch.result.get();
            if (result instanceof OXException) {
                throw (OXException)((Object)result);
            }
        }
        catch (InterruptedException e) {
            throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
        }
    }

    protected boolean isDefaultFoldersChecked() {
        MailSessionCache cache = MailSessionCache.getInstance(this.session);
        if (null == cache) {
            return false;
        }
        Boolean b = (Boolean)cache.getParameter(this.accountId, MailSessionParameterNames.getParamDefaultFolderChecked());
        return b != null && b != false;
    }

    protected abstract void connectInternal() throws OXException;

    @Override
    public void close() {
        try {
            this.close(true);
        }
        catch (Exception x) {
            LOG.debug("Error while closing MailAccess instance.", (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean put2Cache) {
        try {
            if (!this.isConnectedUnsafe()) {
                return;
            }
            boolean put = put2Cache;
            try {
                this.releaseResources();
            }
            catch (Exception e) {
                LOG.error("Resources could not be properly released. Dropping mail connection for safety reasons", (Throwable)e);
                put = false;
            }
            if (put && this.isCacheable()) {
                try {
                    if (MailAccess.getMailAccessCache().putMailAccess(this.session, this.accountId, this)) {
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            }
            this.closeInternal();
        }
        finally {
            if (this.tracked) {
                MailAccessWatcher.removeMailAccess(this);
                this.tracked = false;
            }
            MailAccess.cleanUp();
        }
    }

    public static void rememberMimeCleanUp(MimeCleanUp mimeCleanUp) {
        if (null == mimeCleanUp) {
            return;
        }
        CLEAN_UPS.get().offer(mimeCleanUp);
    }

    private static void cleanUp() {
        MimeCleanUp mimeCleanUp;
        Queue<MimeCleanUp> queue = CLEAN_UPS.get();
        while ((mimeCleanUp = queue.poll()) != null) {
            mimeCleanUp.cleanUp();
        }
    }

    public void logTrace(StringBuilder sBuilder, Logger log) {
        int length;
        Map<String, String> taskProps;
        Thread usingThread = this.usingThread;
        if (null != usingThread && null != (taskProps = this.usingThreadProperties)) {
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : taskProps.entrySet()) {
                String propertyName = entry.getKey();
                String value = entry.getValue();
                if (null == value) continue;
                sorted.put(propertyName, value);
            }
            for (Map.Entry<String, String> entry : sorted.entrySet()) {
                sBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append(this.lineSeparator);
            }
            sBuilder.append(this.lineSeparator);
        }
        sBuilder.append(this.toString());
        StackTraceElement[] traze = this.trace;
        if (null != traze && (length = traze.length) > 3) {
            StackTraceElement[] trace;
            sBuilder.append(this.lineSeparator).append("Mail connection established (or fetched from cache) at: ").append(this.lineSeparator);
            StackTraceElement[] tmp = new StackTraceElement[length - 3];
            System.arraycopy(traze, 3, tmp, 0, tmp.length);
            Throwable throwable = new Throwable();
            throwable.setStackTrace(tmp);
            log.info(sBuilder.toString(), throwable);
            sBuilder.setLength(0);
            if (null != usingThread && usingThread.isAlive() && null != (trace = usingThread.getStackTrace()) && trace.length > 0) {
                sBuilder.append("Current Using Thread: ").append(usingThread.getName()).append(this.lineSeparator);
                FastThrowable fastThrowable = new FastThrowable();
                fastThrowable.setStackTrace(trace);
                log.info(sBuilder.toString(), (Throwable)fastThrowable);
            }
        }
    }

    public final String getTrace() {
        StringBuilder sBuilder = new StringBuilder(2048);
        Map<String, String> taskProps = this.usingThreadProperties;
        if (null != taskProps) {
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : taskProps.entrySet()) {
                String propertyName = entry.getKey();
                String value = entry.getValue();
                if (null == value) continue;
                sorted.put(propertyName, value);
            }
            for (Map.Entry<String, String> entry : sorted.entrySet()) {
                sBuilder.append(entry.getKey()).append('=').append(entry.getValue()).append(this.lineSeparator);
            }
            sBuilder.append(this.lineSeparator);
        }
        sBuilder.append(this.toString());
        sBuilder.append(this.lineSeparator).append("Mail connection established (or fetched from cache) at: ").append(this.lineSeparator);
        for (int i = 3; i < this.trace.length; ++i) {
            sBuilder.append("    at ").append(this.trace[i]).append(this.lineSeparator);
        }
        if (null != this.usingThread && this.usingThread.isAlive()) {
            sBuilder.append("Current Using Thread: ").append(this.usingThread.getName()).append(this.lineSeparator);
            StackTraceElement[] trace = this.usingThread.getStackTrace();
            sBuilder.append("    at ").append(trace[0]);
            for (int i = 1; i < trace.length; ++i) {
                sBuilder.append(this.lineSeparator).append("    at ").append(trace[i]);
            }
        }
        return sBuilder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("{ MailAccess [accountId=").append(this.accountId).append(", cached=").append(this.cached).append(", ");
        if (this.provider != null) {
            builder.append("provider=").append(this.provider).append(", ");
        }
        if (this.mailConfig != null) {
            builder.append("mailConfig=").append(this.mailConfig);
        }
        builder.append("] }");
        return builder.toString();
    }

    public MailConfig getMailConfig() throws OXException {
        if (null == this.mailConfig) {
            this.mailConfig = this.createMailConfig();
        }
        return this.mailConfig;
    }

    public int getAccountId() {
        return this.accountId;
    }

    private final MailConfig createMailConfig() throws OXException {
        MailConfig instance = this.createNewMailConfig();
        instance.setMailProperties(this.createNewMailProperties());
        return MailConfig.getConfig(instance, this.session, this.accountId);
    }

    private final void applyNewThread() {
        this.usingThread = Thread.currentThread();
        this.usingThreadProperties = LogProperties.getPropertyMap();
        this.trace = new Throwable().getStackTrace();
    }

    private static final void checkAdminLogin(Session session, int accountId) throws OXException {
        if (!MailProperties.getInstance().isAdminMailLoginEnabled()) {
            Context ctx = session instanceof ServerSession ? ((ServerSession)session).getContext() : ContextStorage.getStorageContext(session.getContextId());
            if (session.getUserId() == ctx.getMailadmin()) {
                throw MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.create(ctx.getContextId());
            }
        }
    }

    public boolean isTrackable() {
        return this.trackable;
    }

    public void setTrackable(boolean trackable) {
        this.trackable = trackable;
    }

    public int getCacheIdleSeconds() {
        return -1;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    protected abstract MailConfig createNewMailConfig();

    protected abstract IMailProperties createNewMailProperties() throws OXException;

    protected abstract boolean checkMailServerPort();

    protected abstract void releaseResources();

    public void invokeReleaseResources() {
        this.releaseResources();
    }

    protected abstract void closeInternal();

    public abstract F getFolderStorage() throws OXException;

    public abstract M getMessageStorage() throws OXException;

    public abstract MailLogicTools getLogicTools() throws OXException;

    public abstract boolean isConnected();

    public abstract boolean isConnectedUnsafe();

    protected abstract void startup() throws OXException;

    protected abstract void shutdown() throws OXException;

    private static final class AcquiredLatch {
        final CountDownLatch latch;
        final Thread owner;
        final AtomicReference<Object> result;

        AcquiredLatch(Thread owner, CountDownLatch latch) {
            this.owner = owner;
            this.latch = latch;
            this.result = new AtomicReference();
        }
    }

    private static final class Key {
        private final int contextId;
        private final int userId;
        private final int hash;

        Key(int userId, int contextId) {
            this.userId = userId;
            this.contextId = contextId;
            int prime = 31;
            int result = prime * 1 + contextId;
            this.hash = result = prime * result + userId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.contextId != other.contextId) {
                return false;
            }
            return this.userId == other.userId;
        }
    }

    static final class FastThrowable
    extends Throwable {
        FastThrowable() {
            super("tracked mail connection usage");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

