/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.utils.MailFolderUtility;
import java.io.Serializable;
import java.util.Comparator;

public final class MailPath
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7426425247685367823L;
    public static final Comparator<MailPath> COMPARATOR = new Comparator<MailPath>(){

        @Override
        public int compare(MailPath mailPath1, MailPath mailPath2) {
            int accountComp;
            int n = mailPath1.getAccountId() < mailPath2.getAccountId() ? -1 : (accountComp = mailPath1.getAccountId() == mailPath2.getAccountId() ? 0 : 1);
            if (accountComp == 0) {
                int folderComp = mailPath1.getFolder().compareTo(mailPath2.getFolder());
                return folderComp == 0 ? mailPath1.getMailID().compareTo(mailPath2.getMailID()) : folderComp;
            }
            return accountComp;
        }
    };
    public static final MailPath NULL = null;
    public static final char SEPERATOR = '/';
    private int accountId;
    private String folder;
    private String str;
    private String mailID;

    public static String getMailPath(int accountId, String folder, String mailId) {
        return new StringBuilder(32).append(MailFolderUtility.prepareFullname(accountId, folder)).append('/').append(mailId).toString();
    }

    public static MailPath[] getMailPaths(String mailPaths) throws OXException {
        return MailPath.getMailPaths(mailPaths.split(" *, *"));
    }

    public static MailPath[] getMailPaths(String[] mailPaths) throws OXException {
        MailPath[] retval = new MailPath[mailPaths.length];
        for (int i = 0; i < mailPaths.length; ++i) {
            retval[i] = new MailPath(mailPaths[i]);
        }
        return retval;
    }

    public static String[] getUIDs(MailPath[] mailPaths) {
        String[] retval = new String[mailPaths.length];
        for (int i = 0; i < mailPaths.length; ++i) {
            retval[i] = mailPaths[i].mailID;
        }
        return retval;
    }

    public MailPath() {
    }

    public MailPath(String mailPathStr) throws OXException {
        this.setMailIdentifierString(mailPathStr);
    }

    public MailPath(int accountId, String folder, String uid) {
        this.accountId = accountId;
        this.folder = folder;
        this.mailID = uid;
        this.str = MailPath.getMailPath(accountId, folder, this.mailID);
    }

    public void set(int accountId, String folder, String uid) {
        this.accountId = accountId;
        this.folder = folder;
        this.mailID = uid;
        this.str = MailPath.getMailPath(accountId, folder, this.mailID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.accountId;
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + (this.mailID == null ? 0 : this.mailID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MailPath other = (MailPath)obj;
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return !(this.mailID == null ? other.mailID != null : !this.mailID.equals(other.mailID));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getFolderArgument() {
        return MailFolderUtility.prepareFullname(this.accountId, this.folder);
    }

    public String getStr() {
        return this.str;
    }

    public String getMailID() {
        return this.mailID;
    }

    public MailPath setMailIdentifierString(String mailPathStr) throws OXException {
        int pos = mailPathStr.lastIndexOf(47);
        if (-1 == pos) {
            throw MailExceptionCode.INVALID_MAIL_IDENTIFIER.create(mailPathStr);
        }
        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(mailPathStr.substring(0, pos));
        this.accountId = fa.getAccountId();
        this.folder = fa.getFullname();
        this.mailID = mailPathStr.substring(pos + 1);
        this.str = mailPathStr;
        return this;
    }

    public String toString() {
        return this.str;
    }
}

