/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.Permission;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPermissionBits
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4210686154175384469L;
    public static final int WEBMAIL = 1;
    public static final int CALENDAR = 2;
    public static final int CONTACTS = 4;
    public static final int TASKS = 8;
    public static final int INFOSTORE = 16;
    public static final int PROJECTS = 32;
    public static final int FORUM = 64;
    public static final int PINBOARD_WRITE_ACCESS = 128;
    public static final int WEBDAV_XML = 256;
    public static final int WEBDAV = 512;
    public static final int ICAL = 1024;
    public static final int VCARD = 2048;
    public static final int RSS_BOOKMARKS = 4096;
    public static final int RSS_PORTAL = 8192;
    public static final int MOBILITY = 16384;
    public static final int EDIT_PUBLIC_FOLDERS = 32768;
    public static final int READ_CREATE_SHARED_FOLDERS = 65536;
    public static final int DELEGATE_TASKS = 131072;
    public static final int EDIT_GROUP = 262144;
    public static final int EDIT_RESOURCE = 524288;
    public static final int EDIT_PASSWORD = 0x100000;
    public static final int COLLECT_EMAIL_ADDRESSES = 0x200000;
    public static final int MULTIPLE_MAIL_ACCOUNTS = 0x400000;
    public static final int SUBSCRIPTION = 0x800000;
    public static final int PUBLICATION = 0x1000000;
    public static final int ACTIVE_SYNC = 0x2000000;
    public static final int USM = 0x4000000;
    public static final int OLOX20 = 0x8000000;
    public static final int DENIED_PORTAL = 0x10000000;
    public static final int CALDAV = 0x20000000;
    public static final int CARDDAV = 0x40000000;
    private final int userId;
    private final int contextId;
    private int permissionBits;
    private int[] groups;

    public UserPermissionBits(int permissions, int userId, int contextId) {
        this(permissions, userId, null, contextId);
    }

    public UserPermissionBits(int permissions, int userId, int[] groups, int contextId) {
        this.userId = userId;
        this.groups = groups;
        this.contextId = contextId;
        this.permissionBits = permissions;
    }

    public UserPermissionBits clone() {
        try {
            UserPermissionBits clone = (UserPermissionBits)super.clone();
            if (this.groups != null) {
                clone.groups = new int[this.groups.length];
                System.arraycopy(this.groups, 0, clone.groups, 0, this.groups.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public int getPermissionBits() {
        return this.permissionBits;
    }

    public void setPermissionBits(int permissionBits) {
        this.permissionBits = permissionBits;
    }

    public boolean hasWebMail() {
        return this.hasPermission(1);
    }

    public void setWebMail(boolean enableWebMail) {
        this.setPermission(enableWebMail, 1);
    }

    public boolean hasCalendar() {
        return this.hasPermission(2);
    }

    public void setCalendar(boolean enableCalender) {
        this.setPermission(enableCalender, 2);
    }

    public boolean hasContact() {
        return this.hasPermission(4);
    }

    public void setContact(boolean enableContact) {
        this.setPermission(enableContact, 4);
    }

    public boolean hasTask() {
        return this.hasPermission(8);
    }

    public void setTask(boolean enableTask) {
        this.setPermission(enableTask, 8);
    }

    public boolean hasInfostore() {
        return this.hasPermission(16);
    }

    public void setInfostore(boolean enableInfostore) {
        this.setPermission(enableInfostore, 16);
    }

    public boolean hasProject() {
        return false;
    }

    public boolean hasForum() {
        return this.hasPermission(64);
    }

    public void setForum(boolean enableForum) {
        this.setPermission(enableForum, 64);
    }

    public boolean hasPinboardWriteAccess() {
        return this.hasPermission(128);
    }

    public void setPinboardWriteAccess(boolean enablePinboardWriteAccess) {
        this.setPermission(enablePinboardWriteAccess, 128);
    }

    public boolean hasWebDAVXML() {
        return this.hasPermission(256);
    }

    public void setWebDAVXML(boolean enableWebDAVXML) {
        this.setPermission(enableWebDAVXML, 256);
    }

    public boolean hasWebDAV() {
        return this.hasPermission(512);
    }

    public void setWebDAV(boolean enableWebDAV) {
        this.setPermission(enableWebDAV, 512);
    }

    public boolean hasICal() {
        return this.hasPermission(1024);
    }

    public void setICal(boolean enableICal) {
        this.setPermission(enableICal, 1024);
    }

    public boolean hasVCard() {
        return this.hasPermission(2048);
    }

    public void setVCard(boolean enableVCard) {
        this.setPermission(enableVCard, 2048);
    }

    public boolean hasRSSBookmarks() {
        return this.hasPermission(4096);
    }

    public void setRSSBookmarks(boolean enableRSSBookmarks) {
        this.setPermission(enableRSSBookmarks, 4096);
    }

    public boolean hasRSSPortal() {
        return this.hasPermission(8192);
    }

    public void setRSSPortal(boolean enableRSSPortal) {
        this.setPermission(enableRSSPortal, 8192);
    }

    public boolean hasSyncML() {
        return this.hasPermission(16384);
    }

    public void setSyncML(boolean enableSyncML) {
        this.setPermission(enableSyncML, 16384);
    }

    public boolean hasPIM() {
        return this.hasCalendar() && this.hasContact() && this.hasTask();
    }

    public boolean hasTeamView() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasFreeBusy() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasConflictHandling() {
        return this.hasCalendar() && this.hasFullSharedFolderAccess() && this.hasFullPublicFolderAccess();
    }

    public boolean hasParticipantsDialog() {
        return this.hasConflictHandling();
    }

    public boolean hasGroupware() {
        return this.hasFullSharedFolderAccess() || this.hasFullPublicFolderAccess();
    }

    public boolean hasPortal() {
        return !this.hasPermission(0x10000000);
    }

    public void setDeniedPortal(boolean deniedPortal) {
        this.setPermission(deniedPortal, 0x10000000);
    }

    public int[] getAccessibleModules() {
        TIntArrayList array = new TIntArrayList(10);
        if (this.hasTask()) {
            array.add(1);
        }
        if (this.hasCalendar()) {
            array.add(2);
        }
        if (this.hasContact()) {
            array.add(3);
        }
        array.add(4);
        array.add(5);
        if (this.hasWebMail()) {
            array.add(7);
        }
        if (this.hasInfostore()) {
            array.add(8);
        }
        array.add(13);
        array.add(14);
        return array.toArray();
    }

    public boolean hasModuleAccess(int module) {
        return Arrays.binarySearch(this.getAccessibleModules(), module) >= 0;
    }

    public boolean hasFullPublicFolderAccess() {
        return this.hasPermission(32768);
    }

    public void setFullPublicFolderAccess(boolean enableFullPublicFolderAccess) {
        this.setPermission(enableFullPublicFolderAccess, 32768);
    }

    public boolean hasFullSharedFolderAccess() {
        return this.hasPermission(65536);
    }

    public void setFullSharedFolderAccess(boolean enableFullSharedFolderAccess) {
        this.setPermission(enableFullSharedFolderAccess, 65536);
    }

    public boolean canDelegateTasks() {
        return this.hasPermission(131072);
    }

    public void setDelegateTasks(boolean enableDelegateTasks) {
        this.setPermission(enableDelegateTasks, 131072);
    }

    public boolean isCollectEmailAddresses() {
        return this.hasPermission(0x200000);
    }

    public void setCollectEmailAddresses(boolean collectEmailAddresses) {
        this.setPermission(collectEmailAddresses, 0x200000);
    }

    public boolean isMultipleMailAccounts() {
        return this.hasPermission(0x400000);
    }

    public void setMultipleMailAccounts(boolean multipleMailAccounts) {
        this.setPermission(multipleMailAccounts, 0x400000);
    }

    public boolean isSubscription() {
        return this.hasPermission(0x800000);
    }

    public void setSubscription(boolean subscription) {
        this.setPermission(subscription, 0x800000);
    }

    public boolean isPublication() {
        return this.hasPermission(0x1000000);
    }

    public void setPublication(boolean publication) {
        this.setPermission(publication, 0x1000000);
    }

    public boolean hasActiveSync() {
        return this.hasPermission(0x2000000);
    }

    public void setActiveSync(boolean eas) {
        this.setPermission(eas, 0x2000000);
    }

    public boolean hasUSM() {
        return this.hasPermission(0x4000000);
    }

    public void setUSM(boolean usm) {
        this.setPermission(usm, 0x4000000);
    }

    public boolean hasOLOX20() {
        return this.hasPermission(0x8000000);
    }

    public void setOLOX20(boolean olox20) {
        this.setPermission(olox20, 0x8000000);
    }

    public boolean isEditGroup() {
        return this.hasPermission(262144);
    }

    public void setEditGroup(boolean editGroup) {
        this.setPermission(editGroup, 262144);
    }

    public boolean isEditResource() {
        return this.hasPermission(524288);
    }

    public void setEditResource(boolean editResource) {
        this.setPermission(editResource, 524288);
    }

    public boolean isEditPassword() {
        return this.hasPermission(0x100000);
    }

    public void setEditPassword(boolean editPassword) {
        this.setPermission(editPassword, 0x100000);
    }

    public boolean hasPermission(int permissionBit) {
        return (this.permissionBits & permissionBit) == permissionBit;
    }

    public boolean hasPermission(Permission permission) {
        if (null == permission) {
            return false;
        }
        return this.hasPermissionInternal(permission);
    }

    private boolean hasPermissionInternal(Permission permission) {
        int bit = permission.bit;
        return (this.permissionBits & bit) == bit;
    }

    private void setPermission(boolean enable, int permission) {
        this.permissionBits = enable ? this.permissionBits | permission : this.permissionBits & ~permission;
    }

    public boolean isGlobalAddressBookEnabled(ServerSession serverSession) {
        Context context = serverSession.getContext();
        if (null == context) {
            return false;
        }
        try {
            return new OXFolderAccess(context).isReadFolder(6, this.userId, this.groups, this);
        }
        catch (OXException e) {
            Logger logger = LoggerFactory.getLogger(UserPermissionBits.class);
            logger.warn("Cannot check availability of Global Address Book.", (Throwable)e);
            return false;
        }
    }

    public int getUserId() {
        return this.userId;
    }

    public int[] getGroups() {
        int[] thisGroups = this.groups;
        if (null == thisGroups) {
            try {
                thisGroups = this.groups = UserStorage.getInstance().getUser(this.userId, this.contextId).getGroups();
            }
            catch (OXException e) {
                thisGroups = this.groups = new int[0];
            }
        }
        return thisGroups;
    }

    public UserPermissionBits setGroups(int[] groups) {
        this.groups = groups;
        return this;
    }

    public int getContextId() {
        return this.contextId;
    }

    public static int getPermissionBits(Set<String> capabilities) {
        int bits = 0;
        if (null != capabilities) {
            for (String string : capabilities) {
                Permission permission = Permission.get(string);
                if (permission == null) continue;
                bits |= permission.bit;
            }
        }
        return bits;
    }

    public Context getContext() {
        try {
            return ContextStorage.getStorageContext(this.contextId);
        }
        catch (OXException e) {
            return null;
        }
    }
}

