/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.RemoveAdminPermissionOnInfostoreTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class CreateReplicationTableTask
extends UpdateTaskAdapter {
    private static final String[] DEPENDENCIES = new String[]{RemoveAdminPermissionOnInfostoreTask.class.getName()};

    @Override
    public int addedWithVersion() {
        return 90;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public String[] getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection con = dbService.getForUpdateTask(contextId);
        try {
            con.setAutoCommit(false);
            if (!Tools.tableExists(con, "replicationMonitor")) {
                this.createTable(con);
            }
            int[] ctxIds = dbService.getContextsInSameSchema(contextId);
            ProgressState status = params.getProgressState();
            status.setTotal(ctxIds.length);
            this.insertZeros(con, ctxIds, status);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            dbService.backForUpdateTask(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertZeros(Connection con, int[] ctxIds, ProgressState status) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("INSERT INTO replicationMonitor (cid, transaction) VALUES (?,0)");
            for (int ctxId : ctxIds) {
                if (!this.entryExists(con, ctxId)) {
                    stmt.setInt(1, ctxId);
                    stmt.addBatch();
                }
                status.incrementState();
            }
            stmt.executeBatch();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean entryExists(Connection con, int ctxId) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT transaction FROM replicationMonitor WHERE cid=?");
            stmt.setInt(1, ctxId);
            result = stmt.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute("CREATE TABLE replicationMonitor (cid INT4 UNSIGNED NOT NULL, transaction INT8 NOT NULL, PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

