/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateConcurrency;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;

public final class ContactAdjustLastModifiedForChangedSenderAddress
extends UpdateTaskAdapter {
    @Override
    public TaskAttributes getAttributes() {
        return new Attributes(UpdateConcurrency.BACKGROUND);
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = dbService.getForUpdateTask(cid);
        try {
            con.setAutoCommit(false);
            this.adjustLastModified(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustLastModified(final Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT prg_contacts.intfield01,prg_contacts.cid FROM prg_contacts LEFT JOIN user_setting_mail ON prg_contacts.cid = user_setting_mail.cid AND prg_contacts.userid = user_setting_mail.user WHERE prg_contacts.userid > 0 AND prg_contacts.field65 <> user_setting_mail.send_addr;");
            rs = stmt.executeQuery();
            TIntObjectHashMap map = new TIntObjectHashMap(1024);
            while (rs.next()) {
                int cid = rs.getInt(2);
                TIntList ids = (TIntList)map.get(cid);
                if (null == ids) {
                    ids = new TIntLinkedList();
                    map.put(cid, (Object)ids);
                }
                ids.add(rs.getInt(1));
            }
            DBUtils.closeSQLStuff(rs, stmt);
            final AtomicReference exceptionReference = new AtomicReference();
            map.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntList>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(final int cid, TIntList ids) {
                    boolean bl;
                    final long now = System.currentTimeMillis();
                    PreparedStatement innerStmt = null;
                    try {
                        final PreparedStatement pStmt = innerStmt = con.prepareStatement("UPDATE prg_contacts SET changing_date = ? WHERE cid = ? AND intfield01 = ?;");
                        ids.forEach(new TIntProcedure(){

                            public boolean execute(int id) {
                                try {
                                    pStmt.setLong(1, now);
                                    pStmt.setInt(2, cid);
                                    pStmt.setInt(3, id);
                                    pStmt.addBatch();
                                    return true;
                                }
                                catch (SQLException e) {
                                    exceptionReference.set(e);
                                    return false;
                                }
                            }
                        });
                        SQLException sqlException = (SQLException)exceptionReference.get();
                        if (null != sqlException) {
                            throw sqlException;
                        }
                        innerStmt.executeBatch();
                        bl = true;
                    }
                    catch (SQLException e) {
                        boolean bl2;
                        try {
                            exceptionReference.set(e);
                            bl2 = false;
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(innerStmt);
                            throw throwable;
                        }
                        DBUtils.closeSQLStuff(innerStmt);
                        return bl2;
                    }
                    DBUtils.closeSQLStuff(innerStmt);
                    return bl;
                }
            });
            SQLException sqlException = (SQLException)exceptionReference.get();
            if (null != sqlException) {
                throw sqlException;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

