/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.tools.Collections;
import com.openexchange.tools.iterator.SearchIterator;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Reminder {
    private static final Logger LOG = LoggerFactory.getLogger(Reminder.class);

    private Reminder() {
    }

    static void createReminder(Context ctx, Task task) throws OXException {
        ReminderObject remind = new ReminderObject();
        remind.setDate(task.getAlarm());
        remind.setModule(4);
        remind.setTargetId(task.getObjectID());
        remind.setFolder(task.getParentFolderID());
        remind.setUser(task.getCreatedBy());
        ReminderHandler reminder = new ReminderHandler(ctx);
        reminder.insertReminder(remind);
    }

    static void fixAlarm(Context ctx, Task task, Set<TaskParticipant> removed, Set<TaskParticipant> participants, Set<Folder> folders2) throws OXException {
        int userId;
        ReminderHandler reminder = new ReminderHandler(ctx);
        int taskId = task.getObjectID();
        for (InternalParticipant participant : ParticipantStorage.extractInternal(removed)) {
            userId = participant.getIdentifier();
            if (!reminder.existsReminder(taskId, userId, 4)) continue;
            reminder.deleteReminder(taskId, userId, 4);
        }
        for (InternalParticipant participant : ParticipantStorage.extractInternal(participants)) {
            userId = participant.getIdentifier();
            if (!reminder.existsReminder(taskId, userId, 4)) continue;
            ReminderObject remind = reminder.loadReminder(taskId, userId, 4);
            int folderId = Reminder.getFolderId(participant, folders2);
            try {
                if (remind.getFolder() == folderId) continue;
                remind.setFolder(folderId);
                reminder.updateReminder(remind);
            }
            catch (NumberFormatException nfe) {
                LOG.error("Parsing reminder folder identifier failed.", (Throwable)nfe);
            }
        }
    }

    private static int getFolderId(InternalParticipant participant, Set<Folder> folders2) {
        if (-1 == participant.getFolderId()) {
            if (1 != folders2.size()) {
                return -1;
            }
            return folders2.iterator().next().getIdentifier();
        }
        return participant.getFolderId();
    }

    static void updateAlarm(Context ctx, Task task, User user) throws OXException {
        ReminderHandler reminder = new ReminderHandler(ctx);
        int taskId = task.getObjectID();
        int userId = user.getId();
        if (null == task.getAlarm()) {
            if (reminder.existsReminder(taskId, userId, 4)) {
                reminder.deleteReminder(taskId, userId, 4);
            }
        } else {
            ReminderObject remind = new ReminderObject();
            remind.setDate(task.getAlarm());
            remind.setModule(4);
            remind.setTargetId(taskId);
            remind.setFolder(task.getParentFolderID());
            remind.setUser(userId);
            if (reminder.existsReminder(taskId, userId, 4)) {
                reminder.updateReminder(remind);
            } else {
                reminder.insertReminder(remind);
            }
        }
    }

    static void loadReminder(Context ctx, int userId, Collection<Task> tasks2) throws OXException {
        ReminderHandler remStor = new ReminderHandler(ctx);
        HashMap<Integer, Task> tmp = new HashMap<Integer, Task>();
        for (Task task : tasks2) {
            tmp.put(task.getObjectID(), task);
        }
        ReminderObject[] reminders = remStor.loadReminder(Collections.toArray(tmp.keySet()), userId, 4);
        for (ReminderObject reminder : reminders) {
            ((Task)tmp.get(reminder.getTargetId())).setAlarm(reminder.getDate());
        }
    }

    static void loadReminder(Context ctx, int userId, Collection<Task> tasks2, Connection con) throws OXException {
        ReminderObject[] reminders;
        ReminderHandler remStor = new ReminderHandler(ctx);
        HashMap<Integer, Task> tmp = new HashMap<Integer, Task>();
        for (Task task : tasks2) {
            tmp.put(task.getObjectID(), task);
        }
        for (ReminderObject reminder : reminders = remStor.loadReminders(Collections.toArray(tmp.keySet()), userId, 4, con)) {
            ((Task)tmp.get(reminder.getTargetId())).setAlarm(reminder.getDate());
        }
    }

    static void loadReminder(Context ctx, int userId, Task task) throws OXException {
        ReminderHandler reminder = new ReminderHandler(ctx);
        int taskId = task.getObjectID();
        if (reminder.existsReminder(taskId, userId, 4)) {
            ReminderObject remind = reminder.loadReminder(taskId, userId, 4);
            task.setAlarm(remind.getDate());
        }
    }

    static void deleteReminder(Context ctx, Connection con, Task task) throws OXException {
        block2: {
            ReminderHandler reminder = new ReminderHandler(ctx);
            try {
                reminder.deleteReminder(task.getObjectID(), 4, con);
            }
            catch (OXException e) {
                if (ReminderExceptionCode.NOT_FOUND.equals(e)) break block2;
                throw e;
            }
        }
    }

    static void updateReminderOnMove(Context ctx, int taskId, int sourceFolderId, int destFolderId, boolean privateFlag) throws OXException {
        FolderObject folder = Tools.getFolder(ctx, destFolderId);
        ReminderHandler service = new ReminderHandler(ctx);
        SearchIterator<ReminderObject> iter = service.listReminder(4, taskId);
        while (iter.hasNext()) {
            ReminderObject reminder = (ReminderObject)iter.next();
            if (reminder.getFolder() != sourceFolderId) continue;
            int userId = reminder.getUser();
            User user = Tools.getUser(ctx, userId);
            UserPermissionBits userPerms = Tools.getUserPermissionBits(ctx, userId);
            try {
                boolean testFlag = Permission.canReadInFolder(ctx, user, userPerms, folder);
                if (testFlag && privateFlag) {
                    throw new OXException();
                }
                reminder.setFolder(destFolderId);
                service.updateReminder(reminder);
            }
            catch (OXException e) {
                service.deleteReminder(reminder);
            }
        }
    }
}

