/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder;

import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.reminder.ReminderConfig;
import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderConfigImpl
extends AbstractConfigWrapper
implements ReminderConfig {
    private boolean isReminderEnabled = false;
    private int reminderInterval = 3600000;
    private boolean isInit = false;
    private static final Logger LOG = LoggerFactory.getLogger(ReminderConfigImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderConfigImpl(String propfile) {
        if (this.isInit) {
            return;
        }
        if (propfile == null) {
            LOG.error("missing propfile");
            return;
        }
        Properties prop = null;
        try {
            LOG.debug("try to load propfile: {}", (Object)propfile);
            prop = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propfile);
                prop.load(fis);
            }
            catch (Throwable throwable) {
                Streams.close(fis);
                throw throwable;
            }
            Streams.close((Closeable)fis);
        }
        catch (FileNotFoundException exc) {
            LOG.error("Cannot find propfile: {}", (Object)propfile, (Object)exc);
        }
        catch (IOException exc) {
            LOG.error("Cannot read propfile: {}", (Object)propfile, (Object)exc);
        }
        this.isReminderEnabled = ReminderConfigImpl.parseProperty(prop, "com.openexchange.groupware.reminder.isReminderEnabled", this.isReminderEnabled);
        LOG.debug("Reminder property: com.openexchange.groupware.reminder.isReminderEnabled={}", (Object)this.isReminderEnabled);
        this.reminderInterval = ReminderConfigImpl.parseProperty(prop, "com.openexchange.groupware.reminder.reminderInterval", this.reminderInterval);
        LOG.debug("Reminder property: com.openexchange.groupware.reminder.reminderInterval={}", (Object)this.reminderInterval);
        this.isInit = true;
    }

    @Override
    public boolean isReminderEnabled() {
        return this.isReminderEnabled;
    }

    @Override
    public int getReminderInterval() {
        return this.reminderInterval;
    }
}

