/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.modules;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;

public enum Module {
    TASK("tasks", 1),
    CALENDAR("calendar", 2),
    CONTACTS("contacts", 3),
    UNBOUND("unbound", 4),
    MAIL("mail", 7),
    INFOSTORE("infostore", 8),
    SYSTEM("system", 5);

    private final String name;
    private final int folderConstant;
    private static final TIntObjectMap<Module> folderConstant2Module;
    private static final TObjectIntMap<String> string2FolderConstant;

    private Module(String name, int folderConstant) {
        this.name = name;
        this.folderConstant = folderConstant;
    }

    public static Module getForFolderConstant(int constant) {
        return (Module)((Object)folderConstant2Module.get(constant));
    }

    public String getName() {
        return this.name;
    }

    public int getFolderConstant() {
        return this.folderConstant;
    }

    public static final String getModuleString(int module, int folderId) {
        String moduleStr = null;
        switch (module) {
            case 1: {
                moduleStr = TASK.getName();
                break;
            }
            case 3: {
                moduleStr = CONTACTS.getName();
                break;
            }
            case 2: {
                moduleStr = CALENDAR.getName();
                break;
            }
            case 4: {
                moduleStr = UNBOUND.getName();
                break;
            }
            case 7: {
                moduleStr = MAIL.getName();
                break;
            }
            case 8: {
                moduleStr = INFOSTORE.getName();
                break;
            }
            case 5: {
                if (folderId == 9) {
                    moduleStr = INFOSTORE.getName();
                    break;
                }
                moduleStr = SYSTEM.getName();
                break;
            }
            default: {
                moduleStr = "";
            }
        }
        return moduleStr;
    }

    public static final int getModuleInteger(String moduleStr) {
        return null == moduleStr ? -1 : string2FolderConstant.get((Object)moduleStr);
    }

    static {
        Module[] values = Module.values();
        TIntObjectHashMap map1 = new TIntObjectHashMap(values.length);
        TObjectIntHashMap map2 = new TObjectIntHashMap(values.length, 0.5f, -1);
        for (Module module : values) {
            map1.put(module.folderConstant, (Object)module);
            map2.put((Object)module.name, module.folderConstant);
        }
        folderConstant2Module = map1;
        string2FolderConstant = map2;
    }
}

