/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.MetadataSwitcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InfostoreQueryCatalog {
    private static final String SQL_CHUNK05 = " AND infostore.last_modified > ";
    private static final String SQL_CHUNK04 = " FROM infostore JOIN infostore_document ON infostore.cid = ";
    private static final String SQL_CHUNK03 = " AND infostore_document.cid = ";
    private static final String SQL_CHUNK02 = " AND infostore.created_by = ";
    private static final String SQL_CHUNK01 = " AND infostore.version = infostore_document.version_number AND infostore.id = infostore_document.infostore_id WHERE infostore.folder_id = ";
    private static final String STR_SELECT = "SELECT ";
    private static final String STR_ORDER_BY = " ORDER BY ";
    private static final String STR_CID = "cid";
    public static final Metadata[] INFOSTORE_FIELDS = new Metadata[]{Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL, Metadata.VERSION_LITERAL, Metadata.COLOR_LABEL_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.CREATED_BY_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.LAST_MODIFIED_UTC_LITERAL};
    public static final Set<Metadata> INFOSTORE_FIELDS_SET = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(INFOSTORE_FIELDS)));
    public static final Metadata[] DEL_INFOSTORE_FIELDS = new Metadata[]{Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL, Metadata.VERSION_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.CREATED_BY_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.LAST_MODIFIED_UTC_LITERAL, Metadata.COLOR_LABEL_LITERAL};
    public static final Set<Metadata> DEL_INFOSTORE_FIELDS_SET = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(DEL_INFOSTORE_FIELDS)));
    public static final Metadata[] INFOSTORE_DOCUMENT_FIELDS = new Metadata[]{Metadata.ID_LITERAL, Metadata.VERSION_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.CREATED_BY_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL, Metadata.DESCRIPTION_LITERAL, Metadata.CATEGORIES_LITERAL, Metadata.FILENAME_LITERAL, Metadata.FILE_SIZE_LITERAL, Metadata.FILE_MIMETYPE_LITERAL, Metadata.FILE_MD5SUM_LITERAL, Metadata.VERSION_COMMENT_LITERAL, Metadata.FILESTORE_LOCATION_LITERAL, Metadata.LAST_MODIFIED_UTC_LITERAL, Metadata.META_LITERAL};
    public static final Set<Metadata> INFOSTORE_DOCUMENT_FIELDS_SET = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(INFOSTORE_DOCUMENT_FIELDS)));
    public static final Metadata[] DEL_INFOSTORE_DOCUMENT_FIELDS = new Metadata[]{Metadata.ID_LITERAL, Metadata.VERSION_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.CREATED_BY_LITERAL, Metadata.MODIFIED_BY_LITERAL};
    public static final Set<Metadata> DEL_INFOSTORE_DOCUMENT_FIELDS_SET = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(DEL_INFOSTORE_DOCUMENT_FIELDS)));
    public static final Set<Metadata> IGNORE_ON_WRITE = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(Metadata.LAST_MODIFIED_UTC_LITERAL)));
    private static final String INSERT_INFOSTORE = InfostoreQueryCatalog.buildInsert(Table.INFOSTORE, "cid");
    private static final String INSERT_INFOSTORE_DOCUMENT = InfostoreQueryCatalog.buildInsert(Table.INFOSTORE_DOCUMENT, "cid");
    private static final String INSERT_DEL_INFOSTORE = InfostoreQueryCatalog.buildInsert(Table.DEL_INFOSTORE, "cid");

    public Metadata[] filterWritable(Metadata[] fields) {
        boolean mustRemove = false;
        for (Metadata field : fields) {
            mustRemove = mustRemove || IGNORE_ON_WRITE.contains(field);
        }
        if (!mustRemove) {
            return fields;
        }
        Metadata[] writableFields = new Metadata[fields.length - IGNORE_ON_WRITE.size()];
        int index = 0;
        for (Metadata field : fields) {
            if (IGNORE_ON_WRITE.contains(field)) continue;
            writableFields[index++] = field;
        }
        return writableFields;
    }

    private static String buildInsert(String tablename, Metadata[] metadata, MetadataSwitcher columnNames, String ... additionalFields) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tablename).append(" (");
        StringBuilder questionMarks = new StringBuilder();
        for (Metadata m : metadata) {
            String col;
            if (IGNORE_ON_WRITE.contains(m) || (col = (String)m.doSwitch(columnNames)) == null) continue;
            builder.append(col);
            builder.append(',');
            questionMarks.append("?,");
        }
        for (String s : additionalFields) {
            builder.append(s);
            builder.append(',');
            questionMarks.append("?,");
        }
        builder.setLength(builder.length() - 1);
        questionMarks.setLength(questionMarks.length() - 1);
        builder.append(") VALUES (").append(questionMarks.toString()).append(')');
        return builder.toString();
    }

    private static String buildInsert(Table t, String ... additionalFields) {
        return InfostoreQueryCatalog.buildInsert(t.getTablename(), t.getFields(), t.getFieldSwitcher(), additionalFields);
    }

    private static StringBuilder buildUpdateWithoutWhere(Table table, Metadata[] metadata, MetadataSwitcher columnNames, String ... additionalFields) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(table.getTablename()).append(" SET ");
        for (Metadata m : metadata) {
            String col;
            if (m == Metadata.VERSION_LITERAL && (table == Table.INFOSTORE_DOCUMENT || table == Table.DEL_INFOSTORE_DOCUMENT) || IGNORE_ON_WRITE.contains(m) || (col = (String)m.doSwitch(columnNames)) == null) continue;
            builder.append(col);
            builder.append(" = ?,");
        }
        for (String s : additionalFields) {
            builder.append(s);
            builder.append(" = ?,");
        }
        builder.setLength(builder.length() - 1);
        return builder;
    }

    public List<String> getDelete(Table t, List<DocumentMetadata> documents) {
        switch (t) {
            default: {
                break;
            }
            case INFOSTORE_DOCUMENT: 
            case DEL_INFOSTORE_DOCUMENT: {
                throw new IllegalArgumentException("getDelete is only applicable for the non version tables infostore and del_infostore");
            }
        }
        int size = documents.size();
        ArrayList<String> l = new ArrayList<String>(2);
        Table versionTable = Table.INFOSTORE.equals((Object)t) ? Table.INFOSTORE_DOCUMENT : Table.DEL_INFOSTORE_DOCUMENT;
        StringBuilder delete = new StringBuilder("DELETE FROM ").append(versionTable.getTablename()).append(" WHERE ").append(Metadata.ID_LITERAL.doSwitch(versionTable.getFieldSwitcher())).append(" IN (");
        delete.append(documents.get(0).getId());
        for (int i = 1; i < size; ++i) {
            delete.append(',').append(documents.get(i).getId());
        }
        delete.append(") AND cid = ?");
        l.add(delete.toString());
        StringBuilder delete2 = new StringBuilder("DELETE FROM ").append(t.getTablename()).append(" WHERE ").append(Metadata.ID_LITERAL.doSwitch(t.getFieldSwitcher())).append(" IN (");
        delete2.append(documents.get(0).getId());
        for (int i = 1; i < size; ++i) {
            delete2.append(',').append(documents.get(i).getId());
        }
        delete2.append(") AND cid = ?");
        l.add(delete2.toString());
        return l;
    }

    public List<String> getSingleDelete(Table t) {
        switch (t) {
            default: {
                break;
            }
            case INFOSTORE_DOCUMENT: 
            case DEL_INFOSTORE_DOCUMENT: {
                throw new IllegalArgumentException("getDelete is only applicable for the non version tables infostore and del_infostore");
            }
        }
        ArrayList<String> l = new ArrayList<String>(2);
        Table versionTable = Table.INFOSTORE.equals((Object)t) ? Table.INFOSTORE_DOCUMENT : Table.DEL_INFOSTORE_DOCUMENT;
        StringBuilder delete = new StringBuilder("DELETE FROM ").append(versionTable.getTablename()).append(" WHERE ").append(Metadata.ID_LITERAL.doSwitch(versionTable.getFieldSwitcher())).append("  = ? AND cid = ?");
        l.add(delete.toString());
        StringBuilder delete2 = new StringBuilder("DELETE FROM ").append(t.getTablename()).append(" WHERE ").append(Metadata.ID_LITERAL.doSwitch(t.getFieldSwitcher())).append("  = ? AND cid = ?");
        l.add(delete2.toString());
        return l;
    }

    public String getReplace(Table table, int count) {
        if (1 > count) {
            throw new IllegalArgumentException("need at least one item to create statement");
        }
        Metadata[] fields = table.getFields();
        MetadataSwitcher switcher = table.getFieldSwitcher();
        StringBuilder questionMarksAllocator = new StringBuilder("(");
        StringBuilder allocator = new StringBuilder("REPLACE INTO ").append(table.getTablename()).append(" (");
        for (int i = 0; i < fields.length; ++i) {
            Object sqlField;
            if (IGNORE_ON_WRITE.contains(fields[i]) || (sqlField = fields[i].doSwitch(switcher)) == null) continue;
            questionMarksAllocator.append("?,");
            allocator.append(sqlField).append(',');
        }
        String questionMarks = questionMarksAllocator.append("?)").toString();
        allocator.append("cid) VALUES ").append(questionMarks);
        for (int i = 1; i < count; ++i) {
            allocator.append(',').append(questionMarks);
        }
        allocator.append(';');
        return allocator.toString();
    }

    public String getDocumentInsert() {
        return INSERT_INFOSTORE;
    }

    public String getDelDocumentInsert() {
        return INSERT_DEL_INFOSTORE;
    }

    public String getDocumentUpdate(Metadata[] fields) {
        return InfostoreQueryCatalog.buildUpdateWithoutWhere(Table.INFOSTORE, fields, Table.INFOSTORE.getFieldSwitcher(), new String[0]).append(" WHERE cid = ? and id = ? and last_modified <= ?").toString();
    }

    public String getNumberOfVersionsQueryForOneDocument() {
        Table table = Table.INFOSTORE_DOCUMENT;
        String idColumn = (String)Metadata.ID_LITERAL.doSwitch(table.getFieldSwitcher());
        StringBuilder builder = new StringBuilder(200);
        builder.append("SELECT COUNT(infostore_id) AS number_of_versions FROM infostore_document WHERE ").append(idColumn).append(" = ? ").append("AND cid = ? GROUP BY infostore_id");
        return builder.toString();
    }

    public Metadata[] getDocumentFields() {
        return Table.INFOSTORE.getFields();
    }

    public Metadata[] getDelDocumentFields() {
        return Table.DEL_INFOSTORE.getFields();
    }

    public Metadata[] getWritableDocumentFields() {
        Metadata[] fields = this.getDocumentFields();
        return this.filterWritable(fields);
    }

    public Metadata[] getWritableDelDocumentFields() {
        Metadata[] fields = this.getDelDocumentFields();
        return this.filterWritable(fields);
    }

    public Metadata[] filterForDocument(Metadata[] modified) {
        ArrayList<Metadata> m = new ArrayList<Metadata>();
        Set<Metadata> knownFields = Table.INFOSTORE.getFieldSet();
        for (Metadata metadata : modified) {
            if (!knownFields.contains(metadata)) continue;
            m.add(metadata);
        }
        return m.toArray(new Metadata[m.size()]);
    }

    public boolean updateDocument(Metadata[] modifiedColumns) {
        Set<Metadata> fields = Table.INFOSTORE.getFieldSet();
        for (Metadata m : modifiedColumns) {
            if (!fields.contains(m)) continue;
            return true;
        }
        return false;
    }

    public String getVersionInsert() {
        return INSERT_INFOSTORE_DOCUMENT;
    }

    public String getVersionUpdate(Metadata[] fields) {
        return InfostoreQueryCatalog.buildUpdateWithoutWhere(Table.INFOSTORE_DOCUMENT, fields, Table.INFOSTORE_DOCUMENT.getFieldSwitcher(), new String[0]).append(" WHERE cid = ? and infostore_id = ? and version_number = ? and last_modified <= ?").toString();
    }

    public Metadata[] getVersionFields() {
        return Table.INFOSTORE_DOCUMENT.getFields();
    }

    public Metadata[] getDelVersionFields() {
        return Table.DEL_INFOSTORE_DOCUMENT.getFields();
    }

    public Metadata[] getWritableVersionFields() {
        Metadata[] fields = this.getVersionFields();
        return this.filterWritable(fields);
    }

    public Metadata[] getWritableDelVersionFields() {
        Metadata[] fields = this.getDelVersionFields();
        return this.filterWritable(fields);
    }

    public Metadata[] filterForVersion(Metadata[] modified) {
        ArrayList<Metadata> m = new ArrayList<Metadata>();
        Set<Metadata> knownFields = Table.INFOSTORE_DOCUMENT.getFieldSet();
        for (Metadata metadata : modified) {
            if (metadata == Metadata.VERSION_LITERAL || !knownFields.contains(metadata)) continue;
            m.add(metadata);
        }
        return m.toArray(new Metadata[m.size()]);
    }

    public boolean updateVersion(Metadata[] modifiedColumns) {
        Set<Metadata> fields = Table.INFOSTORE_DOCUMENT.getFieldSet();
        for (Metadata m : modifiedColumns) {
            if (!fields.contains(m)) continue;
            return true;
        }
        return false;
    }

    public String getVersionDelete(Table t, List<DocumentMetadata> documents) {
        switch (t) {
            default: {
                break;
            }
            case INFOSTORE: 
            case DEL_INFOSTORE: {
                throw new IllegalArgumentException("getVersionDelete is only applicable for the version tables infostore_document and del_infostore_document");
            }
        }
        StringBuilder delete = new StringBuilder("DELETE FROM ").append(t.getTablename()).append(" WHERE ( ");
        for (DocumentMetadata doc : documents) {
            delete.append("( ").append(Metadata.ID_LITERAL.doSwitch(t.getFieldSwitcher())).append(" = ").append(doc.getId()).append(" AND ").append(Metadata.VERSION_LITERAL.doSwitch(t.getFieldSwitcher())).append(" = ").append(doc.getVersion()).append(" ) OR ");
        }
        delete.setLength(delete.length() - 6);
        delete.append(") ) AND cid = ?");
        return delete.toString();
    }

    public String getSingleVersionDelete(Table t) {
        switch (t) {
            default: {
                break;
            }
            case INFOSTORE: 
            case DEL_INFOSTORE: {
                throw new IllegalArgumentException("getVersionDelete is only applicable for the version tables infostore_document and del_infostore_document");
            }
        }
        StringBuilder delete = new StringBuilder("DELETE FROM ").append(t.getTablename()).append(" WHERE ").append(Metadata.ID_LITERAL.doSwitch(t.getFieldSwitcher())).append(" = ? AND ").append(Metadata.VERSION_LITERAL.doSwitch(t.getFieldSwitcher())).append(" = ? AND cid = ?");
        return delete.toString();
    }

    public String getAllVersionsDelete(Table t) {
        switch (t) {
            default: {
                break;
            }
            case INFOSTORE: 
            case DEL_INFOSTORE: {
                throw new IllegalArgumentException("getVersionDelete is only applicable for the version tables infostore_document and del_infostore_document");
            }
        }
        StringBuilder delete = new StringBuilder("DELETE FROM ").append(t.getTablename()).append(" WHERE ").append(Metadata.ID_LITERAL.doSwitch(t.getFieldSwitcher())).append(" = ? AND cid = ?");
        return delete.toString();
    }

    public FieldChooser getChooserForVersion(int version2) {
        if (version2 == -1) {
            return new DocumentWins();
        }
        return new VersionWins();
    }

    public String getSelectDocument(int id, int version2, int ctx_id) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(Metadata.VALUES_ARRAY, this.getChooserForVersion(version2))).append(SQL_CHUNK04).append(ctx_id).append(SQL_CHUNK03).append(ctx_id).append(" AND infostore.id = infostore_document.infostore_id ");
        if (version2 == -1) {
            builder.append("AND infostore_document.version_number = infostore.version");
        }
        builder.append(" WHERE infostore.id = ").append(id);
        if (version2 != -1) {
            builder.append(" AND infostore_document.version_number = ").append(version2);
        }
        return builder.toString();
    }

    public String getListQuery(int[] id, Metadata[] metadata, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(" AND infostore.version = infostore_document.version_number AND infostore.id = infostore_document.infostore_id WHERE infostore.id IN (");
        for (int i : id) {
            builder.append(i).append(',');
        }
        builder.setLength(builder.length() - 1);
        builder.append(')');
        return builder.toString();
    }

    public String getDocumentsQuery(long folderId, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getDocumentsQuery(long folderId, int userId, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId).append(SQL_CHUNK02).append(userId);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getVersionsQuery(int id, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(" AND infostore.id = infostore_document.infostore_id ").append(" WHERE infostore.id = ").append(id);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getNewDocumentsQuery(long folderId, long since, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId).append(" AND infostore.creating_date >= ").append(since);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getModifiedDocumentsQuery(long folderId, long since, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId).append(SQL_CHUNK05).append(since);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getDeletedDocumentsQuery(long folderId, long since, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder("SELECT infostore.id").append(" FROM del_infostore as infostore WHERE infostore.folder_id = ").append(folderId).append(" AND infostore.cid = ").append(contextId).append(SQL_CHUNK05).append(since);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getNewDocumentsQuery(long folderId, int userId, long since, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId).append(" AND infostore.creating_date >= ").append(since).append(SQL_CHUNK02).append(userId);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getModifiedDocumentsQuery(long folderId, int userId, long since, Metadata[] metadata, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId).append(SQL_CHUNK05).append(since).append(SQL_CHUNK02).append(userId);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getDeletedDocumentsQuery(long folderId, int userId, long since, Metadata sort, int order, FieldChooser wins, int contextId) {
        StringBuilder builder = new StringBuilder("SELECT infostore.id").append(" FROM del_infostore as infostore WHERE infostore.folder_id = ").append(folderId).append(" AND infostore.cid = ").append(contextId).append(SQL_CHUNK05).append(since).append(SQL_CHUNK02).append(userId);
        if (sort != null) {
            builder.append(STR_ORDER_BY).append(this.fieldName(sort, wins)).append(' ').append(this.order(order));
        }
        return builder.toString();
    }

    public String getCurrentFilenameQuery(long folderId, Metadata[] metadata, DocumentWins wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(SQL_CHUNK01).append(folderId).append(" AND infostore_document.filename = ?");
        return builder.toString();
    }

    public String getAllVersionsQuery(String where, Metadata[] metadata, VersionWins wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(" AND infostore.id = infostore_document.infostore_id").append(" WHERE ").append(where);
        return builder.toString();
    }

    public String getAllDocumentsQuery(String where, Metadata[] metadata, DocumentWins wins, int contextId) {
        StringBuilder builder = new StringBuilder(STR_SELECT).append(this.fields(metadata, wins)).append(SQL_CHUNK04).append(contextId).append(SQL_CHUNK03).append(contextId).append(" AND infostore.version = infostore_document.version_number AND infostore.id = infostore_document.infostore_id WHERE ").append(where);
        return builder.toString();
    }

    public String getFolderSequenceNumbersQuery(List<Long> folderIds, boolean versionsOnly, boolean deleted, int contextId) {
        StringBuilder allocator = new StringBuilder(STR_SELECT).append(Metadata.FOLDER_ID_LITERAL.getName()).append(",MAX(").append(Metadata.LAST_MODIFIED_LITERAL.getName()).append(") FROM ").append(deleted ? Table.DEL_INFOSTORE.getTablename() : Table.INFOSTORE.getTablename()).append(" WHERE ").append(STR_CID).append('=').append(contextId);
        if (versionsOnly) {
            allocator.append(" AND ").append(Metadata.VERSION_LITERAL.getName()).append(">0");
        }
        if (1 == folderIds.size()) {
            allocator.append(" AND ").append(Metadata.FOLDER_ID_LITERAL.getName()).append('=').append(folderIds.get(0));
        } else if (1 < folderIds.size()) {
            allocator.append(" AND ").append(Metadata.FOLDER_ID_LITERAL.getName()).append(" IN (").append(folderIds.get(0));
            for (int i = 1; i < folderIds.size(); ++i) {
                allocator.append(',').append(folderIds.get(i));
            }
            allocator.append(')');
        }
        allocator.append(" GROUP BY ").append(Metadata.FOLDER_ID_LITERAL.getName()).append(';');
        return allocator.toString();
    }

    private String order(int order) {
        if (order == -1) {
            return "DESC";
        }
        return "ASC";
    }

    public String[] getFieldTuple(Metadata field, FieldChooser wins) {
        Table t = wins.choose(field);
        String col = (String)field.doSwitch(t.getFieldSwitcher());
        if (col == null) {
            return null;
        }
        return new String[]{t.getTablename(), col};
    }

    private String fieldName(Metadata sort, FieldChooser wins) {
        if (sort == Metadata.CURRENT_VERSION_LITERAL) {
            return "(infostore.version = infostore_document.version_number) AS current_version";
        }
        String[] tuple = this.getFieldTuple(sort, wins);
        if (tuple == null) {
            return null;
        }
        return tuple[0] + '.' + tuple[1];
    }

    private String fields(Metadata[] metadata, FieldChooser wins) {
        StringBuilder builder = new StringBuilder();
        for (Metadata m : metadata) {
            String col = this.fieldName(m, wins);
            if (col == null) continue;
            builder.append(col).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public static class DocumentWins
    implements FieldChooser {
        @Override
        public Table choose(Metadata m) {
            if (Table.INFOSTORE.getFieldSet().contains(m)) {
                return Table.INFOSTORE;
            }
            return Table.INFOSTORE_DOCUMENT;
        }
    }

    public static class VersionWins
    implements FieldChooser {
        @Override
        public Table choose(Metadata m) {
            if (Table.INFOSTORE_DOCUMENT.getFieldSet().contains(m)) {
                return Table.INFOSTORE_DOCUMENT;
            }
            return Table.INFOSTORE;
        }
    }

    public static interface FieldChooser {
        public Table choose(Metadata var1);
    }

    public static final class DelInfostoreDocumentColumnsSwitch
    implements MetadataSwitcher {
        @Override
        public Object categories() {
            return null;
        }

        @Override
        public Object meta() {
            return "meta";
        }

        @Override
        public Object colorLabel() {
            return null;
        }

        @Override
        public Object content() {
            return null;
        }

        @Override
        public Object createdBy() {
            return "created_by";
        }

        @Override
        public Object creationDate() {
            return "creating_date";
        }

        @Override
        public Object currentVersion() {
            return null;
        }

        @Override
        public Object description() {
            return null;
        }

        @Override
        public Object fileMD5Sum() {
            return null;
        }

        @Override
        public Object fileMIMEType() {
            return null;
        }

        @Override
        public Object fileName() {
            return null;
        }

        @Override
        public Object fileSize() {
            return null;
        }

        @Override
        public Object folderId() {
            return null;
        }

        @Override
        public Object id() {
            return "infostore_id";
        }

        @Override
        public Object lastModified() {
            return "last_modified";
        }

        @Override
        public Object lockedUntil() {
            return null;
        }

        @Override
        public Object modifiedBy() {
            return "changed_by";
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object title() {
            return null;
        }

        @Override
        public Object url() {
            return null;
        }

        @Override
        public Object version() {
            return "version_number";
        }

        @Override
        public Object versionComment() {
            return null;
        }

        @Override
        public Object filestoreLocation() {
            return null;
        }

        @Override
        public Object lastModifiedUTC() {
            return this.lastModified();
        }

        @Override
        public Object numberOfVersions() {
            return null;
        }
    }

    public static final class InfostoreDocumentColumnsSwitch
    implements MetadataSwitcher {
        @Override
        public Object categories() {
            return "categories";
        }

        @Override
        public Object meta() {
            return "meta";
        }

        @Override
        public Object colorLabel() {
            return null;
        }

        @Override
        public Object content() {
            return null;
        }

        @Override
        public Object createdBy() {
            return "created_by";
        }

        @Override
        public Object creationDate() {
            return "creating_date";
        }

        @Override
        public Object currentVersion() {
            return null;
        }

        @Override
        public Object description() {
            return "description";
        }

        @Override
        public Object fileMD5Sum() {
            return "file_md5sum";
        }

        @Override
        public Object fileMIMEType() {
            return "file_mimetype";
        }

        @Override
        public Object fileName() {
            return "filename";
        }

        @Override
        public Object fileSize() {
            return "file_size";
        }

        @Override
        public Object folderId() {
            return null;
        }

        @Override
        public Object id() {
            return "infostore_id";
        }

        @Override
        public Object lastModified() {
            return "last_modified";
        }

        @Override
        public Object lockedUntil() {
            return null;
        }

        @Override
        public Object modifiedBy() {
            return "changed_by";
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object title() {
            return "title";
        }

        @Override
        public Object url() {
            return "url";
        }

        @Override
        public Object version() {
            return "version_number";
        }

        @Override
        public Object versionComment() {
            return "file_version_comment";
        }

        @Override
        public Object filestoreLocation() {
            return "file_store_location";
        }

        @Override
        public Object lastModifiedUTC() {
            return this.lastModified();
        }

        @Override
        public Object numberOfVersions() {
            return null;
        }
    }

    public static final class DelInfostoreColumnsSwitch
    implements MetadataSwitcher {
        @Override
        public Object categories() {
            return null;
        }

        @Override
        public Object meta() {
            return null;
        }

        @Override
        public Object colorLabel() {
            return "color_label";
        }

        @Override
        public Object content() {
            return null;
        }

        @Override
        public Object createdBy() {
            return "created_by";
        }

        @Override
        public Object creationDate() {
            return "creating_date";
        }

        @Override
        public Object currentVersion() {
            return null;
        }

        @Override
        public Object description() {
            return null;
        }

        @Override
        public Object fileMD5Sum() {
            return null;
        }

        @Override
        public Object fileMIMEType() {
            return null;
        }

        @Override
        public Object fileName() {
            return null;
        }

        @Override
        public Object fileSize() {
            return null;
        }

        @Override
        public Object folderId() {
            return "folder_id";
        }

        @Override
        public Object id() {
            return "id";
        }

        @Override
        public Object lastModified() {
            return "last_modified";
        }

        @Override
        public Object lockedUntil() {
            return null;
        }

        @Override
        public Object modifiedBy() {
            return "changed_by";
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object title() {
            return null;
        }

        @Override
        public Object url() {
            return null;
        }

        @Override
        public Object version() {
            return "version";
        }

        @Override
        public Object versionComment() {
            return null;
        }

        @Override
        public Object filestoreLocation() {
            return null;
        }

        @Override
        public Object lastModifiedUTC() {
            return this.lastModified();
        }

        @Override
        public Object numberOfVersions() {
            return null;
        }
    }

    public static final class InfostoreColumnsSwitch
    implements MetadataSwitcher {
        @Override
        public Object categories() {
            return null;
        }

        @Override
        public Object colorLabel() {
            return "color_label";
        }

        @Override
        public Object content() {
            return null;
        }

        @Override
        public Object createdBy() {
            return "created_by";
        }

        @Override
        public Object creationDate() {
            return "creating_date";
        }

        @Override
        public Object meta() {
            return null;
        }

        @Override
        public Object currentVersion() {
            return null;
        }

        @Override
        public Object description() {
            return null;
        }

        @Override
        public Object fileMD5Sum() {
            return null;
        }

        @Override
        public Object fileMIMEType() {
            return null;
        }

        @Override
        public Object fileName() {
            return null;
        }

        @Override
        public Object fileSize() {
            return null;
        }

        @Override
        public Object folderId() {
            return "folder_id";
        }

        @Override
        public Object id() {
            return "id";
        }

        @Override
        public Object lastModified() {
            return "last_modified";
        }

        @Override
        public Object lockedUntil() {
            return null;
        }

        @Override
        public Object modifiedBy() {
            return "changed_by";
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object title() {
            return null;
        }

        @Override
        public Object url() {
            return null;
        }

        @Override
        public Object version() {
            return "version";
        }

        @Override
        public Object versionComment() {
            return null;
        }

        @Override
        public Object filestoreLocation() {
            return null;
        }

        @Override
        public Object lastModifiedUTC() {
            return this.lastModified();
        }

        @Override
        public Object numberOfVersions() {
            return null;
        }
    }

    public static enum Table {
        INFOSTORE(INFOSTORE_FIELDS, INFOSTORE_FIELDS_SET, "infostore"),
        INFOSTORE_DOCUMENT(INFOSTORE_DOCUMENT_FIELDS, INFOSTORE_DOCUMENT_FIELDS_SET, "infostore_document"),
        DEL_INFOSTORE(DEL_INFOSTORE_FIELDS, DEL_INFOSTORE_FIELDS_SET, "del_infostore"),
        DEL_INFOSTORE_DOCUMENT(DEL_INFOSTORE_DOCUMENT_FIELDS, DEL_INFOSTORE_DOCUMENT_FIELDS_SET, "del_infostore_document");

        private final String tablename;
        private final Set<Metadata> fieldSet;
        private final Metadata[] fields;

        private Table(Metadata[] fields, Set<Metadata> fieldSet, String tablename) {
            this.fields = fields;
            this.fieldSet = fieldSet;
            this.tablename = tablename;
        }

        public Metadata[] getFields() {
            return this.fields;
        }

        public Set<Metadata> getFieldSet() {
            return this.fieldSet;
        }

        public String getTablename() {
            return this.tablename;
        }

        public MetadataSwitcher getFieldSwitcher() {
            switch (this) {
                case INFOSTORE: {
                    return new InfostoreColumnsSwitch();
                }
                case DEL_INFOSTORE: {
                    return new DelInfostoreColumnsSwitch();
                }
                case INFOSTORE_DOCUMENT: {
                    return new InfostoreDocumentColumnsSwitch();
                }
                case DEL_INFOSTORE_DOCUMENT: {
                    return new DelInfostoreDocumentColumnsSwitch();
                }
            }
            throw new IllegalArgumentException("Will not happen");
        }
    }
}

