/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationException;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentConfig
extends AbstractConfig
implements Initialization {
    private static final ReentrantLock INIT_LOCK = new ReentrantLock();
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentConfig.class);
    private static volatile AttachmentConfig _singleton;
    private static boolean loaded;

    private AttachmentConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttachmentConfig getInstance() {
        AttachmentConfig ret = _singleton;
        if (ret != null) return ret;
        Class<AttachmentConfig> clazz = AttachmentConfig.class;
        synchronized (AttachmentConfig.class) {
            ret = _singleton;
            if (ret != null) return ret;
            _singleton = ret = new AttachmentConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String filename;
        File file = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("attachment.properties");
        String string = filename = null == file ? null : file.getPath();
        if (null == filename) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create("attachment.properties");
        }
        return filename;
    }

    public static String getProperty(String key) {
        AttachmentConfig singleton = _singleton;
        if (!loaded || singleton == null) {
            try {
                singleton = AttachmentConfig.getInstance();
                singleton.start();
            }
            catch (OXException e) {
                LOG.error("Can't init config", (Throwable)e);
            }
        }
        return singleton.getPropertyInternal(key);
    }

    public static long getMaxUploadSize() {
        String sizeS = AttachmentConfig.getProperty(AttachmentProperty.MAX_UPLOAD_SIZE.name());
        if (null == sizeS) {
            return AttachmentConfig.sysconfMaxUpload();
        }
        long size = Long.parseLong(sizeS);
        if (-1L == size) {
            return AttachmentConfig.sysconfMaxUpload();
        }
        return size;
    }

    private static long sysconfMaxUpload() {
        String sizeS = ServerConfig.getProperty(ServerConfig.Property.MAX_UPLOAD_SIZE);
        if (null == sizeS) {
            return 0L;
        }
        return Long.parseLong(sizeS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OXException {
        if (!loaded || _singleton == null) {
            INIT_LOCK.lock();
            try {
                AttachmentConfig.getInstance().loadPropertiesInternal();
                loaded = true;
            }
            finally {
                INIT_LOCK.unlock();
            }
        }
    }

    public void stop() throws ConfigurationException {
        _singleton = null;
        loaded = false;
    }

    static {
        loaded = false;
    }

    public static enum AttachmentProperty {
        MAX_UPLOAD_SIZE;

    }
}

