/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.json.JSONArray;

@Action(method=RequestMethod.POST, name="new", description="Uploading a file", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="module", description="The module for which the file is uploaded to determine proper upload quota constraints (e.g. \"mail\", \"infostore\", etc.)."), @Parameter(name="type", description="The file type filter to define which file types are allowed during upload. Currently supported filters are: file=all, text=text/*, media=image OR audio OR video, image=image/*, audio=audio/*, video=video/*, application=application/*")}, requestBody="A common POST request body of MIME type \"multipart/*\" which holds the file(s) to upload", responseDescription="A JSON array containing the IDs of the uploaded files. The files are accessible through the returned IDs for future use.")
public final class NewAction
implements AJAXActionService {
    private static final String FILE_TYPE_ALL = "file";
    private static final String FILE_TYPE_TEXT = "text";
    private static final String FILE_TYPE_MEDIA = "media";
    private static final String FILE_TYPE_IMAGE = "image";
    private static final String FILE_TYPE_AUDIO = "audio";
    private static final String FILE_TYPE_VIDEO = "video";
    private static final String FILE_TYPE_APPLICATION = "application";

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        if (!requestData.hasUploads()) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create("Not an upload request.");
        }
        UploadEvent upload = requestData.getUploadEvent();
        String moduleParam = requestData.getParameter("module");
        if (moduleParam == null) {
            throw UploadException.UploadCode.MISSING_PARAM.create("module");
        }
        String fileTypeFilter = requestData.getParameter("type");
        if (fileTypeFilter == null) {
            throw UploadException.UploadCode.MISSING_PARAM.create("type");
        }
        JSONArray jArray = new JSONArray();
        ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
        for (UploadFile uploadFile : upload.getUploadFiles()) {
            ContentType ct = new ContentType(uploadFile.getContentType());
            if (!NewAction.checkFileType(fileTypeFilter, ct)) {
                throw UploadException.UploadCode.INVALID_FILE_TYPE.create(uploadFile.getContentType(), fileTypeFilter);
            }
            jArray.put((Object)NewAction.processFileItem(uploadFile, management));
        }
        return new AJAXRequestResult((Object)jArray, "json");
    }

    private static String processFileItem(UploadFile fileItem, ManagedFileManagement management) throws OXException {
        try {
            ManagedFile managedFile = management.createManagedFile((InputStream)new FileInputStream(fileItem.getTmpFile()));
            managedFile.setFileName(fileItem.getPreparedFileName());
            managedFile.setContentType(fileItem.getContentType());
            managedFile.setSize(fileItem.getSize());
            return managedFile.getID();
        }
        catch (FileNotFoundException e) {
            throw ManagedFileExceptionErrorMessage.FILE_NOT_FOUND.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static boolean checkFileType(String filter, ContentType fileContentType) {
        if (FILE_TYPE_ALL.equalsIgnoreCase(filter)) {
            return true;
        }
        if (FILE_TYPE_TEXT.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("text/");
        }
        if (FILE_TYPE_MEDIA.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("image/") || fileContentType.startsWith("audio/") || fileContentType.startsWith("video/");
        }
        if (FILE_TYPE_IMAGE.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("image/");
        }
        if (FILE_TYPE_AUDIO.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("audio/");
        }
        if (FILE_TYPE_VIDEO.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("video/");
        }
        if (FILE_TYPE_APPLICATION.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("application/");
        }
        return false;
    }
}

