/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.osgi;

import com.openexchange.consistency.ConsistencyExceptionCodes;
import com.openexchange.consistency.MBeanNamer;
import com.openexchange.consistency.OsgiOXConsistency;
import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementService;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MBeanRegisterer
implements ServiceTrackerCustomizer<ManagementService, ManagementService> {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegisterer.class);
    private final BundleContext context;
    private ObjectName name;

    public MBeanRegisterer(BundleContext context) {
        this.context = context;
    }

    public ManagementService addingService(ServiceReference<ManagementService> reference) {
        ManagementService managementService = (ManagementService)this.context.getService(reference);
        try {
            this.name = MBeanNamer.getName();
            LOG.info("Registering consistency MBean under name: {}", (Object)this.name);
            managementService.registerMBean(this.name, (Object)new OsgiOXConsistency());
        }
        catch (OXException e) {
            OXException e1 = ConsistencyExceptionCodes.REGISTRATION_FAILED.create(e, new Object[0]);
            LOG.error("", (Throwable)e1);
        }
        catch (MalformedObjectNameException e) {
            OXException e1 = ConsistencyExceptionCodes.REGISTRATION_FAILED.create(e, new Object[0]);
            LOG.error("", (Throwable)e1);
        }
        catch (NullPointerException e) {
            OXException e1 = ConsistencyExceptionCodes.REGISTRATION_FAILED.create(e, new Object[0]);
            LOG.error("", (Throwable)e1);
        }
        return managementService;
    }

    public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
    }

    public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
        ManagementService managementService = service;
        LOG.info("Unregistering consistency MBean with name {}", (Object)this.name);
        try {
            managementService.unregisterMBean(this.name);
        }
        catch (OXException e) {
            OXException e1 = ConsistencyExceptionCodes.UNREGISTRATION_FAILED.create(e, new Object[0]);
            LOG.error("", (Throwable)e1);
        }
        this.name = null;
        this.context.ungetService(reference);
    }
}

