/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.json.ConfigAJAXRequest;
import com.openexchange.config.json.actions.AbstractConfigAction;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.html.HtmlService;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Strings;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="config/path", description="Set configuration data", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="The new value of the node specified by path.")
public final class PUTAction
extends AbstractConfigAction {
    private final Set<String> ignorees = this.loadIgnorees();
    private static final Pattern P_TAG_BODY = Pattern.compile("(?:\r?\n)?</?body[^<]*>(?:\r?\n)?", 2);
    private static final Pattern SPLIT = Pattern.compile("\r?\n");
    private static final Pattern SLASHES = Pattern.compile(Pattern.quote("//"));
    private static final Pattern COMMENT = Pattern.compile("^\\s*[!#]");

    public PUTAction(ServiceLookup services) {
        super(services);
    }

    private Set<String> loadIgnorees() {
        try {
            int keyPos;
            String sPath;
            String path;
            int pos;
            ConfigurationService service = (ConfigurationService)this.services.getService(ConfigurationService.class);
            HashSet<String> ignorees = new HashSet<String>(16);
            String text = service.getText("appsuite.properties");
            if (!Strings.isEmpty((String)text)) {
                for (String line : SPLIT.split(text, 0)) {
                    if (PUTAction.isComment(line) || (pos = line.indexOf(61)) <= 0 || null == (path = (sPath = PUTAction.preparePath(line.substring(0, pos))).substring(0, keyPos = sPath.lastIndexOf(47)))) continue;
                    ignorees.add('/' + path);
                    ignorees.add("/meta/" + path);
                }
            }
            if (!Strings.isEmpty((String)(text = service.getText("paths.perfMap")))) {
                for (String line : SPLIT.split(text, 0)) {
                    if (PUTAction.isComment(line) || (pos = line.indexOf(62)) <= 0 || null == (path = (sPath = PUTAction.preparePath(line.substring(pos + 1))).substring(0, keyPos = sPath.lastIndexOf(47)))) continue;
                    ignorees.add('/' + path);
                    ignorees.add("/meta/" + path);
                }
            }
            return ignorees;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    @Override
    protected AJAXRequestResult perform(ConfigAJAXRequest req) throws OXException, JSONException {
        String path;
        ServerSession session = req.getSession();
        String value = req.getData().toString();
        if (value.length() > 0 && value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        if ((path = req.getRequest().getSerlvetRequestURI()).length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        SettingStorage stor = SettingStorage.getInstance(session);
        Setting setting = ConfigTree.getInstance().getSettingByPath(path);
        setting.setSingleValue(value);
        UserSettingMailStorage.getInstance().removeUserSettingMail(session.getUserId(), session.getContext());
        this.saveSettingWithSubs(stor, setting);
        return PUTAction.getJSONNullResult();
    }

    private void saveSettingWithSubs(SettingStorage storage, Setting setting) throws OXException, JSONException {
        if (setting.isLeaf()) {
            String path = setting.getPath();
            if (!this.ignorees.contains(path) && path.indexOf("/io.ox/core") < 0) {
                String value = (String)setting.getSingleValue();
                if (!Strings.isEmpty((String)value)) {
                    if ('[' == value.charAt(0)) {
                        JSONArray array = new JSONArray(value);
                        if (array.length() == 0) {
                            setting.setEmptyMultiValue();
                        } else {
                            for (int i = 0; i < array.length(); ++i) {
                                setting.addMultiValue(array.getString(i));
                            }
                        }
                        setting.setSingleValue(null);
                    } else if ('{' == value.charAt(0)) {
                        PUTAction.sanitizeJsonSetting(setting);
                    }
                }
                storage.save(setting);
            }
        } else {
            JSONObject json = new JSONObject(setting.getSingleValue().toString());
            Iterator iter = json.keys();
            StringBuilder sb = new StringBuilder(setting.getPath()).append('/');
            int reset = sb.length();
            OXException exc = null;
            while (iter.hasNext()) {
                Setting sub;
                String path;
                String key = (String)iter.next();
                if (sb.length() > reset) {
                    sb.setLength(reset);
                }
                if (this.ignorees.contains(path = sb.append(key).toString()) || path.indexOf("/io.ox/core") >= 0) continue;
                try {
                    sub = ConfigTree.getSettingByPath(setting, new String[]{key});
                }
                catch (OXException e) {
                    if (SettingExceptionCodes.UNKNOWN_PATH.equals(e) || path.indexOf("/io.ox/") >= 0) continue;
                    throw e;
                }
                sub.setSingleValue(json.getString(key));
                try {
                    this.saveSettingWithSubs(storage, sub);
                }
                catch (OXException e) {
                    exc = e;
                }
            }
            if (null != exc) {
                throw exc;
            }
        }
    }

    public static void sanitizeJsonSetting(Setting setting) {
        try {
            HtmlService htmlService;
            JSONObject jConfig = new JSONObject((String)setting.getSingleValue());
            boolean saveBack = false;
            JSONObject jMailConfig = jConfig.optJSONObject("mail");
            if (null != jMailConfig && jMailConfig.hasAndNotNull("signatures") && null != (htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class))) {
                JSONArray jSignatures = jMailConfig.getJSONArray("signatures");
                int length = jSignatures.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject jSignature = jSignatures.getJSONObject(i);
                    String content = jSignature.optString("signature_text", null);
                    if (null == content || !HTMLDetector.containsHTMLTags((String)content, (boolean)true)) continue;
                    content = htmlService.sanitize(content, null, false, null, null);
                    content = P_TAG_BODY.matcher(content).replaceAll("");
                    jSignature.put("signature_text", (Object)content);
                    saveBack = true;
                }
            }
            if (saveBack) {
                setting.setSingleValue(jConfig.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String preparePath(String path) {
        if (null == path) {
            return path;
        }
        return SLASHES.matcher(path.trim()).replaceAll("/");
    }

    private static boolean isComment(String line) {
        if (Strings.isEmpty((String)line)) {
            return true;
        }
        return COMMENT.matcher(line).find();
    }
}

