/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.container.ModifyableFileHolder;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.PreviewConst;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.InterruptibleInputStream;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.preview.ContentTypeChecker;
import com.openexchange.preview.Delegating;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.preview.RemoteInternalPreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewImageResultConverter
extends AbstractPreviewResultConverter {
    static final Logger LOG = LoggerFactory.getLogger(PreviewImageResultConverter.class);

    static PreviewDocument getPreviewDocument(IFileHolder fileHolder, InputStream stream, AJAXRequestData requestData, String previewLanguage, PreviewOutput previewOutput, ServerSession session, PreviewService previewService) throws OXException {
        try {
            DataProperties dataProperties = new DataProperties(12);
            dataProperties.put("com.openexchange.conversion.content-type", PreviewImageResultConverter.getContentType(fileHolder, previewService instanceof ContentTypeChecker ? (ContentTypeChecker)previewService : null));
            dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
            dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
            dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
            dataProperties.put("PreviewType", requestData.getModule().equals("files") ? "DetailView" : "Thumbnail");
            dataProperties.put("PreviewWidth", requestData.getParameter("width"));
            dataProperties.put("PreviewHeight", requestData.getParameter("height"));
            dataProperties.put("PreviewDelivery", requestData.getParameter("delivery"));
            dataProperties.put("PreviewScaleType", requestData.getParameter("scaleType"));
            dataProperties.put("PreviewLanguage", previewLanguage);
            return previewService.getPreviewFor((Data)new SimpleData((Object)stream, dataProperties), previewOutput, (Session)session, 1);
        }
        catch (RuntimeException rte) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)rte, new Object[]{rte.getMessage()});
        }
    }

    @Override
    public String getOutputFormat() {
        return "preview_image";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.IMAGE;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, final ServerSession session, Converter converter) throws OXException {
        try {
            AbstractPreviewResultConverter.Ref<InputStream> ref;
            Future submittedTask;
            IFileHolder fileHolder;
            InputStream stream;
            PreviewDocument previewDocument;
            String previewLanguage;
            boolean isValidEtag;
            String eTag;
            ResourceCache resourceCache;
            block33: {
                block32: {
                    String cacheKey;
                    CachedResource cachedPreview;
                    ResourceCache tmp = ResourceCaches.getResourceCache();
                    resourceCache = null == tmp ? null : (tmp.isEnabledFor(session.getContextId(), session.getUserId()) ? tmp : null);
                    eTag = result.getHeader("ETag");
                    isValidEtag = !Strings.isEmpty((String)eTag);
                    previewLanguage = this.getUserLanguage(session);
                    if (null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", requestData, true) && null != (cachedPreview = resourceCache.get(cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, requestData, previewLanguage), 0, session.getContextId()))) {
                        InputStream inputStream;
                        requestData.setFormat("file");
                        String contentType = cachedPreview.getFileType();
                        if (null == contentType) {
                            contentType = "image/jpeg";
                        }
                        if (null == (inputStream = cachedPreview.getInputStream())) {
                            ByteArrayFileHolder responseFileHolder = new ByteArrayFileHolder(cachedPreview.getBytes());
                            responseFileHolder.setContentType(contentType);
                            responseFileHolder.setName(cachedPreview.getFileName());
                            result.setResultObject(responseFileHolder, "file");
                        } else {
                            FileHolder responseFileHolder = new FileHolder(inputStream, cachedPreview.getSize(), contentType, cachedPreview.getFileName());
                            result.setResultObject(responseFileHolder, "file");
                        }
                        return;
                    }
                    previewDocument = null;
                    stream = null;
                    fileHolder = null;
                    submittedTask = null;
                    Object resultObject = result.getResultObject();
                    if (!(resultObject instanceof IFileHolder)) {
                        throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
                    }
                    fileHolder = (IFileHolder)resultObject;
                    stream = fileHolder.getStream();
                    if (0L != fileHolder.getLength()) break block32;
                    Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                    stream = null;
                    this.setDefaulThumbnail(requestData, result);
                    Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                    return;
                }
                ref = new AbstractPreviewResultConverter.Ref<InputStream>();
                if (!PreviewImageResultConverter.streamIsEof(stream, ref)) break block33;
                Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                stream = null;
                this.setDefaulThumbnail(requestData, result);
                Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                return;
            }
            try {
                stream = ref.getValue();
                PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
                String mimeType = MimeType2ExtMap.getContentType(fileHolder.getName(), null);
                if (null == mimeType) {
                    fileHolder = new ThresholdFileHolder().write(stream).setContentInfo(fileHolder);
                    mimeType = AJAXUtility.detectMimeType(fileHolder.getStream());
                }
                fileHolder = new ModifyableFileHolder(fileHolder).setContentType(mimeType);
                boolean useCurrentThread = true;
                if (previewService instanceof Delegating) {
                    long timeToWaitMillis;
                    Delegating delegating = (Delegating)previewService;
                    PreviewService candidate = delegating.getBestFitOrDelegate(mimeType, this.getOutput());
                    if (null == candidate) {
                        String name = fileHolder.getName();
                        throw PreviewExceptionCodes.NO_PREVIEW_SERVICE2.create(new Object[]{null == mimeType ? "" : mimeType, null == name ? "<unknown>" : name});
                    }
                    if (previewService instanceof RemoteInternalPreviewService && (timeToWaitMillis = ((RemoteInternalPreviewService)previewService).getTimeToWaitMillis()) > 0L) {
                        useCurrentThread = false;
                        InterruptibleInputStream iis = new InterruptibleInputStream(stream);
                        try {
                            PreviewDocumentCallable task = new PreviewDocumentCallable(fileHolder, (InputStream)iis, requestData, previewLanguage, this.getOutput(), session, previewService);
                            submittedTask = ThreadPools.getThreadPool().submit((Task)task, CallerRunsBehavior.getInstance());
                            previewDocument = (PreviewDocument)submittedTask.get(timeToWaitMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            iis.interrupt();
                            submittedTask.cancel(true);
                            throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                        }
                        catch (ExecutionException e) {
                            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
                        }
                    }
                }
                if (useCurrentThread) {
                    previewDocument = PreviewImageResultConverter.getPreviewDocument(fileHolder, stream, requestData, previewLanguage, this.getOutput(), session, previewService);
                }
            }
            catch (RuntimeException rte) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)rte, new Object[]{rte.getMessage()});
                }
                catch (Throwable throwable) {
                    Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                    throw throwable;
                }
            }
            Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
            if (null == previewDocument) {
                throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create((Throwable)new NullPointerException("previewDocument is null"), new Object[0]);
            }
            requestData.setFormat("file");
            InputStream thumbnail = previewDocument.getThumbnail();
            if (null == thumbnail) {
                throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create();
            }
            if ("com.openexchange.documentpreview.OfficePreviewDocument".equals(previewDocument.getClass().getName())) {
                requestData.putParameter("transformationNeeded", "false");
            }
            final String fileName = (String)previewDocument.getMetaData().get("resourcename");
            int size = -1;
            if (null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", requestData, true)) {
                final byte[] bytes = Streams.stream2bytes((InputStream)thumbnail);
                thumbnail = Streams.newByteArrayInputStream((byte[])bytes);
                size = bytes.length;
                final String cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, requestData, new String[0]);
                AbstractTask<Void> task = new AbstractTask<Void>(){

                    public Void call() {
                        try {
                            CachedResource preview = new CachedResource(bytes, fileName, "image/jpeg", (long)bytes.length);
                            resourceCache.save(cacheKey, preview, 0, session.getContextId());
                        }
                        catch (OXException e) {
                            LOG.warn("Could not cache preview.", (Throwable)e);
                        }
                        return null;
                    }
                };
                ThreadPoolService threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
                if (null == threadPool) {
                    Thread thread = Thread.currentThread();
                    boolean ran = false;
                    task.beforeExecute(thread);
                    try {
                        task.call();
                        ran = true;
                        task.afterExecute(null);
                    }
                    catch (Exception ex) {
                        if (!ran) {
                            task.afterExecute((Throwable)ex);
                        }
                        throw ex instanceof OXException ? (OXException)((Object)ex) : AjaxExceptionCodes.UNEXPECTED_ERROR.create(ex, ex.getMessage());
                    }
                } else {
                    threadPool.submit((Task)task);
                }
            }
            FileHolder responseFileHolder = new FileHolder(thumbnail, (long)size, "image/jpeg", fileName);
            result.setResultObject(responseFileHolder, "file");
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String getUserLanguage(ServerSession session) {
        User sessionUser = session.getUser();
        return null == sessionUser ? null : sessionUser.getPreferredLanguage();
    }

    private void setDefaulThumbnail(AJAXRequestData requestData, AJAXRequestResult result) {
        requestData.setFormat("file");
        byte[] bytes = PreviewConst.DEFAULT_THUMBNAIL;
        ByteArrayInputStream thumbnail = Streams.newByteArrayInputStream((byte[])bytes);
        requestData.putParameter("transformationNeeded", "false");
        FileHolder responseFileHolder = new FileHolder(thumbnail, (long)bytes.length, "image/jpeg", "thumbs.jpg");
        result.setResultObject(responseFileHolder, "file");
    }

    private static final class PreviewDocumentCallable
    extends AbstractTask<PreviewDocument> {
        private final AJAXRequestData requestData;
        private final IFileHolder fileHolder;
        private final String previewLanguage;
        private final PreviewOutput previewOutput;
        private final ServerSession session;
        private final InputStream stream;
        private final PreviewService previewService;

        PreviewDocumentCallable(IFileHolder fileHolder, InputStream stream, AJAXRequestData requestData, String previewLanguage, PreviewOutput previewOutput, ServerSession session, PreviewService previewService) {
            this.fileHolder = fileHolder;
            this.stream = stream;
            this.requestData = requestData;
            this.previewLanguage = previewLanguage;
            this.previewOutput = previewOutput;
            this.session = session;
            this.previewService = previewService;
        }

        public PreviewDocument call() throws OXException {
            return PreviewImageResultConverter.getPreviewDocument(this.fileHolder, this.stream, this.requestData, this.previewLanguage, this.previewOutput, this.session, this.previewService);
        }
    }
}

