/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.MimeTypes;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.preview.ContentTypeChecker;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.preview.cache.CachedPreviewDocument;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreviewResultConverter
implements ResultConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPreviewResultConverter.class);
    private static final Charset UTF8 = Charsets.UTF_8;
    private static final byte[] DELIM = new byte[]{13, 10};
    protected static final String PARAMETER_VIEW = "view";
    protected static final String PARAMETER_EDIT = "edit";
    private static final Set<String> BOOLS = new HashSet<String>(Arrays.asList("true", "yes", "y", "on", "1"));
    private static final Set<String> INVALIDS = MimeTypes.INVALIDS;
    private static final String VIEW_RAW = "raw";
    private static final String VIEW_TEXT = "text";
    private static final String VIEW_TEXT_NO_HTML_ATTACHMENT = "textNoHtmlAttach";
    private static final String VIEW_HTML = "html";
    private static final String VIEW_HTML_BLOCKED_IMAGES = "noimg";

    protected AbstractPreviewResultConverter() {
    }

    @Override
    public String getInputFormat() {
        return "file";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, final ServerSession session, Converter converter) throws OXException {
        block26: {
            fileHolder = null;
            try {
                tmp = ResourceCaches.getResourceCache();
                resourceCache = null == tmp ? null : (tmp.isEnabledFor(session.getContextId(), session.getUserId()) != false ? tmp : null);
                eTag = requestData.getETag();
                v0 = isValidEtag = Strings.isEmpty((String)eTag) == false;
                if (null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", requestData, true) && null != (cachedPreview = resourceCache.get(cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, requestData, new String[0]), 0, session.getContextId()))) {
                    in = cachedPreview.getInputStream();
                    bytes = null == in ? cachedPreview.getBytes() : Streams.stream2bytes((InputStream)in);
                    map = new HashMap<String, String>(4);
                    map.put("resourcename", cachedPreview.getFileName());
                    map.put("content-type", cachedPreview.getFileType());
                    computedFailure = this.computeFailure(AbstractPreviewResultConverter.DELIM);
                    prev = 0;
                    pos = this.indexOf(bytes, AbstractPreviewResultConverter.DELIM, prev, computedFailure);
                    if (pos >= 0) {
                        contents = new LinkedList<E>();
                        baos = new ByteArrayOutputStream(16384);
                        do {
                            baos.reset();
                            prev = pos + AbstractPreviewResultConverter.DELIM.length;
                            pos = this.indexOf(bytes, AbstractPreviewResultConverter.DELIM, prev, computedFailure);
                            if (pos >= 0) {
                                baos.write(bytes, prev, pos);
                            } else {
                                baos.write(bytes, prev, bytes.length);
                            }
                            contents.add(new String(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])baos.toByteArray()))), AbstractPreviewResultConverter.UTF8));
                        } while (pos >= 0);
                    } else {
                        contents = Collections.singletonList(new String(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])bytes))), AbstractPreviewResultConverter.UTF8));
                    }
                    result.setResultObject(new CachedPreviewDocument(contents, map), this.getOutputFormat());
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                try {
                    throw AjaxExceptionCodes.IO_ERROR.create(e, new Object[]{e.getMessage()});
                    catch (RuntimeException e) {
                        throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                    }
                }
                catch (Throwable var26_36) {
                    Streams.close(fileHolder);
                    throw var26_36;
                }
            }
            Streams.close((Closeable)fileHolder);
            return;
lbl-1000:
            // 1 sources

            {
                resultObject = result.getResultObject();
                if (!(resultObject instanceof IFileHolder)) {
                    throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(new Object[]{IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName()});
                }
                fileHolder = (IFileHolder)resultObject;
                if (0L == fileHolder.getLength()) {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(new Object[]{"File holder has not content, hence no preview can be generated."});
                }
                stream = fileHolder.getStream();
                ref = new Ref<V>();
                if (AbstractPreviewResultConverter.streamIsEof(stream, null)) {
                    Streams.close((Closeable[])new Closeable[]{stream, fileHolder});
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(new Object[]{"File holder has not content, hence no preview can be generated."});
                }
                stream = (InputStream)ref.getValue();
                previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
                dataProperties = new DataProperties(4);
                dataProperties.put("com.openexchange.conversion.content-type", AbstractPreviewResultConverter.getContentType(fileHolder, previewService instanceof ContentTypeChecker != false ? (ContentTypeChecker)previewService : null));
                dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
                dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
                dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
                pages = -1;
                if (requestData.containsParameter("pages")) {
                    pages = requestData.getIntParameter("pages");
                }
                previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)stream, dataProperties), this.getOutput(), (Session)session, pages);
                if (null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", requestData, true) && null != (content = previewDocument.getContent()) && (size = content.size()) > 0) {
                    cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, requestData, new String[0]);
                    if (1 == content.size()) {
                        bytes = Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])((String)content.get(0)).getBytes(AbstractPreviewResultConverter.UTF8))));
                    } else {
                        baos = Streams.newByteArrayOutputStream((int)16384);
                        baos.write(Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])((String)content.get(0)).getBytes(AbstractPreviewResultConverter.UTF8)))));
                        delim = AbstractPreviewResultConverter.DELIM;
                        for (i = 1; i < size; ++i) {
                            baos.write(delim);
                            baos.write(Charsets.toAsciiBytes((String)Charsets.toAsciiString((byte[])Base64.encodeBase64((byte[])((String)content.get(i)).getBytes(AbstractPreviewResultConverter.UTF8)))));
                        }
                        bytes = baos.toByteArray();
                    }
                    fileName = fileHolder.getName();
                    fileType = fileHolder.getContentType();
                    task = new AbstractTask<Void>(){

                        public Void call() {
                            try {
                                CachedResource preview = new CachedResource(bytes, fileName, fileType, (long)bytes.length);
                                resourceCache.save(cacheKey, preview, 0, session.getContextId());
                            }
                            catch (OXException e) {
                                LOG.warn("Could not cache preview.", (Throwable)e);
                            }
                            return null;
                        }
                    };
                    threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
                    if (null == threadPool) {
                        thread = Thread.currentThread();
                        ran = false;
                        task.beforeExecute(thread);
                        try {
                            task.call();
                            ran = true;
                            task.afterExecute(null);
                        }
                        catch (Exception ex) {
                            if (!ran) {
                                task.afterExecute((Throwable)ex);
                            }
                            if (ex instanceof OXException) {
                                v1 = (OXException)ex;
                                throw v1;
                            }
                            v1 = AjaxExceptionCodes.UNEXPECTED_ERROR.create(ex, new Object[]{ex.getMessage()});
                            throw v1;
                        }
                    } else {
                        threadPool.submit((Task)task);
                    }
                }
                if (requestData.getIntParameter("save") == 1) break block26;
                result.setResultObject(previewDocument, this.getOutputFormat());
            }
        }
        Streams.close((Closeable)fileHolder);
    }

    protected static boolean parseBool(String value) {
        if (null == value) {
            return false;
        }
        return BOOLS.contains(value.trim().toLowerCase(Locale.US));
    }

    protected static String getContentType(IFileHolder fileHolder, ContentTypeChecker checker) {
        String contentType = fileHolder.getContentType();
        if (Strings.isEmpty((String)contentType)) {
            return MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        contentType = AbstractPreviewResultConverter.sanitizeContentType(AbstractPreviewResultConverter.getLowerCaseBaseType(contentType));
        if (Strings.isEmpty((String)(contentType = MimeTypes.checkedMimeType(contentType, fileHolder.getName(), INVALIDS))) || INVALIDS.contains(contentType) || null != checker && !checker.isValid(contentType)) {
            contentType = MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        return contentType == null ? "application/octet-stream" : contentType;
    }

    private static String sanitizeContentType(String contentType) {
        if (null == contentType) {
            return null;
        }
        try {
            return new ContentType(contentType).getBaseType();
        }
        catch (OXException e) {
            return contentType;
        }
    }

    private static String getLowerCaseBaseType(String contentType) {
        if (null == contentType) {
            return null;
        }
        int pos = contentType.indexOf(59);
        return Strings.toLowerCase((CharSequence)(pos > 0 ? contentType.substring(0, pos) : contentType)).trim();
    }

    protected static DisplayMode detectDisplayMode(boolean modifyable, String view, UserSettingMail usm) {
        DisplayMode displayMode;
        if (null == view) {
            return modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        if (VIEW_RAW.equals(view)) {
            displayMode = DisplayMode.RAW;
        } else if (VIEW_TEXT_NO_HTML_ATTACHMENT.equals(view)) {
            usm.setDisplayHtmlInlineContent(false);
            usm.setSuppressHTMLAlternativePart(true);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_TEXT.equals(view)) {
            usm.setDisplayHtmlInlineContent(false);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_HTML.equals(view)) {
            usm.setDisplayHtmlInlineContent(true);
            usm.setAllowHTMLImages(true);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_HTML_BLOCKED_IMAGES.equals(view)) {
            usm.setDisplayHtmlInlineContent(true);
            usm.setAllowHTMLImages(false);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else {
            LOG.warn("Unknown value in parameter {}: {}. Using user's mail settings as fallback.", (Object)PARAMETER_VIEW, (Object)view);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        return displayMode;
    }

    public abstract PreviewOutput getOutput();

    private int indexOf(byte[] data, byte[] pattern, int[] computeFailure) {
        return this.indexOf(data, pattern, 0, computeFailure);
    }

    private int indexOf(byte[] data, byte[] pattern, int fromIndex, int[] computedFailure) {
        int[] failure = null == computedFailure ? this.computeFailure(pattern) : computedFailure;
        int j = 0;
        int dLen = data.length;
        if (dLen == 0) {
            return -1;
        }
        int pLen = pattern.length;
        for (int i = fromIndex; i < dLen; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pLen) continue;
            return i - pLen + 1;
        }
        return -1;
    }

    private int[] computeFailure(byte[] pattern) {
        int length = pattern.length;
        int[] failure = new int[length];
        int j = 0;
        for (int i = 1; i < length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    protected static boolean streamIsEof(InputStream in, Ref<InputStream> ref) throws IOException {
        if (null == in) {
            return true;
        }
        PushbackInputStream pin = Streams.pushbackInputStreamFor((InputStream)in);
        int read = pin.read();
        if (read < 0) {
            return true;
        }
        pin.unread(read);
        ref.setValue(pin);
        return false;
    }

    protected static final class Ref<V> {
        private V value = null;

        Ref() {
        }

        V getValue() {
            return this.value;
        }

        Ref<V> setValue(V value) {
            this.value = value;
            return this;
        }
    }
}

