/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.tools.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMailPreviewResultConverter
implements ResultConverter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMailPreviewResultConverter.class);
    protected final AbstractPreviewResultConverter resultConverter;

    protected AbstractMailPreviewResultConverter(AbstractPreviewResultConverter resultConverter) {
        this.resultConverter = resultConverter;
    }

    @Override
    public String getInputFormat() {
        return "mail";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public String getOutputFormat() {
        return this.resultConverter.getOutputFormat();
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        MailMessage mail = (MailMessage)result.getResultObject();
        ThresholdFileHolder fileHolder = new ThresholdFileHolder();
        try {
            mail.writeTo(fileHolder.asOutputStream());
        }
        catch (OXException e) {
            if (!MailExceptionCode.NO_CONTENT.equals(e)) {
                throw e;
            }
            LOG.debug("", (Throwable)e);
            fileHolder.close();
            fileHolder = new ThresholdFileHolder();
            fileHolder.write(new byte[0]);
        }
        mail.prepareForCaching();
        fileHolder.setContentType("application/octet-stream");
        fileHolder.setName(mail.getSubject() + ".eml");
        result.setResultObject(fileHolder, "file");
        result.setParameter("__mail", mail);
        this.resultConverter.convert(requestData, result, session, converter);
    }
}

