/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.BodyParser;
import com.openexchange.ajax.requesthandler.DefaultBodyParser;
import com.openexchange.ajax.requesthandler.HTTPRequestInputStreamProvider;
import com.openexchange.ajax.requesthandler.osgi.BodyParserRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.java.Strings;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AJAXRequestDataTools {
    private static final Logger LOG = LoggerFactory.getLogger(AJAXRequestDataTools.class);
    private static final String PARAMETER_ACTION = "action";
    private static final AJAXRequestDataTools INSTANCE = new AJAXRequestDataTools();
    private static final AtomicReference<BodyParserRegistry> REGISTRY = new AtomicReference();
    protected static final Pattern SPLIT_CSV = Pattern.compile("\\s*,\\s*");
    private static final Set<String> TRUE_VALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("true", "1", "yes", "y", "on")));
    private static final Set<String> FALSE_VALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("false", "0", "no", "n", "off")));

    public static AJAXRequestDataTools getInstance() {
        return INSTANCE;
    }

    public static void setBodyParserRegistry(BodyParserRegistry registry) {
        REGISTRY.set(registry);
    }

    protected AJAXRequestDataTools() {
    }

    public final AJAXRequestData parseRequest(HttpServletRequest req, boolean preferStream, boolean isFileUpload, ServerSession session, String prefix) throws IOException, OXException {
        return this.parseRequest(req, preferStream, isFileUpload, session, prefix, null);
    }

    public AJAXRequestData parseRequest(HttpServletRequest req, boolean preferStream, boolean isFileUpload, ServerSession session, String prefix, HttpServletResponse optResp) throws IOException, OXException {
        String parameter;
        AJAXRequestData retval = new AJAXRequestData().setHttpServletResponse(optResp);
        retval.setUserAgent(req.getHeader("user-agent"));
        AJAXRequestDataTools.parseHostName(retval, req, session);
        retval.setMultipart(isFileUpload);
        retval.setHttpServletRequest(req);
        retval.setModule(this.getModule(prefix, req));
        retval.setServletRequestURI(AJAXServlet.getServletSpecificURI(req));
        retval.setPathInfo(req.getPathInfo());
        retval.setAction(this.getAction(req));
        retval.setPrefix(prefix);
        retval.setFormat(req.getParameter("format"));
        Set entrySet = req.getParameterMap().entrySet();
        for (Map.Entry entry : entrySet) {
            retval.putParameter((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        String eTag = req.getHeader("If-None-Match");
        if (null != eTag) {
            retval.setETag(eTag);
            retval.setHeader("If-None-Match", eTag);
        }
        if (null != (parameter = req.getParameter("decorators"))) {
            for (String id : SPLIT_CSV.split(parameter, 0)) {
                retval.addDecoratorId(id.trim());
            }
        }
        if (preferStream || AJAXRequestDataTools.parseBoolParameter("binary", req)) {
            retval.setUploadStreamProvider(new HTTPRequestInputStreamProvider(req));
        } else {
            BodyParserRegistry registry = REGISTRY.get();
            if (null == registry) {
                DefaultBodyParser.getInstance().setBody(retval, req);
            } else {
                BodyParser bodyParser = registry.getParserFor(retval);
                if (null == bodyParser) {
                    DefaultBodyParser.getInstance().setBody(retval, req);
                } else {
                    bodyParser.setBody(retval, req);
                }
            }
        }
        return retval;
    }

    public static boolean hasBody(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContentLength() > 0 || httpServletRequest.getHeader("Transfer-Encoding") != null;
    }

    private static boolean parseBoolParameter(String name, HttpServletRequest req) {
        return AJAXRequestDataTools.parseBoolParameter(req.getParameter(name));
    }

    public static boolean parseBoolParameter(String name, AJAXRequestData requestData) {
        return AJAXRequestDataTools.parseBoolParameter(requestData.getParameter(name));
    }

    public static boolean parseBoolParameter(String name, AJAXRequestData requestData, boolean defaultValue) {
        String value = requestData.getParameter(name);
        if (null == value) {
            return defaultValue;
        }
        return TRUE_VALS.contains(AJAXRequestDataTools.toLowerCase(value.trim()));
    }

    public static boolean parseBoolParameter(String parameter) {
        return null != parameter && TRUE_VALS.contains(AJAXRequestDataTools.toLowerCase(parameter.trim()));
    }

    public static Boolean parseFalseBoolParameter(String parameter) {
        if (null == parameter) {
            return null;
        }
        return FALSE_VALS.contains(AJAXRequestDataTools.toLowerCase(parameter.trim())) ? Boolean.FALSE : null;
    }

    public static int parseIntParameter(String parameter, int defaultInt) {
        if (null == parameter) {
            return defaultInt;
        }
        try {
            return Integer.parseInt(parameter);
        }
        catch (NumberFormatException e) {
            return defaultInt;
        }
    }

    public static void parseHostName(AJAXRequestData request, HttpServletRequest req, ServerSession session) {
        request.setSecure(Tools.considerSecure(req));
        HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
        if (null == hostnameService) {
            request.setHostname(req.getServerName());
        } else {
            String hn = hostnameService.getHostname(session.getUserId(), session.getContextId());
            request.setHostname(null == hn ? req.getServerName() : hn);
        }
        request.setRemoteAddress(req.getRemoteAddr());
        request.setRoute(Tools.getRoute(req.getSession(true).getId()));
    }

    private static boolean startsWith(char startingChar, String toCheck) {
        if (null == toCheck) {
            return false;
        }
        int len = toCheck.length();
        if (len <= 0) {
            return false;
        }
        int i = 0;
        if (Strings.isWhitespace((char)toCheck.charAt(i))) {
            while (++i < len && Strings.isWhitespace((char)toCheck.charAt(i))) {
            }
        }
        if (i >= len) {
            return false;
        }
        return startingChar == toCheck.charAt(i);
    }

    public String getModule(String prefix, HttpServletRequest req) {
        int mlen;
        String module;
        String pathInfo = req.getRequestURI();
        int lastIndex = pathInfo.lastIndexOf(59);
        if (lastIndex > 0) {
            pathInfo = pathInfo.substring(0, lastIndex);
        }
        if ('/' == (module = pathInfo.substring(prefix.length())).charAt(mlen = module.length() - 1)) {
            module = module.substring(0, mlen);
        }
        return module;
    }

    public String getAction(HttpServletRequest req) {
        String action = req.getParameter(PARAMETER_ACTION);
        if (null == action) {
            return AJAXRequestDataTools.toUpperCase(req.getMethod());
        }
        return action;
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

