/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.login.AbstractLoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class RampUp
extends AbstractLoginRequestHandler
implements LoginRequestHandler {
    public RampUp(Set<LoginRampUpService> rampUp) {
        super(rampUp);
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        Session session = null;
        try {
            SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
            if (null == sessiondService) {
                resp.sendError(403);
                return;
            }
            session = sessiondService.getSession(req.getParameter("session"));
            JSONObject json = new JSONObject(8);
            this.performRampUp(req, json, ServerSessionAdapter.valueOf(session), true);
            response.setData(json);
        }
        catch (OXException e) {
            response.setException(e);
        }
        Tools.disableCaching(resp);
        resp.setStatus(200);
        resp.setContentType("text/javascript; charset=UTF-8");
        try {
            if (response.hasError()) {
                ResponseWriter.write(response, resp.getWriter(), LoginServlet.localeFrom(session));
            } else {
                ((JSONObject)response.getData()).write((Writer)resp.getWriter());
            }
        }
        catch (JSONException e) {
            LoginServlet.sendError(resp);
        }
    }
}

