/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.http.Tools;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormLogin
implements LoginRequestHandler {
    private final LoginConfiguration conf;

    public FormLogin(LoginConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doFormLogin(req, resp);
        }
        catch (OXException e) {
            String errorPage = this.conf.getErrorPageTemplate().replace("ERROR_MESSAGE", e.getMessage());
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write(errorPage);
        }
    }

    private void doFormLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        LoginRequestImpl request = LoginTools.parseLogin(req, "login", true, this.conf.getDefaultClient(), this.conf.isCookieForceHTTPS(), this.conf.isDisableTrimLogin(), !this.conf.isFormLoginWithoutAuthId());
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        LoginResult result = LoginPerformer.getInstance().doLogin(request, properties);
        Session session = result.getSession();
        User user = result.getUser();
        Tools.disableCaching(resp);
        LoginServlet.writeSecretCookie(req, resp, session, session.getHash(), req.isSecure(), req.getServerName(), this.conf);
        LoginServlet.addHeadersAndCookies(result, resp);
        resp.sendRedirect(FormLogin.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("autologin"), session, user.getPreferredLanguage(), this.conf.getUiWebPath()));
    }

    private static String generateRedirectURL(String uiWebPathParam, String shouldStore, Session session, String language, String uiWebPath) {
        String retval = uiWebPathParam;
        if (null == retval) {
            retval = uiWebPath;
        }
        retval = retval.replaceAll("[\n\r]", "");
        retval = LoginTools.addFragmentParameter(retval, "session", session.getSessionID());
        retval = LoginTools.addFragmentParameter(retval, "user", session.getLogin());
        retval = LoginTools.addFragmentParameter(retval, "user_id", Integer.toString(session.getUserId()));
        retval = LoginTools.addFragmentParameter(retval, "language", language);
        if (shouldStore != null) {
            retval = LoginTools.addFragmentParameter(retval, "store", shouldStore);
        }
        return retval;
    }
}

