/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.requesthandler.Dispatchers;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ClientWhitelist;
import com.openexchange.configuration.CookieHashSource;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.SessionSecretChecker;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.IPRange;
import com.openexchange.sessiond.impl.SubnetMask;
import com.openexchange.sessiond.impl.ThreadLocalSessionHolder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.RateLimitedException;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpStatus;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionServlet
extends AJAXServlet {
    private static final long serialVersionUID = -8308340875362868795L;
    private static final Logger LOG = LoggerFactory.getLogger(SessionServlet.class);
    public static final String SESSION_KEY = "sessionObject";
    public static final String PUBLIC_SESSION_KEY = "publicSessionObject";
    public static final String SESSION_WHITELIST_FILE = "noipcheck.cnf";
    private static final List<IPRange> RANGES = new LinkedList<IPRange>();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static volatile boolean checkIP = true;
    private static volatile ClientWhitelist clientWhitelist;
    protected static volatile CookieHashSource hashSource;
    private static volatile boolean rangesLoaded;
    private static final Lock RANGE_LOCK;
    private static volatile SubnetMask allowedSubnet;
    private static final String PARAM_ALTERNATIVE_ID;
    private static final String PUBLIC_SESSION_PREFIX;
    private static final String USER_AGENT = "user-agent";
    private static final String USM_USER_AGENT = "Open-Xchange USM HTTP Client";
    private static volatile Integer maxConcurrentRequests;
    private static final Set<String> AGENTS_WO_PUBLIC_SESSION_COOKIE;
    private static final String SECRET_PREFIX;
    private static final Set<String> MEDIA_AGENTS;

    protected SessionServlet() {
        ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != configService && INITIALIZED.compareAndSet(false, true)) {
            checkIP = Boolean.parseBoolean(configService.getProperty(ServerConfig.Property.IP_CHECK.getPropertyName()));
            hashSource = CookieHashSource.parse(configService.getProperty(ServerConfig.Property.COOKIE_HASH.getPropertyName()));
            clientWhitelist = new ClientWhitelist().add(configService.getProperty(ServerConfig.Property.IP_CHECK_WHITELIST.getPropertyName()));
            String ipMaskV4 = configService.getProperty(ServerConfig.Property.IP_MASK_V4.getPropertyName());
            String ipMaskV6 = configService.getProperty(ServerConfig.Property.IP_MASK_V6.getPropertyName());
            allowedSubnet = new SubnetMask(ipMaskV4, ipMaskV6);
            this.initRanges(configService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRanges(ConfigurationService configService) {
        if (rangesLoaded) {
            return;
        }
        if (checkIP) {
            String text = null;
            text = configService.getProperty(SESSION_WHITELIST_FILE);
            if (text == null) {
                ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                if (configurationService != null) {
                    text = configurationService.getText(SESSION_WHITELIST_FILE);
                } else {
                    return;
                }
            }
            rangesLoaded = true;
            if (text != null) {
                LOG.info("Exceptions from IP Check have been defined.");
                RANGE_LOCK.lock();
                try {
                    String[] lines;
                    RANGES.clear();
                    for (String line : lines = Strings.splitByCRLF((String)text)) {
                        if ((line = line.replaceAll("\\s", "")).equals("") || line.length() != 0 && line.charAt(0) == '#') continue;
                        RANGES.add(IPRange.parseRange(line));
                    }
                }
                finally {
                    RANGE_LOCK.unlock();
                }
            }
        } else {
            rangesLoaded = true;
        }
    }

    protected void initializeSession(HttpServletRequest req, HttpServletResponse resp) throws OXException {
        ServerSession session;
        if (null != SessionServlet.getSessionObject((ServletRequest)req, true)) {
            return;
        }
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        String sSession = req.getParameter("session");
        if (sSession != null && sSession.length() > 0) {
            String sessionId = SessionServlet.getSessionId((ServletRequest)req);
            session = this.getSession(req, sessionId, sessiondService);
            this.verifySession(req, sessiondService, sessionId, session);
            SessionServlet.rememberSession(req, session);
            SessionServlet.checkPublicSessionCookie(req, resp, session, sessiondService);
        } else {
            session = null;
        }
        this.findPublicSessionId(req, session, sessiondService, false, false);
    }

    protected void findPublicSessionId(HttpServletRequest req, ServerSession session, SessiondService sessiondService, boolean mayUseFallbackSession, boolean mayPerformPublicSessionAuth) throws OXException {
        Map<String, Cookie> cookies = Cookies.cookieMapFor(req);
        if (cookies != null) {
            Cookie cookie = cookies.get(LoginServlet.getPublicSessionCookieName(req));
            if (null != cookie) {
                this.handlePublicSessionCookie(req, session, sessiondService, cookie.getValue(), false);
            } else {
                String publicSessionId = req.getParameter("public_session");
                if (null != publicSessionId) {
                    this.handlePublicSessionCookie(req, session, sessiondService, publicSessionId, mayPerformPublicSessionAuth);
                } else if (mayUseFallbackSession && SessionServlet.isMediaPlayerAgent(req.getHeader(USER_AGENT))) {
                    for (Map.Entry<String, Cookie> entry : cookies.entrySet()) {
                        if (!entry.getKey().startsWith(PUBLIC_SESSION_PREFIX)) continue;
                        this.handlePublicSessionCookie(req, session, sessiondService, entry.getValue().getValue(), false);
                        return;
                    }
                }
            }
        }
    }

    private void handlePublicSessionCookie(HttpServletRequest req, ServerSession session, SessiondService sessiondService, String altId, boolean publicSessionAuth) throws OXException {
        if (null != altId && null != session && altId.equals(session.getParameter(PARAM_ALTERNATIVE_ID))) {
            SessionServlet.rememberPublicSession(req, session);
        } else {
            ServerSession publicSession;
            ServerSession serverSession = publicSession = null == altId ? null : ServerSessionAdapter.valueOf(sessiondService.getSessionByAlternativeId(altId));
            if (publicSession != null) {
                try {
                    if (!publicSessionAuth) {
                        SessionServlet.checkSecret(hashSource, req, publicSession, false);
                    }
                    this.verifySession(req, sessiondService, publicSession.getSessionID(), publicSession);
                    SessionServlet.rememberPublicSession(req, publicSession);
                }
                catch (OXException e) {
                    // empty catch block
                }
            }
        }
    }

    protected void verifySession(HttpServletRequest req, SessiondService sessiondService, String sessionId, ServerSession session) throws OXException {
        if (!sessionId.equals(session.getSessionID())) {
            LOG.info("Request's session identifier \"{}\" differs from the one indicated by SessionD service \"{}\".", (Object)sessionId, (Object)session.getSessionID());
            throw SessionExceptionCodes.WRONG_SESSION.create();
        }
        Context ctx = session.getContext();
        if (!ctx.isEnabled()) {
            sessiondService.removeSession(sessionId);
            LOG.info("The context {} associated with session is locked.", (Object)Integer.toString(ctx.getContextId()));
            throw SessionExceptionCodes.CONTEXT_LOCKED.create(new Object[]{Integer.toString(ctx.getContextId()), ctx.getName()});
        }
        this.checkIP(session, req.getRemoteAddr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Tools.disableCaching(resp);
        AtomicInteger counter = null;
        SessionThreadCounter threadCounter = (SessionThreadCounter)SessionThreadCounter.REFERENCE.get();
        String sessionId = null;
        ServerSession session = null;
        try {
            resp.setStatus(200);
            resp.setContentType("text/javascript; charset=UTF-8");
            this.initializeSession(req, resp);
            session = SessionServlet.getSessionObject((ServletRequest)req, true);
            if (null != session) {
                String dbSchema = (String)session.getParameter(LogProperties.Name.DATABASE_SCHEMA.getName());
                if (dbSchema == null) {
                    DatabaseService dbService = ServerServiceRegistry.getServize(DatabaseService.class, true);
                    dbSchema = dbService.getSchemaName(session.getContextId());
                    session.setParameter(LogProperties.Name.DATABASE_SCHEMA.getName(), dbSchema);
                }
                LogProperties.put((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA, (Object)dbSchema);
                int maxConcurrentRequests = SessionServlet.getMaxConcurrentRequests(session);
                if (maxConcurrentRequests > 0 && null != (counter = (AtomicInteger)session.getParameter(Session.PARAM_COUNTER)) && counter.incrementAndGet() > maxConcurrentRequests) {
                    LOG.info("User {} in context {} exceeded max. concurrent requests ({}).", new Object[]{session.getUserId(), session.getContextId(), maxConcurrentRequests});
                    throw AjaxExceptionCodes.TOO_MANY_REQUESTS.create();
                }
                ThreadLocalSessionHolder.getInstance().setSession(session);
                if (null != threadCounter) {
                    sessionId = session.getSessionID();
                    threadCounter.increment(sessionId);
                }
            }
            super.service(req, resp);
        }
        catch (RateLimitedException e) {
            resp.setContentType("text/plain; charset=UTF-8");
            resp.sendError(429, "Too Many Requests - Your request is being rate limited.");
        }
        catch (OXException e) {
            this.handleOXException(e, req, resp);
        }
        finally {
            if (null != sessionId && null != threadCounter) {
                threadCounter.decrement(sessionId);
            }
            ThreadLocalSessionHolder.getInstance().clear();
            LogProperties.removeSessionProperties();
            LogProperties.removeProperty((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA);
            if (null != counter) {
                counter.getAndDecrement();
            }
        }
    }

    protected void writeErrorAsJsCallback(OXException e, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        try {
            APIResponseRenderer.writeJsCallback(new Response().setException(e), Dispatchers.getActionFrom(httpRequest), httpRequest, httpResponse);
        }
        catch (JSONException je) {
            LOG.error("", (Throwable)e);
            try {
                httpResponse.sendError(500, "A JSON error occurred: " + e.getMessage());
            }
            catch (IOException ioe) {
                LOG.error("", (Throwable)ioe);
            }
        }
    }

    protected void handleOXException(OXException e, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handleOXException(e, 500, "An error occurred inside the server which prevented it from fulfilling the request.", req, resp);
    }

    protected void handleOXException(OXException e, int statusCode, String reasonPhrase, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (SessionExceptionCodes.getErrorPrefix().equals(e.getPrefix())) {
            LOG.debug("", (Throwable)e);
            this.handleSessiondException(e, req, resp);
            if (Dispatchers.isApiOutputExpectedFor(req)) {
                APIResponseRenderer.writeResponse(new Response().setException(e), Dispatchers.getActionFrom(req), req, resp);
            } else if (USM_USER_AGENT.equals(req.getHeader("User-Agent"))) {
                this.writeErrorAsJsCallback(e, req, resp);
            } else {
                String desc = e.getMessage();
                resp.setStatus(403);
                SessionServlet.writeErrorPage(403, desc, resp);
            }
        } else {
            e.log(LOG);
            if (Dispatchers.isApiOutputExpectedFor(req)) {
                APIResponseRenderer.writeResponse(new Response().setException(e), Dispatchers.getActionFrom(req), req, resp);
            } else if (USM_USER_AGENT.equals(req.getHeader("User-Agent"))) {
                this.writeErrorAsJsCallback(e, req, resp);
            } else {
                String desc = null == reasonPhrase ? "An error occurred inside the server which prevented it from fulfilling the request." : reasonPhrase;
                resp.setStatus(statusCode);
                SessionServlet.writeErrorPage(statusCode, desc, resp);
            }
        }
    }

    public static void writeErrorPage(int statusCode, String desc, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        resp.setHeader("Content-Disposition", "inline");
        PrintWriter writer = resp.getWriter();
        writer.write(SessionServlet.getErrorPage(statusCode, null, desc));
        writer.flush();
    }

    protected String getErrorPage(int sc) {
        return SessionServlet.getErrorPage(sc, null, null);
    }

    public static String getErrorPage(int sc, String msg, String desc) {
        String desc0;
        String msg0 = null == msg ? HttpStatus.getStatusText((int)sc) : msg;
        StringBuilder sb = new StringBuilder(512);
        String lineSep = System.getProperty("line.separator");
        sb.append("<!DOCTYPE html>").append(lineSep);
        sb.append("<html><head>").append(lineSep);
        sb.append("<title>").append(sc);
        if (null != msg0) {
            sb.append(' ').append(msg0);
        }
        sb.append("</title>").append(lineSep);
        sb.append("</head><body>").append(lineSep);
        sb.append("<h1>");
        if (null == msg0) {
            sb.append(sc);
        } else {
            sb.append(msg0);
        }
        sb.append("</h1>").append(lineSep);
        String string = desc0 = null == desc ? msg0 : desc;
        if (null != desc0) {
            sb.append("<p>").append(desc0).append("</p>").append(lineSep);
        }
        sb.append("</body></html>").append(lineSep);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getMaxConcurrentRequests(ServerSession session) {
        Integer tmp = maxConcurrentRequests;
        if (null != tmp) return tmp;
        Class<SessionServlet> clazz = SessionServlet.class;
        synchronized (SessionServlet.class) {
            tmp = maxConcurrentRequests;
            if (null != tmp) return tmp;
            tmp = maxConcurrentRequests = Integer.valueOf(SessionServlet.getMaxConcurrentRequests0(session));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tmp;
        }
    }

    private static int getMaxConcurrentRequests0(ServerSession session) {
        if (session == null) {
            return 0;
        }
        Set<String> set = session.getUser().getAttributes().get("ajax.maxCount");
        if (null == set || set.isEmpty()) {
            try {
                return ServerConfig.getInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS);
            }
            catch (OXException e) {
                return Integer.parseInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS.getDefaultValue());
            }
        }
        try {
            return Integer.parseInt(set.iterator().next());
        }
        catch (NumberFormatException e) {
            try {
                return ServerConfig.getInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS);
            }
            catch (OXException oxe) {
                return Integer.parseInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS.getDefaultValue());
            }
        }
    }

    protected void superService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    private void checkIP(Session session, String actual) throws OXException {
        SessionServlet.checkIP(checkIP, this.getRanges(), session, actual, clientWhitelist);
    }

    private List<IPRange> getRanges() {
        return RANGES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSessiondException(OXException e, HttpServletRequest req, HttpServletResponse resp) {
        if (SessionServlet.isIpCheckError(e)) {
            try {
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                String sessionId = SessionServlet.getSessionId((ServletRequest)req);
                ServerSession session = this.getSession(req, sessionId, sessiondService);
                SessionServlet.removeOXCookies(session.getHash(), req, resp);
                SessionServlet.removeJSESSIONID(req, resp);
                sessiondService.removeSession(sessionId);
            }
            catch (Exception e2) {
                LOG.error("Cookies could not be removed.", (Throwable)e2);
            }
            finally {
                LogProperties.removeSessionProperties();
            }
        }
    }

    public static boolean isIpCheckError(OXException e) {
        SessionExceptionCodes code = SessionExceptionCodes.WRONG_CLIENT_IP;
        return code.equals(e) && code.getCategory().equals(e.getCategory());
    }

    public static void checkIP(boolean doCheck, List<IPRange> ranges, Session session, String actual, ClientWhitelist whitelist) throws OXException {
        if (null == actual || !actual.equals(session.getLocalIp())) {
            if (doCheck && !SessionServlet.isWhitelistedFromIPCheck(actual, ranges) && !SessionServlet.isWhitelistedClient(session, whitelist) && !allowedSubnet.areInSameSubnet(actual, session.getLocalIp())) {
                StringBuilder sb = new StringBuilder(96);
                sb.append("Request to server denied (IP check activated) for session: ");
                sb.append(session.getSessionID());
                sb.append(". Client login IP changed from ");
                sb.append(session.getLocalIp());
                sb.append(" to ");
                sb.append(null == actual ? "<missing>" : actual);
                sb.append(" and is not covered by IP white-list or netmask.");
                LOG.info(sb.toString());
                throw SessionExceptionCodes.WRONG_CLIENT_IP.create(new Object[]{session.getLocalIp(), null == actual ? "<unknown>" : actual});
            }
            if (null != actual) {
                if (SessionServlet.isWhitelistedClient(session, whitelist)) {
                    session.setLocalIp(actual);
                } else if (!doCheck && !SessionServlet.isUsmEas(session.getClient())) {
                    session.setLocalIp(actual);
                }
            }
            if (LOG.isDebugEnabled() && !SessionServlet.isWhitelistedFromIPCheck(actual, ranges) && !SessionServlet.isWhitelistedClient(session, whitelist)) {
                LOG.debug("Session {} requests now from {} but login came from {}", new Object[]{session.getSessionID(), actual, session.getLocalIp()});
            }
        }
    }

    private static boolean isUsmEas(String clientId) {
        if (Strings.isEmpty((String)clientId)) {
            return false;
        }
        String uc = Strings.toUpperCase((CharSequence)clientId);
        return uc.startsWith("USM-EAS") || uc.startsWith("USM-JSON");
    }

    private static boolean isWhitelistedClient(Session session, ClientWhitelist whitelist) {
        if (null == whitelist || whitelist.isEmpty()) {
            return false;
        }
        return whitelist.isAllowed(session.getClient());
    }

    public static boolean isWhitelistedFromIPCheck(String actual, List<IPRange> ranges) {
        for (IPRange range : ranges) {
            if (!range.contains(actual)) continue;
            return true;
        }
        return false;
    }

    protected static String getSessionId(ServletRequest req) throws OXException {
        String retval = req.getParameter("session");
        if (null == retval) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("Parameter \"").append("session").append("\" not found");
            if (LOG.isDebugEnabled()) {
                sb.append(": ");
                Enumeration enm = req.getParameterNames();
                while (enm.hasMoreElements()) {
                    sb.append(enm.nextElement());
                    sb.append(',');
                }
                if (sb.length() > 0) {
                    sb.setCharAt(sb.length() - 1, '.');
                }
            }
            LOG.info(sb.toString());
            throw SessionExceptionCodes.SESSION_PARAMETER_MISSING.create();
        }
        return retval;
    }

    public ServerSession getSession(HttpServletRequest req, String sessionId, SessiondService sessiondService) throws OXException {
        return SessionServlet.getSession(hashSource, req, sessionId, sessiondService);
    }

    public static ServerSession getSession(CookieHashSource source, HttpServletRequest req, String sessionId, SessiondService sessiondService) throws OXException {
        return SessionServlet.getSession(source, req, sessionId, sessiondService, null);
    }

    public static ServerSession getSession(CookieHashSource source, HttpServletRequest req, String sessionId, SessiondService sessiondService, SessionSecretChecker optChecker) throws OXException {
        Session session = sessiondService.getSession(sessionId);
        if (null == session) {
            if (!"unset".equals(sessionId)) {
                LOG.info("There is no session associated with session identifier: {}", (Object)sessionId);
            }
            throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
        }
        LogProperties.putSessionProperties((Session)session);
        if (null == optChecker) {
            SessionServlet.checkSecret(source, req, session);
        } else {
            optChecker.checkSecret(session, req, source.name());
        }
        try {
            User user = UserStorage.getInstance().getUser(session.getUserId(), ContextStorage.getInstance().getContext(session.getContextId()));
            if (!user.isMailEnabled()) {
                LOG.info("User {} in context {} is not activated.", (Object)Integer.toString(user.getId()), (Object)Integer.toString(session.getContextId()));
                throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{session.getSessionID()});
            }
            return ServerSessionAdapter.valueOf(session);
        }
        catch (OXException e) {
            if (ContextExceptionCodes.NOT_FOUND.equals(e)) {
                sessiondService.removeSession(sessionId);
                LOG.info("The context associated with session \"{}\" cannot be found. Obviously an outdated session which is invalidated now.", (Object)sessionId);
                throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
            }
            if (UserExceptionCode.USER_NOT_FOUND.getPrefix().equals(e.getPrefix())) {
                int code = e.getCode();
                if (UserExceptionCode.USER_NOT_FOUND.getNumber() == code || LdapExceptionCode.USER_NOT_FOUND.getNumber() == code) {
                    sessiondService.removeSession(sessionId);
                    LOG.info("The user associated with session \"{}\" cannot be found. Obviously an outdated session which is invalidated now.", (Object)sessionId);
                    throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
                }
            }
            throw e;
        }
        catch (UndeclaredThrowableException e) {
            throw UserExceptionCode.USER_NOT_FOUND.create(e, Autoboxing.I((int)session.getUserId()), Autoboxing.I((int)session.getContextId()));
        }
    }

    public static void checkPublicSessionCookie(HttpServletRequest req, HttpServletResponse resp, Session session, SessiondService sessiondService) {
        boolean restored;
        String cookieName;
        String userAgent = HashCalculator.getUserAgent(req);
        if (AGENTS_WO_PUBLIC_SESSION_COOKIE.contains(userAgent.toLowerCase())) {
            return;
        }
        Map<String, Cookie> cookies = Cookies.cookieMapFor(req);
        if (null != cookies && null == cookies.get(cookieName = LoginServlet.getPublicSessionCookieName(req)) && (restored = LoginServlet.writePublicSessionCookie(req, resp, session, req.isSecure(), req.getServerName(), LoginServlet.getLoginConfiguration()))) {
            LOG.info("Restored public session cookie for \"{}\": {} (User-Agent: {})", new Object[]{session.getLogin(), cookieName, userAgent});
        }
    }

    public static void checkSecret(CookieHashSource source, HttpServletRequest req, Session session) throws OXException {
        SessionServlet.checkSecret(source, req, session, true);
    }

    public static void checkSecret(CookieHashSource source, HttpServletRequest req, Session session, boolean logInfo) throws OXException {
        String secret = SessionServlet.extractSecret(source, req, session.getHash(), session.getClient(), (String)session.getParameter(USER_AGENT));
        if (secret == null || !session.getSecret().equals(secret)) {
            if (logInfo && null != secret) {
                LOG.info("Session secret is different. Given secret \"{}\" differs from secret in session \"{}\".", (Object)secret, (Object)session.getSecret());
            }
            OXException oxe = SessionExceptionCodes.WRONG_SESSION_SECRET.create();
            oxe.setProperty(SessionExceptionCodes.WRONG_SESSION_SECRET.name(), null == secret ? "null" : secret);
            throw oxe;
        }
    }

    public static String extractSecret(CookieHashSource cookieHash, HttpServletRequest req, String hash, String client) {
        return SessionServlet.extractSecret(cookieHash, req, hash, client, null);
    }

    public static String extractSecret(CookieHashSource hashSource, HttpServletRequest req, String hash, String client, String originalUserAgent) {
        Map<String, Cookie> cookies = Cookies.cookieMapFor(req);
        if (null != cookies) {
            if (cookies.isEmpty()) {
                LOG.info("Empty Cookies in HTTP request. No session secret can be looked up.");
            } else {
                StringBuilder tmp = new StringBuilder(256);
                String secretPrefix = SECRET_PREFIX;
                String expectedSecretCookieName = tmp.append(secretPrefix).append(SessionServlet.getHash(hashSource, req, hash, client)).toString();
                Cookie cookie = cookies.get(expectedSecretCookieName);
                if (null != cookie) {
                    return cookie.getValue();
                }
                if (SessionServlet.isMediaPlayerAgent(req.getHeader(USER_AGENT))) {
                    tmp.setLength(0);
                    cookie = cookies.get(tmp.append(secretPrefix).append(hash).toString());
                    if (null != cookie) {
                        return cookie.getValue();
                    }
                }
                tmp.setLength(0);
                for (String cookieName : cookies.keySet()) {
                    if (!cookieName.startsWith(secretPrefix)) continue;
                    tmp.append(cookieName.substring(secretPrefix.length())).append(", ");
                }
                int hlen = tmp.length();
                if (hlen > 0) {
                    tmp.setLength(hlen - 2);
                    LOG.info("Didn't find an appropriate Cookie for expected name \"{}\" (CookieHashSource={}) which provides the session secret. Remembered hash: {}. Available hashes: {}", new Object[]{expectedSecretCookieName, hashSource.toString(), hash, tmp.toString()});
                } else {
                    LOG.info("Didn't find an appropriate Cookie for expected name \"{}\" (CookieHashSource={}) which provides the session secret. Remembered hash={}. No available hashes.", new Object[]{expectedSecretCookieName, hashSource.toString(), hash});
                }
            }
        } else {
            LOG.info("Missing Cookies in HTTP request. No session secret can be looked up.");
        }
        return null;
    }

    private static boolean isMediaPlayerAgent(String userAgent) {
        if (null == userAgent) {
            return false;
        }
        String lcua = Strings.toLowerCase((CharSequence)userAgent);
        for (String agentPrefix : MEDIA_AGENTS) {
            if (!lcua.startsWith(agentPrefix)) continue;
            return true;
        }
        return false;
    }

    public static String getHash(CookieHashSource hashSource, HttpServletRequest req, String hash, String client) {
        if (CookieHashSource.REMEMBER == hashSource) {
            return hash;
        }
        return HashCalculator.getInstance().getHash(req, client);
    }

    public static void rememberSession(HttpServletRequest req, ServerSession session) {
        req.setAttribute(SESSION_KEY, (Object)session);
        session.setParameter("JSESSIONID", req.getSession().getId());
    }

    public static void rememberPublicSession(HttpServletRequest req, ServerSession session) {
        req.setAttribute(PUBLIC_SESSION_KEY, (Object)session);
        session.setParameter("JSESSIONID", req.getSession().getId());
    }

    public static void removeOXCookies(String hash, HttpServletRequest req, HttpServletResponse resp) {
        SessionServlet.removeOXCookies(req, resp, Arrays.asList(LoginServlet.SESSION_PREFIX + hash, SECRET_PREFIX + hash, LoginServlet.getPublicSessionCookieName(req)));
    }

    public static void removeOXCookies(HttpServletRequest req, HttpServletResponse resp, List<String> cookieNames) {
        Map<String, Cookie> cookies = Cookies.cookieMapFor(req);
        if (cookies == null) {
            return;
        }
        for (String cookieName : cookieNames) {
            Cookie cookie = cookies.get(cookieName);
            if (null == cookie) continue;
            String value = cookie.getValue();
            Cookie respCookie = new Cookie(cookieName, value);
            respCookie.setPath("/");
            String domain = Cookies.getDomainValue(req.getServerName());
            if (null != domain) {
                respCookie.setDomain(domain);
                Cookie respCookie2 = new Cookie(cookieName, value);
                respCookie2.setPath("/");
                respCookie2.setMaxAge(0);
                resp.addCookie(respCookie2);
            }
            respCookie.setMaxAge(0);
            resp.addCookie(respCookie);
        }
    }

    public static void removeJSESSIONID(HttpServletRequest req, HttpServletResponse resp) {
        Map<String, Cookie> cookies = Cookies.cookieMapFor(req);
        if (cookies == null) {
            return;
        }
        String name = "JSESSIONID";
        Cookie cookie = cookies.get("JSESSIONID");
        if (null != cookie) {
            String value = cookie.getValue();
            Cookie respCookie = new Cookie("JSESSIONID", value);
            respCookie.setPath("/");
            String domain = Cookies.extractDomainValue(value);
            if (null != domain) {
                respCookie.setDomain(domain);
                Cookie respCookie2 = new Cookie("JSESSIONID", value);
                respCookie2.setPath("/");
                respCookie2.setMaxAge(0);
                resp.addCookie(respCookie2);
            }
            respCookie.setMaxAge(0);
            resp.addCookie(respCookie);
        }
    }

    protected static ServerSession getSessionObject(ServletRequest req) {
        return SessionServlet.getSessionObject(req, false);
    }

    protected static ServerSession getSessionObject(ServletRequest req, boolean mayUseFallbackSession) {
        String queryString;
        Object attribute = req.getAttribute(SESSION_KEY);
        if (attribute != null) {
            return (ServerSession)attribute;
        }
        if (mayUseFallbackSession) {
            return (ServerSession)req.getAttribute(PUBLIC_SESSION_KEY);
        }
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        LogProperties.put((LogProperties.Name)LogProperties.Name.SERVLET_SERVLET_PATH, (Object)httpRequest.getServletPath());
        String pathInfo = httpRequest.getPathInfo();
        if (null != pathInfo) {
            LogProperties.put((LogProperties.Name)LogProperties.Name.SERVLET_PATH_INFO, (Object)pathInfo);
        }
        if (null != (queryString = httpRequest.getQueryString())) {
            LogProperties.put((LogProperties.Name)LogProperties.Name.SERVLET_QUERY_STRING, (Object)queryString);
        }
        return null;
    }

    static {
        RANGE_LOCK = new ReentrantLock();
        PARAM_ALTERNATIVE_ID = Session.PARAM_ALTERNATIVE_ID;
        PUBLIC_SESSION_PREFIX = LoginServlet.PUBLIC_SESSION_PREFIX;
        AGENTS_WO_PUBLIC_SESSION_COOKIE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("open-xchange usm http client")));
        SECRET_PREFIX = LoginServlet.SECRET_PREFIX;
        MEDIA_AGENTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("applecoremedia/", "stagefright/")));
    }
}

