/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ManagedFileExceptionErrorMessage implements DisplayableOXExceptionCode
{
    FILE_NOT_FOUND("File not found: %1$s", CATEGORY_ERROR, 1, "File not found: %1$s"),
    IO_ERROR("I/O error: %1$s", CATEGORY_ERROR, 2, null),
    NOT_FOUND("No such managed file associated with ID: %1$s", CATEGORY_ERROR, 3, "No such managed file associated with ID: %1$s");

    private final Category category;
    private final int detailNumber;
    private final String message;
    private final String displayMessage;

    private ManagedFileExceptionErrorMessage(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    @Override
    public String getPrefix() {
        return "MANFILE";
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public int getNumber() {
        return this.detailNumber;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

