/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment.recurrence;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.appointment.recurrence.AbstractRecurrenceTest;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bug7915Test
extends AbstractRecurrenceTest {
    private static final Logger LOG = LoggerFactory.getLogger(Bug7915Test.class);

    public Bug7915Test(String name) {
        super(name);
        this.simpleDateFormatUTC.setTimeZone(timeZoneUTC);
    }

    public void testBug7915() throws Exception {
        Date startDate = this.simpleDateFormatUTC.parse("2007-06-01 00:00:00");
        Date endDate = this.simpleDateFormatUTC.parse("2007-06-02 00:00:00");
        Date until = this.simpleDateFormatUTC.parse("2007-06-15 00:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug7915");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setFullTime(true);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = Bug7915Test.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date exceptionStartDate = this.simpleDateFormatUTC.parse("2007-06-06 00:00:00");
        Date exceptionEndDate = this.simpleDateFormatUTC.parse("2007-06-07 00:00:00");
        Date recurrenceDatePosition = this.simpleDateFormatUTC.parse("2007-06-06 00:00:00");
        Appointment exceptionAppointmentObject = new Appointment();
        exceptionAppointmentObject.setTitle("testBug7915 - change exception (2007-06-06)");
        exceptionAppointmentObject.setStartDate(exceptionStartDate);
        exceptionAppointmentObject.setEndDate(exceptionEndDate);
        exceptionAppointmentObject.setFullTime(true);
        exceptionAppointmentObject.setRecurrenceDatePosition(recurrenceDatePosition);
        exceptionAppointmentObject.setShownAs(3);
        exceptionAppointmentObject.setParentFolderID(this.appointmentFolderId);
        exceptionAppointmentObject.setIgnoreConflicts(true);
        int exceptionObjectId = Bug7915Test.updateAppointment(this.getWebConversation(), exceptionAppointmentObject, objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = Bug7915Test.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug7915Test.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        exceptionAppointmentObject.setObjectID(exceptionObjectId);
        loadAppointment = Bug7915Test.loadAppointment(this.getWebConversation(), exceptionObjectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug7915Test.compareObject(exceptionAppointmentObject, loadAppointment);
        loadAppointment = Bug7915Test.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, Bug7915Test.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug7915Test.compareObject(appointmentObj, loadAppointment);
        loadAppointment = Bug7915Test.loadAppointment(this.getWebConversation(), exceptionObjectId, this.appointmentFolderId, Bug7915Test.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug7915Test.compareObject(exceptionAppointmentObject, loadAppointment);
        Bug7915Test.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

