/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;

public class PermissionTest
extends AppointmentTest {
    public PermissionTest(String name) {
        super(name);
    }

    public void testDummy() {
    }

    public void testInsertAppointmentInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertAppointmentInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 0, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testInsertAppointmentInPrivateFolderWithoutPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        try {
            PermissionTest.insertAppointment(this.getSecondWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testInsertAppointmentInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertAppointmentInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 0, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testInsertAppointmentInPublicFolderWithoutPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        try {
            PermissionTest.insertAppointment(this.getSecondWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateAppointmentInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertAppointmentInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testInsertAppointmentInPrivateFolderWithoutPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int appointmentObjectId = PermissionTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(appointmentObjectId);
        try {
            PermissionTest.updateAppointment(this.getSecondWebConversation(), appointmentObj, appointmentObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateAppointmentInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testUpdateAppointmentInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpdateAppointmentInPublicFolderWithoutPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int appointmentObjectId = PermissionTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(appointmentObjectId);
        try {
            PermissionTest.updateAppointment(this.getSecondWebConversation(), appointmentObj, appointmentObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDeleteAppointmentInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testDeleteAppointmentInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteAppointmentInPrivateFolderWithoutPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int appointmentObjectId = PermissionTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(appointmentObjectId);
        try {
            PermissionTest.deleteAppointment(this.getSecondWebConversation(), appointmentObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDeleteAppointmentInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testDeleteAppointmentInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteAppointmentInPublicFolderWithoutPermission");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int appointmentObjectId = PermissionTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(appointmentObjectId);
        try {
            PermissionTest.deleteAppointment(this.getSecondWebConversation(), appointmentObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

