/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import com.openexchange.webdav.xml.DataWriter;
import com.openexchange.webdav.xml.FolderWriter;
import com.openexchange.webdav.xml.GroupUserTest;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.folder.FolderTools;
import com.openexchange.webdav.xml.framework.WebDAVClient;
import com.openexchange.webdav.xml.parser.ResponseParser;
import com.openexchange.webdav.xml.request.PropFindMethod;
import com.openexchange.webdav.xml.types.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class FolderTest
extends AbstractWebdavXMLTest {
    @Deprecated
    public static final String FOLDER_URL = "/servlet/webdav.folders";
    protected int userParticipantId2 = -1;
    protected int userParticipantId3 = -1;
    protected int groupParticipantId1 = -1;
    protected String userParticipant2 = null;
    protected String userParticipant3 = null;
    protected String groupParticipant = null;

    public FolderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.userParticipant2 = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"user_participant2", (String)"");
        this.userParticipant3 = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"user_participant3", (String)"");
        this.groupParticipant = AbstractConfigWrapper.parseProperty((Properties)this.webdavProps, (String)"group_participant", (String)"");
    }

    protected static Date decrementDate(Date date) {
        return new Date(date.getTime() - 1L);
    }

    protected void compareFolder(FolderObject folderObj1, FolderObject folderObj2) throws Exception {
        FolderTest.assertEqualsAndNotNull("id is not equals", folderObj1.getObjectID(), folderObj2.getObjectID());
        FolderTest.assertEqualsAndNotNull("folder name is not equals", folderObj1.getFolderName(), folderObj2.getFolderName());
        if (folderObj1.containsType()) {
            FolderTest.assertEqualsAndNotNull("type is not equals", folderObj1.getType(), folderObj2.getType());
        }
        if (folderObj1.containsModule()) {
            FolderTest.assertEqualsAndNotNull("module name is not equals", folderObj1.getModule(), folderObj2.getModule());
        }
        FolderTest.assertEqualsAndNotNull("parent folder id is not equals", folderObj1.getParentFolderID(), folderObj2.getParentFolderID());
        if (folderObj1.containsPermissions()) {
            FolderTest.assertEqualsAndNotNull("permissions are not equals", this.permissions2String(folderObj1.getPermissionsAsArray()), this.permissions2String(folderObj2.getPermissionsAsArray()));
        }
    }

    public static FolderObject createFolderObject(int entity, String title, int module, boolean isPublic) {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName(title + System.currentTimeMillis());
        folderObj.setModule(module);
        if (isPublic) {
            folderObj.setType(2);
            folderObj.setParentFolderID(2);
        } else {
            folderObj.setType(1);
            folderObj.setParentFolderID(1);
        }
        folderObj.setPermissionsAsArray(new OCLPermission[]{FolderTest.createPermission(entity, false, 128, 128, 128, 128)});
        return folderObj;
    }

    public static OCLPermission createPermission(int entity, boolean isGroup, int fp, int orp, int owp, int odp) {
        return FolderTest.createPermission(entity, isGroup, fp, orp, owp, odp, true);
    }

    public static OCLPermission createPermission(int entity, boolean isGroup, int fp, int orp, int owp, int odp, boolean isAdmin) {
        OCLPermission oclp = new OCLPermission();
        oclp.setEntity(entity);
        oclp.setGroupPermission(isGroup);
        oclp.setFolderAdmin(isAdmin);
        oclp.setFolderPermission(fp);
        oclp.setReadObjectPermission(orp);
        oclp.setWriteObjectPermission(owp);
        oclp.setDeleteObjectPermission(odp);
        return oclp;
    }

    public static int insertFolder(WebConversation webCon, FolderObject folderObj, String host, String login, String password, String context) throws Exception, OXException {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        int objectId = 0;
        folderObj.removeObjectID();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        DataWriter.addElement((String)"title", (String)folderObj.getFolderName(), (Element)eProp);
        DataWriter.addElement((String)"folder_id", (int)folderObj.getParentFolderID(), (Element)eProp);
        FolderTest.addElementType(folderObj.getType(), eProp);
        FolderTest.addElementModule(folderObj.getModule(), eProp);
        FolderWriter.addElementPermission((List)folderObj.getPermissions(), (Element)eProp);
        Document doc = FolderTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + FOLDER_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + FolderTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        FolderTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 20);
        FolderTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        if (response[0].getStatus() != 200) {
            throw new TestException(response[0].getErrorMessage());
        }
        folderObj = (FolderObject)response[0].getDataObject();
        objectId = folderObj.getObjectID();
        FolderTest.assertTrue((String)"check objectId", (objectId > 0 ? 1 : 0) != 0);
        return objectId;
    }

    public static void updateFolder(WebConversation webCon, FolderObject folderObj, String host, String login, String password, String context) throws Exception, OXException {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        DataWriter.addElement((String)"title", (String)folderObj.getFolderName(), (Element)eProp);
        DataWriter.addElement((String)"object_id", (int)folderObj.getObjectID(), (Element)eProp);
        if (folderObj.containsParentFolderID()) {
            DataWriter.addElement((String)"folder", (int)folderObj.getParentFolderID(), (Element)eProp);
        }
        if (folderObj.containsPermissions()) {
            FolderWriter.addElementPermission((List)folderObj.getPermissions(), (Element)eProp);
        }
        Document doc = FolderTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + FOLDER_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + FolderTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        FolderTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 20);
        FolderTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            FolderTest.fail((String)("xml error: " + response[0].getErrorMessage()));
        }
        if (response[0].getStatus() != 200) {
            throw new TestException(response[0].getErrorMessage());
        }
    }

    public static int[] deleteFolder(WebConversation webCon, int[] id, String host, String login, String password, String context) throws Exception, OXException {
        return FolderTest.deleteFolder(webCon, id, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static int[] deleteFolder(WebConversation webCon, int[] id, Date lastModified, String host, String login, String password, String context) throws Exception, OXException {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element rootElement = new Element("multistatus", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int a = 0; a < id.length; ++a) {
            Element eProp = new Element("prop", webdav);
            DataWriter.addElement((String)"object_id", (int)id[a], (Element)eProp);
            DataWriter.addElement((String)"last_modified", (Date)lastModified, (Element)eProp);
            DataWriter.addElement((String)"method", (String)"DELETE", (Element)eProp);
            rootElement.addContent((Content)FolderTest.addProp2PropertyUpdate(eProp));
        }
        Document doc = new Document(rootElement);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + FOLDER_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + FolderTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        FolderTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 20);
        FolderTest.assertEquals((String)"check response", (int)id.length, (int)response.length);
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int a = 0; a < response.length; ++a) {
            if (response[a].hasError()) {
                FolderObject folderObj = (FolderObject)response[a].getDataObject();
                idList.add(folderObj.getObjectID());
            }
            if (response[0].getStatus() == 200) continue;
            throw new TestException(response[0].getErrorMessage());
        }
        int[] failed = new int[idList.size()];
        for (int a = 0; a < failed.length; ++a) {
            failed[a] = (Integer)idList.get(a);
        }
        return failed;
    }

    public static int[] clearFolder(WebConversation webCon, int[] id, String[] modules, Date lastModified, String host, String login, String password, String context) throws Exception, OXException {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element rootElement = new Element("multistatus", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int a = 0; a < id.length; ++a) {
            Element eProp = new Element("prop", webdav);
            DataWriter.addElement((String)"object_id", (int)id[a], (Element)eProp);
            DataWriter.addElement((String)"module", (String)modules[a], (Element)eProp);
            DataWriter.addElement((String)"last_modified", (Date)lastModified, (Element)eProp);
            DataWriter.addElement((String)"method", (String)"CLEAR", (Element)eProp);
            rootElement.addContent((Content)FolderTest.addProp2PropertyUpdate(eProp));
        }
        Document doc = new Document(rootElement);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + FOLDER_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + FolderTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        FolderTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 20);
        FolderTest.assertEquals((String)"check response", (int)id.length, (int)response.length);
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int a = 0; a < response.length; ++a) {
            if (response[a].hasError()) {
                FolderObject folderObj = (FolderObject)response[a].getDataObject();
                idList.add(folderObj.getObjectID());
            }
            if (response[0].getStatus() == 200) continue;
            throw new TestException(response[0].getErrorMessage());
        }
        int[] failed = new int[idList.size()];
        for (int a = 0; a < failed.length; ++a) {
            failed[a] = (Integer)idList.get(a);
        }
        return failed;
    }

    public static int[] listFolder(WebConversation webCon, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eObjectmode.addContent("LIST");
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, FolderTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + FOLDER_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        FolderTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 20, true);
        FolderTest.assertEquals((String)"response length not is 1", (int)1, (int)response.length);
        return (int[])response[0].getDataObject();
    }

    private static Credentials getCredentials(String login, String password, String context) {
        return new UsernamePasswordCredentials(context == null || context.equals("") ? login : login + "@" + context, password);
    }

    public static FolderObject[] listFolder(WebConversation webCon, Date modified, boolean changed, boolean deleted, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        if (!changed && !deleted) {
            return new FolderObject[0];
        }
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eLastSync = new Element("lastsync", XmlServlet.NS);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eLastSync.addContent(String.valueOf(modified.getTime()));
        StringBuffer objectMode = new StringBuffer();
        if (changed) {
            objectMode.append("NEW_AND_MODIFIED,");
        }
        if (deleted) {
            objectMode.append("DELETED,");
        }
        objectMode.delete(objectMode.length() - 1, objectMode.length());
        eObjectmode.addContent(objectMode.toString());
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        eProp.addContent((Content)eLastSync);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, FolderTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + FOLDER_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        FolderTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 20);
        FolderObject[] folderArray = new FolderObject[response.length];
        for (int a = 0; a < folderArray.length; ++a) {
            if (response[a].hasError()) {
                FolderTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            folderArray[a] = (FolderObject)response[a].getDataObject();
        }
        return folderArray;
    }

    public static FolderObject loadFolder(WebConversation webCon, int objectId, String host, String login, String password, String context) throws Exception, OXException {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eObjectId.addContent(String.valueOf(objectId));
        ePropfind.addContent((Content)eProp);
        eProp.addContent((Content)eObjectId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, FolderTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + FOLDER_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        FolderTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 20);
        FolderTest.assertTrue((String)"no response object found", (response.length > 0 ? 1 : 0) != 0);
        FolderObject[] folderArray = new FolderObject[response.length];
        for (int a = 0; a < folderArray.length; ++a) {
            if (response[a].hasError()) {
                throw new TestException(response[a].getErrorMessage());
            }
            folderArray[a] = (FolderObject)response[a].getDataObject();
        }
        FolderTest.assertEquals((String)"id is not equals", (int)objectId, (int)folderArray[0].getObjectID());
        return folderArray[0];
    }

    public static FolderObject getAppointmentDefaultFolder(WebConversation webCon, String host, String login, String password, String context) throws Exception {
        WebDAVClient client = new WebDAVClient(login + "@" + context, password);
        return new FolderTools(client).getDefaultAppointmentFolder(AbstractWebdavXMLTest.appendPrefix(host));
    }

    public static FolderObject getContactDefaultFolder(WebConversation webCon, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        FolderObject[] folderArray = FolderTest.listFolder(webCon, new Date(0L), true, false, host, login, password, context);
        int userId = GroupUserTest.getUserId(webCon, host, login, password, context);
        FolderTest.assertTrue((String)"user not found", (userId != -1 ? 1 : 0) != 0);
        for (int a = 0; a < folderArray.length; ++a) {
            FolderObject folderObj = folderArray[a];
            if (!folderObj.isDefaultFolder() || folderObj.getModule() != 3 || folderObj.getCreatedBy() != userId) continue;
            return folderObj;
        }
        throw OXException.general((String)"no contact default folder found!");
    }

    public static FolderObject getTaskDefaultFolder(WebConversation webCon, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        FolderObject[] folderArray = FolderTest.listFolder(webCon, new Date(0L), true, false, host, login, password, context);
        int userId = GroupUserTest.getUserId(webCon, host, login, password, context);
        FolderTest.assertTrue((String)"user not found", (userId != -1 ? 1 : 0) != 0);
        for (int a = 0; a < folderArray.length; ++a) {
            FolderObject folderObj = folderArray[a];
            if (!folderObj.isDefaultFolder() || folderObj.getModule() != 1 || folderObj.getCreatedBy() != userId) continue;
            return folderObj;
        }
        throw OXException.general((String)"no task default folder found!");
    }

    protected static void addElementType(int type, Element parent) throws Exception {
        if (type == 1) {
            DataWriter.addElement((String)"type", (String)"private", (Element)parent);
        } else {
            DataWriter.addElement((String)"type", (String)"public", (Element)parent);
        }
    }

    protected static void addElementModule(int module, Element parent) throws Exception {
        switch (module) {
            case 2: {
                DataWriter.addElement((String)"module", (String)"calendar", (Element)parent);
                break;
            }
            case 3: {
                DataWriter.addElement((String)"module", (String)"contact", (Element)parent);
                break;
            }
            case 1: {
                DataWriter.addElement((String)"module", (String)"task", (Element)parent);
                break;
            }
            default: {
                throw OXException.general((String)("invalid module: " + module));
            }
        }
    }

    private HashSet permissions2String(OCLPermission[] oclp) throws Exception {
        if (oclp == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < oclp.length; ++a) {
            hs.add(this.permission2String(oclp[a]));
        }
        return hs;
    }

    private String permission2String(OCLPermission oclp) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ENTITY" + oclp.getEntity());
        sb.append("GROUP" + oclp.isGroupPermission());
        sb.append("ADMIN" + oclp.isFolderAdmin());
        sb.append("FP" + oclp.getFolderPermission());
        sb.append("ORP" + oclp.getReadPermission());
        sb.append("OWP" + oclp.getWritePermission());
        sb.append("ODP" + oclp.getDeletePermission());
        return sb.toString();
    }
}

