/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.behaviour;

import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.behaviour.Behaviour;
import com.openexchange.webdav.action.behaviour.RequestSpecificBehaviourRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class RequestSpecificBehaviourRegistryTest
extends TestCase {
    public void testBasic() {
        RequestSpecificBehaviourRegistry registry = new RequestSpecificBehaviourRegistry();
        TestImplementation orig = new TestImplementation();
        TestBehaviour behaviour = new TestBehaviour(orig);
        registry.add((Behaviour)behaviour);
        TestInterface t = (TestInterface)registry.get((WebdavRequest)new MockWebdavRequest(null, ""), TestInterface.class);
        RequestSpecificBehaviourRegistryTest.assertTrue((t == orig ? 1 : 0) != 0);
    }

    public class TestBehaviour
    implements Behaviour {
        private final TestImplementation implementation;

        public TestBehaviour(TestImplementation implementation) {
            this.implementation = implementation;
        }

        public boolean matches(WebdavRequest req) {
            return true;
        }

        public Set<Class<? extends Object>> provides() {
            return new HashSet<Class<? extends Object>>(Arrays.asList(TestInterface.class));
        }

        public <T> T get(Class<T> clazz) {
            return (T)this.implementation;
        }
    }

    public class TestImplementation
    implements TestInterface {
    }

    public static interface TestInterface {
    }
}

