/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.ContactFinder;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.SimpleCredentials;
import com.openexchange.test.fixtures.TestUserConfigFactory;
import java.util.HashMap;
import java.util.Map;

public class CredentialFixtureFactory
implements FixtureFactory<SimpleCredentials> {
    private final TestUserConfigFactory userConfigFactory;
    private final ContactFinder contactFinder;
    private final FixtureLoader fixtureLoader;

    public CredentialFixtureFactory(TestUserConfigFactory userConfigFactory, ContactFinder contactFinder, FixtureLoader fixtureLoader) {
        this.userConfigFactory = userConfigFactory;
        this.contactFinder = contactFinder;
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<SimpleCredentials> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new CredentialFixtures(fixtureName, entries, this.userConfigFactory, this.contactFinder, this.fixtureLoader);
    }

    private class CredentialFixtures
    extends DefaultFixtures<SimpleCredentials>
    implements Fixtures<SimpleCredentials> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<SimpleCredentials>> credentialMap;
        private final TestUserConfigFactory userConfigFactory;
        private final ContactFinder contactFinder;

        public CredentialFixtures(String fixtureName, Map<String, Map<String, String>> values, TestUserConfigFactory userConfigFactory, ContactFinder contactFinder, FixtureLoader fixtureLoader) {
            super(SimpleCredentials.class, values, fixtureLoader);
            this.credentialMap = new HashMap<String, Fixture<SimpleCredentials>>();
            this.entries = values;
            this.userConfigFactory = userConfigFactory;
            this.contactFinder = contactFinder;
        }

        @Override
        public Fixture<SimpleCredentials> getEntry(String entryName) throws OXException {
            if (this.credentialMap.containsKey(entryName)) {
                return this.credentialMap.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            SimpleCredentials credentials = new SimpleCredentials(this.userConfigFactory, this.contactFinder);
            this.apply(credentials, values);
            Fixture<SimpleCredentials> fixture = new Fixture<SimpleCredentials>(credentials, values.keySet().toArray(new String[values.size()]), values);
            this.credentialMap.put(entryName, fixture);
            return fixture;
        }
    }
}

