/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.zip.CRC32;
import org.junit.Assert;

public class OXTestToolkit {
    public static void assertEqualsAndNotNull(String message, Date expect, Date value) throws Exception {
        if (expect != null) {
            junit.framework.Assert.assertNotNull((String)(message + " is null"), (Object)value);
            junit.framework.Assert.assertEquals((String)message, (Object)expect, (Object)value);
        }
    }

    public static void assertEqualsAndNotNull(String message, byte[] expect, byte[] value) throws Exception {
        if (expect != null) {
            junit.framework.Assert.assertNotNull((String)(message + " is null"), (Object)value);
            junit.framework.Assert.assertEquals((String)(message + " byte array size is not equals"), (int)expect.length, (int)value.length);
            for (int a = 0; a < expect.length; ++a) {
                junit.framework.Assert.assertEquals((String)(message + " byte in pos (" + a + ") is not equals"), (byte)expect[a], (byte)value[a]);
            }
        }
    }

    public static void assertImageBytesEqualsAndNotNull(String message, byte[] expect, byte[] value) throws Exception {
        if (expect != null) {
            junit.framework.Assert.assertNotNull((String)(message + " is null"), (Object)value);
            junit.framework.Assert.assertTrue((String)(message + " byte array size is not equals"), (expect.length <= value.length ? 1 : 0) != 0);
        }
    }

    public static void assertEqualsAndNotNull(String message, Object expect, Object value) throws Exception {
        if (expect != null) {
            junit.framework.Assert.assertNotNull((String)(message + " is null"), (Object)value);
            junit.framework.Assert.assertEquals((String)message, (Object)expect, (Object)value);
        }
    }

    public static void assertSameContent(InputStream is1, InputStream is2) throws IOException {
        OXTestToolkit.assertSameContent("", is1, is2);
    }

    public static void assertSameContent(String message, InputStream is1, InputStream is2) throws IOException {
        int i = 0;
        while ((i = is1.read()) != -1) {
            junit.framework.Assert.assertEquals((String)message, (int)i, (int)is2.read());
        }
        junit.framework.Assert.assertEquals((String)message, (int)-1, (int)is2.read());
    }

    public void assertSameDay(String message, Date date1, Date date2) {
        GregorianCalendar c1 = new GregorianCalendar();
        GregorianCalendar c2 = new GregorianCalendar();
        c1.setTime(date1);
        c2.setTime(date2);
        ((Calendar)c1).setTimeZone(TimeZone.getTimeZone("UTC"));
        ((Calendar)c2).setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((String)(message + " (Day of the year)"), (Object)Autoboxing.I((int)c1.get(6)), (Object)Autoboxing.I((int)c2.get(6)));
        Assert.assertEquals((String)(message + " (Year)"), (Object)Autoboxing.I((int)c1.get(1)), (Object)Autoboxing.I((int)c2.get(1)));
    }

    public static void assertSameStream(InputStream expected, InputStream actual) {
        OXTestToolkit.assertSameStream("", expected, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSameStream(String message, InputStream expected, InputStream actual) {
        if (message == null || message.equals("")) {
            message = "Comparing InputStreams";
        }
        byte[] buff = new byte[256];
        byte[] buff2 = new byte[256];
        CRC32 crcActual = new CRC32();
        CRC32 crcExpected = new CRC32();
        try {
            while (expected.read(buff) > 0) {
                try {
                    actual.read(buff2);
                }
                catch (IOException e) {
                    Assert.fail((String)(message + ": 'actual' stream was shorter than 'expected' stream."));
                }
                crcActual.update(buff);
                crcExpected.update(buff2);
            }
            Assert.assertEquals((String)(message + ":'actual' stream was longer than 'expected' stream."), (long)-1L, (long)actual.read(buff2));
        }
        catch (IOException e) {
            Assert.fail((String)(message + ": Could not read from 'expected' stream."));
        }
        finally {
            try {
                actual.close();
            }
            catch (IOException e) {}
            try {
                expected.close();
            }
            catch (IOException e) {}
        }
        Assert.assertEquals((String)(message + ": Both streams should have the same checksum"), (long)crcExpected.getValue(), (long)crcActual.getValue());
    }

    public static String readStreamAsString(InputStream is) throws IOException {
        int len;
        byte[] buffer = new byte[65535];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
        }
        is.close();
        buffer = baos.toByteArray();
        baos.close();
        return new String(buffer, Charsets.UTF_8);
    }
}

