/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.imap.dataobjects.IMAPMailFolder;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.io.IOException;
import javax.mail.MessagingException;

public final class MailIDTest
extends AbstractMailTest {
    private static final String INBOX = "INBOX";
    private static final String TEMP_FOLDER = "TempFolder";

    public MailIDTest() {
    }

    public MailIDTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailID() throws OXException, MessagingException, IOException {
        SessionObject session = this.getSession();
        MailMessage[] mails = MailIDTest.getMessages(this.getTestMailDir(), -1);
        MailAccess mailAccess = MailAccess.getInstance((Session)session);
        mailAccess.connect();
        try {
            String fullname = null;
            String parentFullname = null;
            MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
            if (inbox.isHoldsFolders()) {
                fullname = inbox.getFullname() + inbox.getSeparator() + TEMP_FOLDER;
                parentFullname = INBOX;
            } else {
                fullname = TEMP_FOLDER;
                parentFullname = "default";
            }
            MailFolderDescription mfd = new MailFolderDescription();
            mfd.setExists(false);
            mfd.setParentFullname(parentFullname);
            mfd.setSeparator(inbox.getSeparator());
            mfd.setSubscribed(false);
            mfd.setName(TEMP_FOLDER);
            MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
            p.setEntity(this.getUser());
            p.setAllPermission(128, 128, 128, 128);
            p.setFolderAdmin(true);
            p.setGroupPermission(false);
            mfd.addPermission(p);
            mailAccess.getFolderStorage().createFolder(mfd);
            try {
                boolean found = false;
                MailFolder[] folders = mailAccess.getFolderStorage().getSubfolders(parentFullname, true);
                for (int i = 0; i < folders.length; ++i) {
                    MailFolder mf = folders[i];
                    MailIDTest.assertTrue((String)"Missing default folder flag", (boolean)mf.containsDefaultFolder());
                    MailIDTest.assertTrue((String)"Missing deleted count", (boolean)mf.containsDeletedMessageCount());
                    MailIDTest.assertTrue((String)"Missing exists flag", (boolean)mf.containsExists());
                    MailIDTest.assertTrue((String)"Missing fullname", (boolean)mf.containsFullname());
                    MailIDTest.assertTrue((String)"Missing holds folders flag", (boolean)mf.containsHoldsFolders());
                    MailIDTest.assertTrue((String)"Missing holds messages flag", (boolean)mf.containsHoldsMessages());
                    MailIDTest.assertTrue((String)"Missing message count", (boolean)mf.containsMessageCount());
                    MailIDTest.assertTrue((String)"Missing name", (boolean)mf.containsName());
                    MailIDTest.assertTrue((String)"Missing new message count", (boolean)mf.containsNewMessageCount());
                    if (mf instanceof IMAPMailFolder) {
                        MailIDTest.assertTrue((String)"Missing non-existent flag", (boolean)((IMAPMailFolder)mf).containsNonExistent());
                    }
                    MailIDTest.assertTrue((String)"Missing own permission", (boolean)mf.containsOwnPermission());
                    MailIDTest.assertTrue((String)"Missing parent fullname", (boolean)mf.containsParentFullname());
                    MailIDTest.assertTrue((String)"Missing permissions", (boolean)mf.containsPermissions());
                    MailIDTest.assertTrue((String)"Missing root folder flag", (boolean)mf.containsRootFolder());
                    MailIDTest.assertTrue((String)"Missing separator flag", (boolean)mf.containsSeparator());
                    MailIDTest.assertTrue((String)"Missing subfolder flag", (boolean)mf.containsSubfolders());
                    MailIDTest.assertTrue((String)"Missing subscribed flag", (boolean)mf.containsSubscribed());
                    MailIDTest.assertTrue((String)"Missing subscribed subfolders flag", (boolean)mf.containsSubscribedSubfolders());
                    MailIDTest.assertTrue((String)"Missing supports user flags flag", (boolean)mf.containsSupportsUserFlags());
                    MailIDTest.assertTrue((String)"Missing unread message count", (boolean)mf.containsUnreadMessageCount());
                    if (!fullname.equals(mf.getFullname())) continue;
                    found = true;
                    MailIDTest.assertFalse((String)"Subscribed, but shouldn't be", (boolean)(MailProperties.getInstance().isSupportSubscription() ? mf.isSubscribed() : false));
                }
                MailIDTest.assertTrue((String)"Newly created subfolder not found!", (boolean)found);
                String[] uids = mailAccess.getMessageStorage().appendMessages(fullname, mails);
                try {
                    for (int i = 0; i < uids.length; ++i) {
                        for (int j = 0; j < uids.length; ++j) {
                            if (j == i) continue;
                            MailIDTest.assertTrue((String)("ID of appended mail #" + (i + 1) + " is equal to ID of appended mail #" + (j + 1)), (uids[i] != uids[j] ? 1 : 0) != 0);
                        }
                    }
                }
                finally {
                    mailAccess.getMessageStorage().deleteMessages(fullname, uids, true);
                }
                String[] uids2 = mailAccess.getMessageStorage().appendMessages(fullname, mails);
                try {
                    int j;
                    int i;
                    for (i = 0; i < uids2.length; ++i) {
                        for (j = 0; j < uids2.length; ++j) {
                            if (j == i) continue;
                            MailIDTest.assertTrue((String)("ID of appended mail #" + (i + 1) + " is equal to ID of appended mail #" + (j + 1)), (uids2[i] != uids2[j] ? 1 : 0) != 0);
                        }
                    }
                    for (i = 0; i < uids.length; ++i) {
                        for (j = 0; j < uids2.length; ++j) {
                            MailIDTest.assertTrue((String)("An ID occured twice in folder" + fullname), (uids[i] != uids2[j] ? 1 : 0) != 0);
                        }
                    }
                }
                finally {
                    mailAccess.getMessageStorage().deleteMessages(fullname, uids2, true);
                }
            }
            finally {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
            }
        }
        finally {
            mailAccess.close(false);
        }
    }
}

