/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.util.Date;

public class Bug12489Test
extends CalendarSqlTest {
    public void testTitleUpdateOfRecAppWithException() throws Exception {
        String oldTitle = "testTitleUpdateOfRecAppWithException";
        CalendarDataObject master = this.appointments.buildBasicAppointment(new Date(1226044800000L), new Date(1226048400000L));
        master.setTitle("testTitleUpdateOfRecAppWithException");
        master.setRecurrenceType(3);
        master.setInterval(1);
        master.setDays(32);
        master.setDayInMonth(1);
        master.setOccurrence(10);
        this.appointments.save(master);
        this.clean.add(master);
        CalendarDataObject tmp = this.appointments.reload(master);
        Date masterStart = tmp.getStartDate();
        Date masterEnd = tmp.getEndDate();
        CalendarDataObject exception = this.appointments.createIdentifyingCopy(master);
        exception.setRecurrencePosition(1);
        exception.setStartDate(new Date(1226052000000L));
        exception.setEndDate(new Date(1226052000000L));
        exception.setIgnoreConflicts(true);
        this.appointments.save(exception);
        this.clean.add(exception);
        String newTitle = "testTitleUpdateOfRecAppWithException RENAMED";
        CalendarDataObject updateMaster = this.appointments.createIdentifyingCopy(master);
        updateMaster.setTitle("testTitleUpdateOfRecAppWithException RENAMED");
        this.appointments.save(updateMaster);
        CalendarDataObject reloadedMaster = this.appointments.reload(updateMaster);
        Bug12489Test.assertEquals((String)"Master's start date changed although only its title was updated", (Object)masterStart, (Object)reloadedMaster.getStartDate());
        Bug12489Test.assertEquals((String)"Master's end date changed although only its title was updated", (Object)masterEnd, (Object)reloadedMaster.getEndDate());
        Bug12489Test.assertEquals((String)"Master's title did not change", (String)"testTitleUpdateOfRecAppWithException RENAMED", (String)reloadedMaster.getTitle());
        CalendarDataObject reloadedException = this.appointments.reload(exception);
        Bug12489Test.assertEquals((String)"Change-exception's title changed", (String)"testTitleUpdateOfRecAppWithException", (String)reloadedException.getTitle());
        Bug12489Test.assertEquals((String)"Change-exception's start changed", (Object)new Date(1226052000000L), (Object)reloadedException.getStartDate());
        Bug12489Test.assertEquals((String)"Change-exception's end changed", (Object)new Date(1226052000000L), (Object)reloadedException.getEndDate());
    }
}

