/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class UpdateTest
extends CardDAVTest {
    public UpdateTest(String name) {
        super(name);
    }

    public void testUpdateSimpleOnClient() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = UpdateTest.randomUID();
        String firstName = "test";
        String lastName = "horst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "ORG:test3;" + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:test@example.com" + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:346346" + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        UpdateTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        UpdateTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        UpdateTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        UpdateTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getFN());
        String updatedFirstName = "test2";
        String udpatedLastName = "horst2";
        card.getVCard().getN().setFamilyName(udpatedLastName);
        card.getVCard().getN().setGivenName(updatedFirstName);
        card.getVCard().getFN().setFormattedName(updatedFirstName + " " + udpatedLastName);
        UpdateTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(card.getUID(), card.toString(), card.getETag()));
        Contact updatedContact = super.getContact(uid);
        super.rememberForCleanUp(updatedContact);
        UpdateTest.assertEquals((String)"uid wrong", (String)uid, (String)updatedContact.getUid());
        UpdateTest.assertEquals((String)"firstname wrong", (String)updatedFirstName, (String)updatedContact.getGivenName());
        UpdateTest.assertEquals((String)"lastname wrong", (String)udpatedLastName, (String)updatedContact.getSurName());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)updatedFirstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)udpatedLastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(updatedFirstName + " " + udpatedLastName), (String)card.getFN());
    }

    public void testUpdateSimpleOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = UpdateTest.randomUID();
        String firstName = "test";
        String lastName = "waldemar";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getFN());
        String updatedFirstName = "test2";
        String udpatedLastName = "waldemar2";
        contact.setSurName(udpatedLastName);
        contact.setGivenName(updatedFirstName);
        contact.setDisplayName(updatedFirstName + " " + udpatedLastName);
        contact = super.update(contact);
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)updatedFirstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)udpatedLastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(updatedFirstName + " " + udpatedLastName), (String)card.getFN());
    }

    public void testUpdateWithQuotedETag() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = UpdateTest.randomUID();
        String firstName = "otto";
        String lastName = "horst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "ORG:test3;" + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:test@example.com" + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:346346" + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        UpdateTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        UpdateTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        UpdateTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        UpdateTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getFN());
        String updatedFirstName = "otto2";
        String udpatedLastName = "horst2";
        card.getVCard().getN().setFamilyName(udpatedLastName);
        card.getVCard().getN().setGivenName(updatedFirstName);
        card.getVCard().getFN().setFormattedName(updatedFirstName + " " + udpatedLastName);
        UpdateTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(card.getUID(), card.toString(), "\"" + card.getETag() + "\""));
        Contact updatedContact = super.getContact(uid);
        super.rememberForCleanUp(updatedContact);
        UpdateTest.assertEquals((String)"uid wrong", (String)uid, (String)updatedContact.getUid());
        UpdateTest.assertEquals((String)"firstname wrong", (String)updatedFirstName, (String)updatedContact.getGivenName());
        UpdateTest.assertEquals((String)"lastname wrong", (String)udpatedLastName, (String)updatedContact.getSurName());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)updatedFirstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)udpatedLastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(updatedFirstName + " " + udpatedLastName), (String)card.getFN());
    }

    public void testUpdateWithDifferentFilename() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = UpdateTest.randomUID();
        String filename = UpdateTest.randomUID();
        String firstName = "test";
        String lastName = "horst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "ORG:test3;" + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:test@example.com" + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:346346" + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        UpdateTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(filename, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        UpdateTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        UpdateTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        UpdateTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getFN());
        String updatedFirstName = "test2";
        String udpatedLastName = "horst2";
        card.getVCard().getN().setFamilyName(udpatedLastName);
        card.getVCard().getN().setGivenName(updatedFirstName);
        card.getVCard().getFN().setFormattedName(updatedFirstName + " " + udpatedLastName);
        UpdateTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCardUpdate(filename, card.toString(), card.getETag()));
        Contact updatedContact = super.getContact(uid);
        super.rememberForCleanUp(updatedContact);
        UpdateTest.assertEquals((String)"uid wrong", (String)uid, (String)updatedContact.getUid());
        UpdateTest.assertEquals((String)"firstname wrong", (String)updatedFirstName, (String)updatedContact.getGivenName());
        UpdateTest.assertEquals((String)"lastname wrong", (String)udpatedLastName, (String)updatedContact.getSurName());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        UpdateTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        card = UpdateTest.assertContains(uid, addressData);
        UpdateTest.assertEquals((String)"N wrong", (String)updatedFirstName, (String)card.getGivenName());
        UpdateTest.assertEquals((String)"N wrong", (String)udpatedLastName, (String)card.getFamilyName());
        UpdateTest.assertEquals((String)"FN wrong", (String)(updatedFirstName + " " + udpatedLastName), (String)card.getFN());
    }
}

