/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.ICalUtils;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Bug22395Test
extends CalDAVTest {
    public Bug22395Test(String name) {
        super(name);
    }

    public void testDateOfChangeExceptions() throws Exception {
        Date expectedEnd;
        Date expectedStart;
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("Tomorrow at midnight", TimeZone.getTimeZone("Europe/Berlin")));
        for (int i = 0; i < 24; ++i) {
            Appointment appointment = new Appointment();
            appointment.setUid(Bug22395Test.randomUID());
            appointment.setTitle("Series " + i);
            appointment.setIgnoreConflicts(true);
            appointment.setStartDate(calendar.getTime());
            calendar.add(11, 1);
            appointment.setEndDate(calendar.getTime());
            appointment.setRecurrenceType(1);
            appointment.setInterval(1);
            super.create(appointment);
            appointments.add(appointment);
        }
        Date clientLastModified = this.getManager().getLastModification();
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug22395Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            ICalResource iCalResource = Bug22395Test.assertContains(appointment.getUid(), calendarData);
            Bug22395Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Bug22395Test.assertEquals((String)"SUMMARY wrong", (String)appointment.getTitle(), (String)iCalResource.getVEvent().getSummary());
            Bug22395Test.assertEquals((String)"DTSTART wrong", (Object)appointment.getStartDate(), (Object)iCalResource.getVEvent().getDTStart());
            Bug22395Test.assertEquals((String)"DTEND wrong", (Object)appointment.getEndDate(), (Object)iCalResource.getVEvent().getDTEnd());
        }
        for (ICalResource iCalResource : calendarData) {
            SimpleICal.Component exception = new SimpleICal.Component("VEVENT");
            exception.setProperty("CREATED", Bug22395Test.formatAsUTC(new Date()));
            exception.setProperty("UID", iCalResource.getVEvent().getUID());
            String tzID = iCalResource.getVEvent().getProperty("DTSTART").getAttribute("TZID");
            calendar.setTime(iCalResource.getVEvent().getDTStart());
            calendar.add(6, 2);
            Date exceptionStart = calendar.getTime();
            HashMap<String, String> tzIDAttributes = new HashMap<String, String>();
            tzIDAttributes.put("TZID", tzID);
            exception.setProperty("DTSTART", ICalUtils.format(exceptionStart, tzID), tzIDAttributes);
            calendar.setTime(iCalResource.getVEvent().getDTEnd());
            calendar.add(6, 2);
            Date exceptionEnd = calendar.getTime();
            exception.setProperty("DTEND", ICalUtils.format(exceptionEnd, tzID), tzIDAttributes);
            exception.setProperty("TRANSP", "OPAQUE");
            exception.setProperty("SUMMARY", iCalResource.getVEvent().getPropertyValue("SUMMARY") + "_edit");
            exception.setProperty("DTSTAMP", Bug22395Test.formatAsUTC(new Date()));
            exception.setProperty("SEQUENCE", "3");
            exception.setProperty("RECURRENCE-ID", ICalUtils.format(exceptionStart, tzID), tzIDAttributes);
            iCalResource.addComponent(exception);
            Bug22395Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        }
        List<Appointment> updates = super.getManager().updates(Bug22395Test.parse(this.getDefaultFolderID()), clientLastModified, false);
        Bug22395Test.assertNotNull((String)"no updates found on server", updates);
        Bug22395Test.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        for (Appointment appointment : appointments) {
            calendar.setTime(appointment.getStartDate());
            calendar.add(6, 2);
            expectedStart = calendar.getTime();
            calendar.setTime(appointment.getEndDate());
            calendar.add(6, 2);
            expectedEnd = calendar.getTime();
            Appointment exception = null;
            for (Appointment update : updates) {
                if (appointment.getObjectID() == update.getObjectID() || !appointment.getUid().equals(update.getUid())) continue;
                exception = update;
                break;
            }
            Bug22395Test.assertNotNull((String)"Exception not found", exception);
            Bug22395Test.assertEquals((String)"Title wrong", (String)(appointment.getTitle() + "_edit"), (String)exception.getTitle());
            Bug22395Test.assertEquals((String)"Start date wrong", (Object)expectedStart, (Object)exception.getStartDate());
            Bug22395Test.assertEquals((String)"End date wrong", (Object)expectedEnd, (Object)exception.getEndDate());
            Bug22395Test.assertEquals((String)"Recurrence date position wrong", (int)3, (int)exception.getRecurrencePosition());
        }
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug22395Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        calendarData = super.calendarMultiget(eTags.keySet());
        for (Appointment appointment : appointments) {
            calendar.setTime(appointment.getStartDate());
            calendar.add(6, 2);
            expectedStart = calendar.getTime();
            calendar.setTime(appointment.getEndDate());
            calendar.add(6, 2);
            expectedEnd = calendar.getTime();
            ICalResource iCalResource = Bug22395Test.assertContains(appointment.getUid(), calendarData);
            Bug22395Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
            Bug22395Test.assertEquals((String)"No exception found in iCal", (int)2, (int)iCalResource.getVEvents().size());
            for (SimpleICal.Component vEvent : iCalResource.getVEvents()) {
                Date recurrenceID = vEvent.getRecurrenceID();
                if (null != recurrenceID) {
                    Bug22395Test.assertEquals((String)"SUMMARY wrong", (String)(appointment.getTitle() + "_edit"), (String)vEvent.getSummary());
                    Bug22395Test.assertEquals((String)"DTSTART wrong", (Object)expectedStart, (Object)vEvent.getDTStart());
                    Bug22395Test.assertEquals((String)"DTEND wrong", (Object)expectedEnd, (Object)vEvent.getDTEnd());
                    Bug22395Test.assertEquals((String)"RECURRENCE-ID wrong", (Object)expectedStart, (Object)recurrenceID);
                    continue;
                }
                Bug22395Test.assertEquals((String)"SUMMARY wrong", (String)appointment.getTitle(), (String)vEvent.getSummary());
                Bug22395Test.assertEquals((String)"DTSTART wrong", (Object)appointment.getStartDate(), (Object)vEvent.getDTStart());
                Bug22395Test.assertEquals((String)"DTEND wrong", (Object)appointment.getEndDate(), (Object)vEvent.getDTEnd());
            }
        }
    }
}

