/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class Bug28089Test
extends AbstractTaskTest {
    private AJAXClient client1;
    private TimeZone tz;
    private Task task;
    private FolderObject folder;

    public Bug28089Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        this.tz = this.getTimeZone();
        this.folder = Create.setupPublicFolder("Folder for test for bug 28089", 1, this.client1.getValues().getUserId());
        this.folder.setParentFolderID(2);
        CommonInsertResponse response = this.client1.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.folder));
        this.folder.setObjectID(response.getId());
        this.folder.setLastModified(response.getTimestamp());
        this.task = com.openexchange.groupware.tasks.Create.createWithDefaults(this.folder.getObjectID(), "Task to test for bug 28089");
        this.task.setAlarm(new Date());
        this.client1.execute(new InsertRequest(this.task, this.tz)).fillTask(this.task);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        GetResponse response = this.client1.execute(new GetRequest((API)EnumAPI.OX_OLD, this.folder.getObjectID(), false));
        if (!response.hasError()) {
            this.client1.execute(new DeleteRequest(this.task));
            this.folder.setLastModified(response.getTimestamp());
            this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        }
        super.tearDown();
    }

    @Test
    public void testForBug() throws OXException, IOException, JSONException {
        String message;
        CommonDeleteResponse response = this.client1.execute(new com.openexchange.ajax.folder.actions.DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        List warnings = response.getResponse().getWarnings();
        try {
            message = ((OXException)((Object)warnings.get(0))).getMessage();
        }
        catch (IndexOutOfBoundsException e) {
            message = "Response contains warnings.";
        }
        Assert.assertTrue((String)message, (boolean)warnings.isEmpty());
    }
}

