/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.subscribe.actions.AbstractSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.UpdateSubscriptionResponse;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.json.SubscriptionJSONWriter;
import org.json.JSONException;

public class UpdateSubscriptionRequest
extends AbstractSubscriptionRequest<UpdateSubscriptionResponse> {
    private DynamicFormDescription formDescription;
    private Subscription subscription;

    public void setFormDescription(DynamicFormDescription formDescription) {
        this.formDescription = formDescription;
    }

    public DynamicFormDescription getFormDescription() {
        return this.formDescription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public UpdateSubscriptionRequest() {
    }

    public UpdateSubscriptionRequest(Subscription subscription, DynamicFormDescription formDescription) {
        this();
        this.setFormDescription(formDescription);
        this.setSubscription(subscription);
    }

    @Override
    public Object getBody() throws JSONException {
        SubscriptionJSONWriter writer = new SubscriptionJSONWriter();
        try {
            return writer.write(this.subscription, this.getFormDescription(), null, null);
        }
        catch (OXException e) {
            throw new JSONException((Throwable)e);
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new Params("action", "update").toArray();
    }

    @Override
    public AbstractAJAXParser<UpdateSubscriptionResponse> getParser() {
        return new AbstractAJAXParser<UpdateSubscriptionResponse>(this.getFailOnError()){

            @Override
            protected UpdateSubscriptionResponse createResponse(Response response) throws JSONException {
                return new UpdateSubscriptionResponse(response);
            }
        };
    }
}

