/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.reminder.ReminderTest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.reminder.ReminderObject;
import java.util.Calendar;
import java.util.TimeZone;

public class DeleteTest
extends ReminderTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testDelete() throws Exception {
        TimeZone timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
        Calendar c = TimeTools.createCalendar(timeZone);
        FolderObject folderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        int folderId = folderObj.getObjectID();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDelete");
        appointmentObj.setStartDate(c.getTime());
        c.add(10, 1);
        appointmentObj.setEndDate(c.getTime());
        appointmentObj.setShownAs(3);
        appointmentObj.setAlarm(45);
        appointmentObj.setParentFolderID(folderId);
        appointmentObj.setIgnoreConflicts(true);
        int targetId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, timeZone, this.getHostName(), this.getSessionId());
        ReminderObject[] reminderObj = DeleteTest.listReminder(this.getWebConversation(), c.getTime(), timeZone, this.getHostName(), this.getSessionId());
        int pos = -1;
        for (int a = 0; a < reminderObj.length; ++a) {
            if (reminderObj[a].getTargetId() != targetId) continue;
            pos = a;
        }
        DeleteTest.assertNotSame((String)"Reminder not found.", (Object)-1, (Object)pos);
        DeleteTest.deleteReminder(this.getWebConversation(), reminderObj[pos].getObjectId(), this.getHostName(), this.getSessionId());
        AppointmentTest.deleteAppointment(this.getWebConversation(), targetId, folderId, this.getHostName(), this.getSessionId(), false);
    }

    public void testDeleteWithNonExisting() throws Exception {
        TimeZone timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
        Calendar c = TimeTools.createCalendar(timeZone);
        FolderObject folderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        int folderId = folderObj.getObjectID();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDeleteWithNonExisting");
        appointmentObj.setStartDate(c.getTime());
        c.add(10, 1);
        appointmentObj.setEndDate(c.getTime());
        appointmentObj.setShownAs(3);
        appointmentObj.setAlarm(45);
        appointmentObj.setParentFolderID(folderId);
        appointmentObj.setIgnoreConflicts(true);
        int targetId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, timeZone, this.getHostName(), this.getSessionId());
        ReminderObject[] reminderObj = DeleteTest.listReminder(this.getWebConversation(), c.getTime(), timeZone, this.getHostName(), this.getSessionId());
        int pos = -1;
        for (int a = 0; a < reminderObj.length; ++a) {
            if (reminderObj[a].getTargetId() != targetId) continue;
            pos = a;
        }
        DeleteTest.assertNotSame((String)"Reminder not found.", (Object)-1, (Object)pos);
        int[] failedObjects = DeleteTest.deleteReminder(this.getWebConversation(), reminderObj[pos].getObjectId() + 1000, this.getHostName(), this.getSessionId());
        DeleteTest.assertTrue((String)"failed object size is not > 0", (failedObjects.length > 0 ? 1 : 0) != 0);
        DeleteTest.assertEquals((String)"fail object id not equals expected", (int)(reminderObj[pos].getObjectId() + 1000), (int)failedObjects[0]);
        AppointmentTest.deleteAppointment(this.getWebConversation(), targetId, folderId, this.getHostName(), this.getSessionId(), false);
    }
}

